// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node.Barcode = (function(superClass) {
  extend(Barcode, superClass);

  function Barcode() {
    return Barcode.__super__.constructor.apply(this, arguments);
  }

  Barcode.getName = function() {
    return "barcode";
  };

  Barcode.prototype.__renderPdfContent = function(opts) {
    var barcode, barcodeData, barcodeWidth, data, fieldNameSplit, getData, img, object;
    object = opts.object;
    if (!object) {
      return;
    }
    data = this.getData();
    if (!data.field_name) {
      return;
    }
    fieldNameSplit = data.field_name.split(".");
    barcodeData = null;
    getData = (function(_this) {
      return function(_data, fieldNames) {
        var name, value;
        name = fieldNames[0];
        value = _data[name];
        if (CUI.util.isString(value)) {
          barcodeData = value;
          return;
        }
        fieldNames = fieldNames.slice(1);
        if (CUI.util.isPlainObject(value)) {
          getData(value, fieldNames);
        }
      };
    })(this);
    getData(object, fieldNameSplit);
    if (!barcodeData) {
      return;
    }
    barcode = new ez5.Barcode({
      mode: "pdf",
      type: data.code_type,
      barcode_type: data.barcode_type
    });
    barcode.render(barcodeData);
    barcodeWidth = data.barcode_width || "100%";
    img = CUI.dom.findElement(barcode.DOM, "img");
    CUI.dom.setStyle(img, {
      width: barcodeWidth
    });
    return img;
  };

  Barcode.prototype.__getSettingsFields = function() {
    var fields, idObjecttype;
    idObjecttype = this.__getIdObjecttype();
    fields = ez5.BarcodeMaskSplitter.getBarcodeOptions(idObjecttype, {
      store_value: "fullname",
      filter: function(field) {
        return !field.insideNested();
      }
    });
    fields.push({
      type: CUI.Input,
      name: "barcode_width",
      form: {
        label: $$("pdf-creator.settings.barcode.barcode-width|text")
      },
      placeholder: $$("pdf-creator.settings.barcode.barcode-width|placeholder")
    });
    return fields;
  };

  Barcode.prototype.__getStyleSettings = function() {
    return ["class-name"];
  };

  return Barcode;

})(ez5.PdfCreator.Node);

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.Barcode);
