# Name should be ez5.PdfCreator.PdfFieldsFormNode but it would be necessary to change the 'new window' usage in FieldsFormNode.
class PdfFieldsFormNode extends FieldsFormNode

	getModeForNested: ->
		"all"

	renderContent: ->
		setState = (event) =>
			@setCheckbox(@data._enabled)
			if not event.ctrlKey()
				@setChildren(@data._enabled)

			if event.altKey() or event.shiftKey()
				for sibling in @father.children
					sibling.setCheckbox(@data._enabled)
					if not event.ctrlKey()
						sibling.setChildren(@data._enabled)
			return

		@checkbox = new CUI.Checkbox
			name: "_enabled"
			undo_and_changed_support: false
			data: @data
			onClick: (event) =>
				setState(event)
				return
		@checkbox.start()

		nameLocalizedOutput = new CUI.Output
			name: "name_localized"
			data: @data
		nameLocalizedOutput.start()

		nameOutput = new CUI.Output
			name: "name"
			data: @data
			class: "cui-label-appearance-secondary" # There is no way to set the appearance to the label within the Output.
		nameOutput.start()

		nameColumn = new CUI.VerticalList
			content: [nameLocalizedOutput, nameOutput]

		CUI.Events.listen
			node: nameColumn
			type: "click"
			call: (event) =>
				@data._enabled = !@data._enabled
				setState(event)
				return

		CUI.dom.setAttribute(nameColumn, 'data-label-clickable', '1')

		nameLocalizedInput = new CUI.MultiInput
			name: "label"
			data: @data
			maximize_horizontal: true
			control: ez5.loca.getLanguageControl()
		nameLocalizedInput.start()

		row = CUI.dom.table_one_row(@checkbox, nameColumn, nameLocalizedInput)

		CUI.Events.listen
			node: row
			type: "click"
			call: (ev) =>
				ev.stopPropagation()
				return

		@setCheckbox(@data._enabled)
		return row

	nodeAdded: (level) ->
		super(level)

		fieldFullName = @getFieldFullName()
		if not @_data[fieldFullName]
			label = {}
			label[ez5.loca.getLanguage()] = @field.nameLocalized()

			@_data[fieldFullName] =
				_enabled: false
				label: label
				name_localized: @field.nameLocalized()
				name: @field.name()

		@data = @_data[fieldFullName]
		return

	# Copied from ExportManagerFieldTreeNode.coffee
	setChildren: (isEnabled) ->
		if not @children
			return
		for c in @children
			c.setCheckbox(isEnabled)
			c.setChildren(isEnabled)

	setCheckbox: (isEnabled) ->
		if @__hidden
			return @

		@data._enabled = isEnabled
		@checkbox?.displayValue()

		if @father and @father.checkbox and @father.isOpen()
			if not @father.children.some((childNode) => childNode.checkbox?.getValue())
				@father.setCheckbox(false)
			else
				@father.setCheckbox(true)
		@

	open: ->
		super().done(=>
			if not @children
				return
			for node in @children
				if node.isHidden()
					node.hide()
		)

	isHidden: ->
		return @__hidden

	hide: ->
		@__hidden = true
		element = @columns[0]?.getElement()
		if not element
			return
		CUI.dom.hideElement(element)
		return

	show: ->
		@__hidden = false
		element = @columns[0]?.getElement()
		if not element
			return
		CUI.dom.showElement(element)
		return

	getFieldFullName: ->
		if @father
			return @father.getFieldFullName() + "." + @field.name()
		return @field.fullName()

	getLinkedObjectRenderDepth: ->
		return 2