// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.ObjecttypePlugin = (function(superClass) {
  extend(ObjecttypePlugin, superClass);

  function ObjecttypePlugin() {
    return ObjecttypePlugin.__super__.constructor.apply(this, arguments);
  }

  ObjecttypePlugin.prototype.getTab = function() {
    var tab;
    if (!ez5.session.hasSystemRight("root", "plugin.pdf-creator.show_pdf_creator")) {
      return;
    }
    tab = {
      padded: false,
      name: "pdf_creator",
      text: $$("admin.objecttype.tab.pdf_creator"),
      content: (function(_this) {
        return function() {
          return _this.__renderPdfCreatorTab();
        };
      })(this)
    };
    return tab;
  };

  ObjecttypePlugin.prototype.onLoad = function() {
    var data;
    data = this.__getData();
    if (!data.objecttype.custom_data.webfrontend.pdf_creator) {
      data.objecttype.custom_data.webfrontend.pdf_creator = {};
    }
  };

  ObjecttypePlugin.prototype.getSaveData = function(saveData) {
    saveData.objecttype.custom_data.webfrontend.pdf_creator = this.__getDataWithoutEmptyFields();
  };

  ObjecttypePlugin.prototype.__renderPdfCreatorTab = function() {
    var pdfCreator, preferredMaskId, ref;
    preferredMaskId = (ref = ez5.schema.CURRENT._objecttype_by_name[this.__getData().objecttype.name]._preferred_mask) != null ? ref.mask_id : void 0;
    pdfCreator = new ez5.PdfCreator({
      data: this.__getData().objecttype.custom_data.webfrontend.pdf_creator,
      idObjecttype: this.__getData().objecttype._id,
      idMask: preferredMaskId
    });
    return pdfCreator.renderList();
  };

  ObjecttypePlugin.prototype.__getDataWithoutEmptyFields = function() {
    var data, i, len, ref, removeDisabledFieldsOnFieldsNode, template;
    data = CUI.util.copyObject(this.__getData().objecttype.custom_data.webfrontend.pdf_creator, true);
    this.__removedFields = 0;
    removeDisabledFieldsOnFieldsNode = (function(_this) {
      return function(parent) {
        var child, i, k, len, ref, results, v;
        ref = parent.children || [];
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          child = ref[i];
          if (child.children) {
            removeDisabledFieldsOnFieldsNode(child);
          }
          if (child.name === "field") {
            results.push((function() {
              var ref1, ref2, results1;
              ref2 = (ref1 = child.data) != null ? ref1.dataFields : void 0;
              results1 = [];
              for (k in ref2) {
                v = ref2[k];
                if (!v._enabled) {
                  this.__removedFields++;
                  results1.push(delete child.data.dataFields[k]);
                } else {
                  results1.push(void 0);
                }
              }
              return results1;
            }).call(_this));
          } else {
            results.push(void 0);
          }
        }
        return results;
      };
    })(this);
    ref = data.templates || [];
    for (i = 0, len = ref.length; i < len; i++) {
      template = ref[i];
      removeDisabledFieldsOnFieldsNode(template.documentData);
    }
    if (this.__removedFields > 0) {
      console.warn(this.__removedFields + " fields were removed from templated because they are empty");
    }
    return data;
  };

  return ObjecttypePlugin;

})(ez5.ObjecttypePlugin);

Objecttype.plugins.registerPlugin(ez5.PdfCreator.ObjecttypePlugin);
