class BaseMigrationNodePresets extends BaseMigrationNodeData

	getDisplayText: ->
		$$("base.migration.node.presets.text")

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	checkMigrateButton: ->
		@__migrateBtn.enable()

	getActionFields: ->
		[
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$("base.migration.common.options")
			options: [
				text: $$("base.migration.common.replace")
				value: "replace"
			,
				text: $$("base.migration.common.add")
				value: "add"
			]
		]

	migrate: (ev, actionData) ->
		migratePromises = []
		for child in @children
			migratePromises.push(child.migrate(ev, actionData))
		return CUI.when(migratePromises)