// Generated by CoffeeScript 1.12.7
var CustomDataTypeGeonames,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeGeonames = (function(superClass) {
  extend(CustomDataTypeGeonames, superClass);

  function CustomDataTypeGeonames() {
    return CustomDataTypeGeonames.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeGeonames.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-geonames.geonames";
  };

  CustomDataTypeGeonames.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.geonames.name");
  };

  CustomDataTypeGeonames.prototype.getFrontendLanguage = function() {
    var desiredLanguage;
    desiredLanguage = ez5.loca.getLanguage();
    desiredLanguage = desiredLanguage.split('-');
    desiredLanguage = desiredLanguage[0];
    return desiredLanguage;
  };

  CustomDataTypeGeonames.prototype.renderSearchInput = function(data) {
    var form, that;
    that = this;
    if (!data[this.name()]) {
      data[this.name()] = {};
    }
    form = this.renderEditorInput(data, '', {});
    CUI.Events.listen({
      type: "data-changed",
      node: form,
      call: (function(_this) {
        return function() {
          return CUI.Events.trigger({
            type: "search-input-change",
            node: form
          });
        };
      })(this)
    });
    return form.DOM;
  };

  CustomDataTypeGeonames.prototype.getSearchFilter = function(data, key) {
    var filter, givenGeonamesID, givenURI, givenURIParts, ref, that, uri;
    if (key == null) {
      key = this.name();
    }
    that = this;
    if (data[this.name()] === void 0 || data[this.name()] === {} || data[this.name()] === null) {
      return;
    }
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".conceptName"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    }
    filter = null;
    if ((ref = data[this.name()]) != null ? ref.conceptURI : void 0) {
      givenURI = data[this.name()].conceptURI;
      givenURIParts = givenURI.split('/');
      givenGeonamesID = givenURIParts.pop();
      uri = 'http://www.geonames.org/' + givenGeonamesID;
      filter = {
        type: "complex",
        search: [
          {
            type: "in",
            mode: "token",
            bool: "must",
            phrase: false,
            fields: [this.path() + '.' + this.name() + ".conceptURI"],
            "in": [uri]
          }
        ]
      };
    }
    return filter;
  };

  CustomDataTypeGeonames.prototype.getQueryFieldBadge = function(data) {
    var ref, value;
    if (!data[this.name()]) {
      value = $$("field.search.badge.without");
    } else if (!((ref = data[this.name()]) != null ? ref.conceptURI : void 0)) {
      value = $$("field.search.badge.without");
    } else {
      value = data[this.name()].conceptName;
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeGeonames.prototype.__getAdditionalTooltipInfo = function(uri, tooltip, extendedInfo_xhr) {
    var geonamesID, geonamesURI, that;
    that = this;
    geonamesURI = uri;
    geonamesID = decodeURIComponent(uri);
    geonamesID = geonamesID.split("/");
    geonamesID = geonamesID.pop();
    if (extendedInfo_xhr.xhr !== void 0) {
      extendedInfo_xhr.xhr.abort();
    }
    extendedInfo_xhr.xhr = new CUI.XHR({
      url: location.protocol + '//uri.gbv.de/terminology/geonames/' + geonamesID + '?format=json'
    });
    extendedInfo_xhr.xhr.start().done(function(data, status, statusText) {
      var bounds, coord1, coord2, encodedGeoJSON, htmlContent, imageSrc, json, jsonStr, mapbox_api_key, ref, ref1, size, value, vp;
      htmlContent = '<span style="padding: 10px 10px 0px 10px; font-weight: bold">' + $$('custom.data.type.geonames.config.parameter.mask.infopop.info.label') + '</span>';
      coord1 = 0;
      coord1 = 0;
      if (data.lat) {
        coord1 = data.lat;
      }
      if (data.lat) {
        coord2 = data.lng;
      }
      if ((ref = that.getCustomSchemaSettings().mapbox_api_key) != null ? ref.value : void 0) {
        mapbox_api_key = (ref1 = that.getCustomSchemaSettings().mapbox_api_key) != null ? ref1.value : void 0;
        if (coord1 !== 0 & coord2 !== 0) {
          value = JSON.parse('{"geometry": {"type": "Point","coordinates": [' + coord2 + ',' + coord1 + ']}}');
          jsonStr = '{"type": "FeatureCollection","features": []}';
          json = JSON.parse(jsonStr);
          json.features.push(value);
          bounds = geojsonExtent(json);
          if (bounds) {
            size = [500, 300];
            vp = geoViewport.viewport(bounds, size);
            encodedGeoJSON = value;
            encodedGeoJSON.properties = {};
            encodedGeoJSON.type = "Feature";
            encodedGeoJSON.properties['stroke-width'] = 4;
            encodedGeoJSON.properties['stroke'] = '#C20000';
            encodedGeoJSON = JSON.stringify(encodedGeoJSON);
            encodedGeoJSON = encodeURIComponent(encodedGeoJSON);
            if (vp.zoom > 16) {
              vp.zoom = 12;
            }
            imageSrc = 'https://api.mapbox.com/styles/v1/mapbox/satellite-streets-v9/static/geojson(' + encodedGeoJSON + ')/' + vp.center.join(',') + ',' + vp.zoom + '/' + size.join('x') + '@2x?access_token=' + mapbox_api_key;
            htmlContent += '<div style="width:400px; height: 250px; background-size: contain; background-image: url(\'' + imageSrc + '\'); background-repeat: no-repeat; background-position: center center;"></div>';
          }
        }
      }
      htmlContent += '<table style="border-spacing: 10px; border-collapse: separate;">';
      if (data.name) {
        if (typeof data.name !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.name.label') + ':</td><td>' + data.name + '</td></tr>';
        }
      }
      if (data.adminName4) {
        if (typeof data.adminName4 !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.einteilung4.label') + ':</td><td>' + data.adminName4 + '</td></tr>';
        }
      }
      if (data.adminName3) {
        if (typeof data.adminName3 !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.einteilung3.label') + ':</td><td>' + data.adminName3 + '</td></tr>';
        }
      }
      if (data.adminName2) {
        if (typeof data.adminName2 !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.einteilung2.label') + ':</td><td>' + data.adminName2 + '</td></tr>';
        }
      }
      if (data.adminName1) {
        if (typeof data.adminName1 !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.einteilung1.label') + ':</td><td>' + data.adminName1 + '</td></tr>';
        }
      }
      if (data.countryName) {
        if (typeof data.countryName !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.land.label') + ':</td><td>' + data.countryName + '</td></tr>';
        }
      }
      if (data.continentCode) {
        if (typeof data.continentCode !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.kontinent.label') + ':</td><td>' + data.continentCode + '</td></tr>';
        }
      }
      if (data.population) {
        if (typeof data.population !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.einwohner.label') + ':</td><td>' + data.population + '</td></tr>';
        }
      }
      if (data.fclName) {
        if (typeof data.fclName !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.typ.label') + ':</td><td>' + data.fclName + '</td></tr>';
        }
      }
      if (data.timezone) {
        if (typeof data.timezone !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.geonames.config.parameter.mask.infopop.zeitzone.label') + ':</td><td>' + data.timezone + '</td></tr>';
        }
      }
      tooltip.DOM.innerHTML = htmlContent;
      return tooltip.autoSize();
    });
  };

  CustomDataTypeGeonames.prototype.__getFeaturecodesFromDANTE = function(thisSelect, featureclassCode) {
    var dfr, searchsuggest_xhr, values;
    dfr = new CUI.Deferred();
    values = [];
    searchsuggest_xhr = new CUI.XHR({
      url: 'https://api.dante.gbv.de/suggest?search=&voc=place_type_geonames&language=' + this.getFrontendLanguage() + '&limit=1000&cache=1'
    });
    searchsuggest_xhr.start().done(function(data, status, statusText) {
      var codeNotation, featureClassCodeExtraction, i, item, key, len, ref, select_items, suggestion, uriParts;
      select_items = [];
      item = {
        text: $$('custom.data.type.geonames.config.parameter.mask.config_featurecodes.all.label'),
        value: null
      };
      select_items.push(item);
      ref = data[1];
      for (key = i = 0, len = ref.length; i < len; key = ++i) {
        suggestion = ref[key];
        uriParts = data[3][key];
        uriParts = uriParts.split('.');
        codeNotation = uriParts.pop();
        featureClassCodeExtraction = uriParts[2].split('#');
        featureClassCodeExtraction = featureClassCodeExtraction[1];
        if ((featureClassCodeExtraction === featureclassCode) || featureclassCode === '' || !featureclassCode || featureclassCode === null) {
          item = {
            text: suggestion,
            value: codeNotation
          };
          select_items.push(item);
        }
      }
      thisSelect.enable();
      return dfr.resolve(select_items);
    });
    return dfr.promise();
  };

  CustomDataTypeGeonames.prototype.showEditPopover = function(btn, data, cdata, layout, opts) {
    var cdata_form, searchsuggest_xhr, suggest_Menu, that;
    that = this;
    suggest_Menu;
    searchsuggest_xhr = {
      "xhr": void 0
    };
    cdata.countOfSuggestions = 50;
    cdata_form = new CUI.Form({
      "class": 'cdtFormWithPadding',
      data: cdata,
      fields: that.__getEditorFields(cdata),
      onDataChanged: (function(_this) {
        return function(data, elem) {
          var defaultText, featureclassParameter, ref, ref1, ref2, ref3;
          if (((ref = _this.getCustomMaskSettings().config_featureclasses) != null ? ref.value : void 0) && ((ref1 = _this.getCustomMaskSettings().config_featurecodes) != null ? ref1.value : void 0)) {
            if (elem.opts.name === 'geonamesSelectFeatureClasses') {
              featureclassParameter = '';
              if ((data != null ? data.geonamesSelectFeatureClasses : void 0) !== '' && (data != null ? data.geonamesSelectFeatureClasses : void 0) !== null) {
                featureclassParameter = data.geonamesSelectFeatureClasses;
              }
              data.geonamesSelectFeatureCodes = null;
              cdata.geonamesSelectFeatureCodes = null;
              if ((ref2 = cdata_form.getFieldsByName("geonamesSelectFeatureCodes")[0]) != null) {
                ref2.setValue(null);
              }
              defaultText = cdata_form.getFieldsByName("geonamesSelectFeatureCodes")[0].default_opt.text;
              cdata_form.getFieldsByName("geonamesSelectFeatureCodes")[0].reload();
              if ((ref3 = cdata_form.getFieldsByName("geonamesSelectFeatureCodes")[0]) != null) {
                ref3.setText('test');
              }
            }
          }
          _this.__updateResult(cdata, layout, opts);
          _this.__setEditorFieldStatus(cdata, layout);
          return _this.__updateSuggestionsMenu(cdata, cdata_form, data.searchbarInput, elem, suggest_Menu, searchsuggest_xhr, layout, opts);
        };
      })(this)
    }).start();
    suggest_Menu = new CUI.Menu({
      element: cdata_form.getFieldsByName("searchbarInput")[0],
      use_element_width_as_min_width: true,
      "class": "customDataTypeCommonsMenu"
    });
    return this.popover = new CUI.Popover({
      element: btn,
      placement: "wn",
      "class": "commonPlugin_Popover",
      pane: {
        header_left: new CUI.Label({
          text: $$('custom.data.type.commons.popover.choose.label')
        }),
        content: cdata_form
      }
    }).show();
  };

  CustomDataTypeGeonames.prototype.__updateSuggestionsMenu = function(cdata, cdata_form, searchstring, input, suggest_Menu, searchsuggest_xhr, layout, opts) {
    var delayMillisseconds, that;
    that = this;
    delayMillisseconds = 200;
    return setTimeout((function() {
      var ancestorsQuery, countryQuery, expandQuery, expandStatus, extendedInfo_xhr, geonames_countSuggestions, geonames_country, geonames_featureclass, geonames_featurecode, geonames_searchterm, ref, ref1, ref2;
      geonames_searchterm = searchstring;
      geonames_countSuggestions = 50;
      geonames_featureclass = '';
      geonames_featurecode = '';
      geonames_country = '';
      expandQuery = '';
      if (cdata_form) {
        geonames_searchterm = cdata_form.getFieldsByName("searchbarInput")[0].getValue();
        geonames_featureclass = (ref = cdata_form.getFieldsByName("geonamesSelectFeatureClasses")[0]) != null ? ref.getValue() : void 0;
        if (geonames_featureclass === void 0 || geonames_featureclass === null) {
          geonames_featureclass = '';
        }
        geonames_featurecode = (ref1 = cdata_form.getFieldsByName("geonamesSelectFeatureCodes")[0]) != null ? ref1.getValue() : void 0;
        if (geonames_featurecode === void 0 || geonames_featurecode === null) {
          geonames_featurecode = '';
        }
        geonames_countSuggestions = cdata_form.getFieldsByName("countOfSuggestions")[0].getValue();
        expandStatus = cdata_form.getFieldsByName("expandSearchCheckbox")[0].getValue();
        expandQuery = '&expand=' + expandStatus;
      }
      if (geonames_searchterm.length === 0) {
        return;
      }
      countryQuery = '';
      if (cdata != null ? cdata.geonamesSelectCountry : void 0) {
        countryQuery = '&country=' + cdata.geonamesSelectCountry;
      }
      ancestorsQuery = '&ancestors=false';
      if ((ref2 = that.getCustomMaskSettings().use_ancestors) != null ? ref2.value : void 0) {
        ancestorsQuery = '&ancestors=true';
      }
      extendedInfo_xhr = {
        "xhr": void 0
      };
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      searchsuggest_xhr.xhr = new CUI.XHR({
        url: location.protocol + '//ws.gbv.de/suggest/geonames2/?searchterm=' + geonames_searchterm + '&language=' + that.getFrontendLanguage() + '&featureclass=' + geonames_featureclass + '&featurecode=' + geonames_featurecode + '&count=' + geonames_countSuggestions + countryQuery + expandQuery + ancestorsQuery
      });
      return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
        var fn, i, itemList, key, len, menu_items, ref3, suggestion;
        menu_items = [];
        ref3 = data[1];
        fn = function(key) {
          var aktType, item, lastType;
          aktType = data[2][key];
          lastType = '';
          if (key > 0) {
            lastType = data[2][key - 1];
          }
          if (aktType !== lastType) {
            item = {
              divider: true
            };
            menu_items.push(item);
            item = {
              label: aktType
            };
            menu_items.push(item);
            item = {
              divider: true
            };
            menu_items.push(item);
          }
          item = {
            text: suggestion,
            value: data[3][key],
            tooltip: {
              markdown: true,
              placement: "e",
              content: function(tooltip) {
                that.__getAdditionalTooltipInfo(data[3][key], tooltip, extendedInfo_xhr);
                return new CUI.Label({
                  icon: "spinner",
                  text: "lade Informationen"
                });
              }
            }
          };
          return menu_items.push(item);
        };
        for (key = i = 0, len = ref3.length; i < len; key = ++i) {
          suggestion = ref3[key];
          fn(key);
        }
        itemList = {
          keyboardControl: true,
          onClick: function(ev2, btn) {
            var dataEntry_xhr, encodedURL, geonamesID, geonamesUsername, ref4;
            cdata.conceptURI = btn.getOpt("value");
            cdata.conceptName = btn.getText();
            cdata._fulltext = {};
            cdata._standard = {};
            cdata._fulltext.text = cdata.conceptName;
            cdata._standard.text = cdata.conceptName;
            geonamesUsername = '';
            if ((ref4 = that.getCustomSchemaSettings().geonames_username) != null ? ref4.value : void 0) {
              geonamesUsername = that.getCustomSchemaSettings().geonames_username.value;
              geonamesID = cdata.conceptURI;
              geonamesID = geonamesID.replace('http://www.geonames.org/', '');
              encodedURL = encodeURIComponent('http://api.geonames.org/getJSON?formatted=true&geonameId=' + geonamesID + '&username=' + geonamesUsername + '&style=full');
              dataEntry_xhr = new CUI.XHR({
                url: location.protocol + '//jsontojsonp.gbv.de/?url=' + encodedURL
              });
              return dataEntry_xhr.start().done(function(data, status, statusText) {
                cdata.conceptName = ez5.GeonamesUtil.getConceptNameFromObject(data);
                cdata.conceptURI = ez5.GeonamesUtil.getConceptURIFromObject(data);
                cdata._fulltext = ez5.GeonamesUtil.getFullTextFromObject(data, false);
                cdata._standard = ez5.GeonamesUtil.getStandardTextFromObject(that, data, cdata, false);
                cdata.conceptAncestors = ez5.GeonamesUtil.getConceptAncestorsFromObject(data);
                that.__updateResult(cdata, layout, opts);
                suggest_Menu.hide();
                if (that.popover) {
                  return that.popover.hide();
                }
              });
            } else {
              that.__updateResult(cdata, layout, opts);
              suggest_Menu.hide();
              if (that.popover) {
                return that.popover.hide();
              }
            }
          },
          items: menu_items
        };
        if (itemList.items.length === 0) {
          itemList = {
            items: [
              {
                text: "kein Treffer",
                value: void 0
              }
            ]
          };
        }
        suggest_Menu.setItemList(itemList);
        return suggest_Menu.show();
      });
    }), delayMillisseconds);
  };

  CustomDataTypeGeonames.prototype.__getEditorFields = function(cdata) {
    var countryCodeOption, countryCodeOptions, countrycode, defaultCountryCode, featureclassesOptions, field, fields, i, len, ref, ref1, ref2, ref3, ref4, that;
    that = this;
    fields = [
      {
        type: CUI.Select,
        "class": "commonPlugin_Select",
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.geonames.modal.form.text.count')
        },
        options: [
          {
            value: 10,
            text: '10 ' + $$('custom.data.type.geonames.modal.form.text.count_short')
          }, {
            value: 20,
            text: '20 ' + $$('custom.data.type.geonames.modal.form.text.count_short')
          }, {
            value: 50,
            text: '50 ' + $$('custom.data.type.geonames.modal.form.text.count_short')
          }, {
            value: 100,
            text: '100 ' + $$('custom.data.type.geonames.modal.form.text.count_short')
          }
        ],
        name: 'countOfSuggestions'
      }, {
        type: CUI.Checkbox,
        "class": "commonPlugin_Checkbox",
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.geonames.modal.form.text.expand')
        },
        name: 'expandSearchCheckbox'
      }, {
        type: CUI.Input,
        "class": "commonPlugin_Input",
        undo_and_changed_support: false,
        form: {
          label: $$("custom.data.type.geonames.modal.form.text.searchbar")
        },
        placeholder: $$("custom.data.type.geonames.modal.form.text.searchbar.placeholder"),
        name: "searchbarInput"
      }
    ];
    countryCodeOptions = [
      {
        value: '',
        text: $$('custom.data.type.geonames.country.name.all')
      }
    ];
    if ((ref = that.getCustomMaskSettings().default_expand) != null ? ref.value : void 0) {
      cdata.expandSearchCheckbox = that.getCustomMaskSettings().default_expand.value;
    }
    if ((ref1 = this.getCustomMaskSettings().default_country_code) != null ? ref1.value : void 0) {
      defaultCountryCode = (ref2 = this.getCustomMaskSettings().default_country_code) != null ? ref2.value : void 0;
      defaultCountryCode = defaultCountryCode.toLowerCase();
      cdata.geonamesSelectCountry = defaultCountryCode;
    } else {
      cdata.geonamesSelectCountry = '';
    }
    for (i = 0, len = geonamesCountryCodes.length; i < len; i++) {
      countrycode = geonamesCountryCodes[i];
      countryCodeOption = {
        value: countrycode,
        text: $$('custom.data.type.geonames.country.name.' + countrycode)
      };
      countryCodeOptions.push(countryCodeOption);
    }
    field = {
      type: CUI.Select,
      undo_and_changed_support: false,
      form: {
        label: $$('custom.data.type.geonames.modal.form.text.countrys')
      },
      options: countryCodeOptions,
      name: 'geonamesSelectCountry',
      "class": 'commonPlugin_Select'
    };
    fields.unshift(field);
    if ((ref3 = this.getCustomMaskSettings().config_featurecodes) != null ? ref3.value : void 0) {
      field = {
        type: CUI.Select,
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.geonames.modal.form.text.featurecodes')
        },
        name: 'geonamesSelectFeatureCodes',
        "class": 'commonPlugin_Select',
        options: (function(_this) {
          return function(thisSelect) {
            var featureclassParameter;
            featureclassParameter = '';
            if ((cdata != null ? cdata.geonamesSelectFeatureClasses : void 0) !== '' && (cdata != null ? cdata.geonamesSelectFeatureClasses : void 0) !== null) {
              featureclassParameter = cdata.geonamesSelectFeatureClasses;
            }
            return that.__getFeaturecodesFromDANTE(thisSelect, featureclassParameter);
          };
        })(this)
      };
      fields.unshift(field);
    }
    if ((ref4 = this.getCustomMaskSettings().config_featureclasses) != null ? ref4.value : void 0) {
      featureclassesOptions = [
        {
          value: '',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.all.label')
        }, {
          value: 'A',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.a.label')
        }, {
          value: 'H',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.h.label')
        }, {
          value: 'L',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.l.label')
        }, {
          value: 'P',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.p.label')
        }, {
          value: 'R',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.r.label')
        }, {
          value: 'S',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.s.label')
        }, {
          value: 'T',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.t.label')
        }, {
          value: 'U',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.u.label')
        }, {
          value: 'V',
          text: $$('custom.data.type.geonames.config.parameter.mask.config_featureclasses.v.label')
        }
      ];
      field = {
        type: CUI.Select,
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.geonames.modal.form.text.featureclasses')
        },
        options: featureclassesOptions,
        name: 'geonamesSelectFeatureClasses',
        "class": 'commonPlugin_Select'
      };
      fields.unshift(field);
    }
    return fields;
  };

  CustomDataTypeGeonames.prototype.__renderButtonByData = function(cdata) {
    var extendedInfo_xhr, that;
    that = this;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.geonames.edit.no_geonames")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.geonames.edit.no_valid_geonames")
        }).DOM;
    }
    cdata.conceptURI = CUI.parseLocation(cdata.conceptURI).url;
    extendedInfo_xhr = {
      "xhr": void 0
    };
    return new CUI.HorizontalLayout({
      maximize: false,
      left: {
        content: new CUI.Label({
          centered: false,
          multiline: true,
          text: cdata.conceptName
        })
      },
      center: {
        content: new CUI.ButtonHref({
          appearance: "link",
          href: cdata.conceptURI,
          target: "_blank",
          tooltip: {
            markdown: true,
            placement: 'n',
            content: function(tooltip) {
              that.__getAdditionalTooltipInfo(cdata.conceptURI, tooltip, extendedInfo_xhr);
              return new CUI.Label({
                icon: "spinner",
                text: "lade Informationen"
              });
            }
          },
          text: ' '
        })
      },
      right: null
    }).DOM;
  };

  CustomDataTypeGeonames.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var ref, ref1, tags;
    tags = [];
    if ((ref = custom_settings.mapbox_api_key) != null ? ref.value : void 0) {
      tags.push("✓ mapbox-token");
    } else {
      tags.push("✘ mapbox-token");
    }
    if ((ref1 = custom_settings.geonames_username) != null ? ref1.value : void 0) {
      tags.push("✓ geonames-Username");
    } else {
      tags.push("✘ geonames-Username");
    }
    return tags;
  };

  return CustomDataTypeGeonames;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeGeonames);
