// Generated by CoffeeScript 1.12.7
var LocationUtils;

LocationUtils = (function() {
  function LocationUtils() {}

  LocationUtils.getSaveData = function(data) {
    var fullText, mapPosition, position, saveData;
    mapPosition = data != null ? data.mapPosition : void 0;
    position = mapPosition != null ? mapPosition.position : void 0;
    if (!position || !CUI.Map.isValidPosition(position)) {
      return null;
    }
    saveData = {
      mapPosition: mapPosition
    };
    if (!CUI.util.isEmpty(data.displayValue)) {
      saveData.displayValue = data.displayValue;
      fullText = Object.values(data.displayValue).filter(function(value) {
        return !!value;
      }).join(", ");
      saveData._standard = {
        l10ntext: data.displayValue
      };
      saveData._fulltext = {
        l10ntext: data.displayValue,
        text: fullText,
        string: fullText
      };
    }
    if (data.group) {
      saveData.group = data.group;
    }
    return saveData;
  };

  return LocationUtils;

})();
// Generated by CoffeeScript 1.12.7
var LocationUpdate;

LocationUpdate = (function() {
  function LocationUpdate() {}

  LocationUpdate.prototype.__start_update = function(arg) {
    var plugin_config, server_config;
    server_config = arg.server_config, plugin_config = arg.plugin_config;
    return ez5.respondSuccess({
      state: {
        "start_update": new Date().toUTCString()
      }
    });
  };

  LocationUpdate.prototype.__updateData = function(arg) {
    var dataUpdated, i, len, object, objects, objectsToUpdate, plugin_config;
    objects = arg.objects, plugin_config = arg.plugin_config;
    objectsToUpdate = [];
    for (i = 0, len = objects.length; i < len; i++) {
      object = objects[i];
      dataUpdated = LocationUtils.getSaveData(object.data);
      if (CUI.util.isEqual(object.data, dataUpdated)) {
        continue;
      }
      object.data = dataUpdated;
      objectsToUpdate.push(object);
    }
    return ez5.respondSuccess({
      payload: objectsToUpdate
    });
  };

  LocationUpdate.prototype.main = function(data) {
    var i, key, len, ref;
    if (!data) {
      ez5.respondError("custom.data.type.location.update.error.payload-missing");
      return;
    }
    ref = ["action", "server_config", "plugin_config"];
    for (i = 0, len = ref.length; i < len; i++) {
      key = ref[i];
      if (!data[key]) {
        ez5.respondError("custom.data.type.location.update.error.payload-key-missing", {
          key: key
        });
        return;
      }
    }
    if (data.action === "start_update") {
      this.__start_update(data);
    } else if (data.action === "update") {
      if (!data.objects) {
        ez5.respondError("custom.data.type.location.update.error.objects-missing");
        return;
      }
      if (!(data.objects instanceof Array)) {
        ez5.respondError("custom.data.type.location.update.error.objects-not-array");
        return;
      }
      if (!data.state) {
        ez5.respondError("custom.data.type.location.update.error.state-missing");
        return;
      }
      if (!data.batch_info) {
        ez5.respondError("custom.data.type.location.update.error.batch_info-missing");
        return;
      }
      this.__updateData(data);
    } else {
      return ez5.respondError("custom.data.type.location.update.error.invalid-action", {
        action: data.action
      });
    }
  };

  return LocationUpdate;

})();

module.exports = new LocationUpdate();
