// Generated by CoffeeScript 1.12.7
var MarkdownEscape;

MarkdownEscape = (function() {
  function MarkdownEscape() {}

  MarkdownEscape.replacements = [[/\*/g, '\\*', 'asterisks'], [/#/g, '\\#', 'number signs'], [/\//g, '\\/', 'slashes'], [/\(/g, '\\(', 'parentheses'], [/\)/g, '\\)', 'parentheses'], [/\[/g, '\\[', 'square brackets'], [/\]/g, '\\]', 'square brackets'], [/</g, '&lt;', 'angle brackets'], [/>/g, '&gt;', 'angle brackets'], [/_/g, '\\_', 'underscores']];

  MarkdownEscape.escape = function(string, skips) {
    skips = skips || [];
    return this.replacements.reduce((function(_this) {
      return function(string, replacement) {
        var name;
        name = replacement[2];
        if (name && skips.indexOf(name) !== -1) {
          return string;
        } else {
          return string.replace(replacement[0], replacement[1]);
        }
      };
    })(this), string);
  };

  return MarkdownEscape;

})();
// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.DisplayFieldValuesMaskSplitter = (function(superClass) {
  extend(DisplayFieldValuesMaskSplitter, superClass);

  function DisplayFieldValuesMaskSplitter() {
    return DisplayFieldValuesMaskSplitter.__super__.constructor.apply(this, arguments);
  }

  DisplayFieldValuesMaskSplitter.FIELD_NAMES_REGEXP = /%([a-z][a-zA-Z0-9_:\-]{0,61}[a-zA-Z0-9])%/g;

  DisplayFieldValuesMaskSplitter.POOL_ATTR = ["name", "description", "contact"];

  DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA = ["_system_object_id", "_global_object_id", "_uuid", "_created", "_last_modified", "_owner"];

  DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA = ["_version"];

  DisplayFieldValuesMaskSplitter.prototype.isSimpleSplit = function() {
    return true;
  };

  DisplayFieldValuesMaskSplitter.prototype.renderAsField = function() {
    return true;
  };

  DisplayFieldValuesMaskSplitter.prototype.isVisible = function(mode, opts) {
    var isVisible;
    isVisible = DisplayFieldValuesMaskSplitter.__super__.isVisible.call(this, mode, opts);
    return isVisible || mode === "text";
  };

  DisplayFieldValuesMaskSplitter.prototype.getOptions = function() {
    var fields, textHintButton;
    textHintButton = new CUI.Button({
      text: $$("display-field-values.custom.splitter.text.hint-text"),
      appearance: "flat",
      onClick: (function(_this) {
        return function() {
          var addData, attr, content, field, fieldName, fieldNames, j, k, l, lang, len, len1, len2, len3, len4, m, n, node, pop, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, text, topLevelData;
          fieldNames = [];
          ref = _this.father.children;
          for (j = 0, len = ref.length; j < len; j++) {
            node = ref[j];
            fieldName = node.getData().field_name;
            field = (ref1 = node.getData().field) != null ? ref1._column : void 0;
            if (!fieldName || !field) {
              continue;
            }
            if (field.type === "daterange") {
              fieldNames.push(fieldName + ":from");
              fieldNames.push(fieldName + ":to");
            } else if (field.type === "eas") {

            } else if ((ref2 = field.type) === "text_l10n" || ref2 === "text_l10n_oneline") {
              fieldNames.push(fieldName + ":best");
              ref3 = ez5.loca.getDatabaseLanguages();
              for (k = 0, len1 = ref3.length; k < len1; k++) {
                lang = ref3[k];
                fieldNames.push(fieldName + ":" + lang);
              }
              continue;
            } else if (field.type === "link") {
              fieldNames.push(fieldName + ":standard-1");
              fieldNames.push(fieldName + ":standard-2");
              fieldNames.push(fieldName + ":standard-3");
            } else {
              fieldNames.push(fieldName);
            }
          }
          if ((ref4 = _this.maskEditor.current_mask.table) != null ? ref4.pool_link : void 0) {
            ref5 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
            for (l = 0, len2 = ref5.length; l < len2; l++) {
              attr = ref5[l];
              fieldNames.push("pool." + attr);
            }
          }
          ref6 = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
          for (m = 0, len3 = ref6.length; m < len3; m++) {
            topLevelData = ref6[m];
            fieldNames.push("object." + topLevelData);
          }
          ref7 = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
          for (n = 0, len4 = ref7.length; n < len4; n++) {
            addData = ref7[n];
            fieldNames.push("object." + addData);
          }
          fieldNames = fieldNames.concat(fieldNames.map(function(fieldName) {
            return fieldName + ":urlencoded";
          })).sort();
          text = $$("display-field-values.custom.splitter.text.hint-content", {
            fields: fieldNames
          });
          content = new CUI.Label({
            text: text,
            markdown: true
          });
          pop = new ez5.HintPopover({
            element: textHintButton,
            content: content,
            padded: true
          });
          return pop.show();
        };
      })(this)
    });
    fields = [
      {
        type: CUI.Input,
        name: "text",
        min_rows: 9,
        textarea: true,
        maximize_horizontal: true,
        "class": "ez5-display-field-values-text-input",
        form: {
          label: $$("display-field-values.custom.splitter.text.label"),
          hint: textHintButton
        },
        onDataChanged: (function(_this) {
          return function(_, field) {
            CUI.Events.trigger({
              node: field,
              type: "content-resize"
            });
          };
        })(this)
      }, {
        type: CUI.Checkbox,
        name: "output_empty",
        form: {
          label: $$("display-field-values.custom.splitter.output_empty.label")
        }
      }, {
        type: CUI.Checkbox,
        name: "dont_escape_markdown_in_values",
        form: {
          label: $$("display-field-values.custom.splitter.dont_escape_markdown_in_values.label")
        }
      }
    ];
    return fields;
  };

  DisplayFieldValuesMaskSplitter.prototype.getDefaultOptions = function() {
    var defaultOpts;
    defaultOpts = {
      output_empty: false,
      dont_escape_markdown_in_values: false,
      text: ""
    };
    return defaultOpts;
  };

  DisplayFieldValuesMaskSplitter.prototype.renderField = function(opts) {
    var data, dataOptions, fieldNames, label, ref, setText;
    dataOptions = this.getDataOptions();
    if (!dataOptions.text) {
      return;
    }
    data = opts.data;
    fieldNames = this.__getFieldNames(dataOptions.text);
    label = new CUI.Label({
      text: "",
      markdown: true
    });
    setText = (function(_this) {
      return function() {
        var text, values;
        values = _this.__getValues(data, fieldNames);
        if (_this.__hasAnyReplacement(data, values, opts)) {
          label.show();
        } else {
          label.hide();
        }
        text = _this.__getLabelText(dataOptions, values);
        text = _this.__poolReplacement(data, text);
        text = _this.__topLevelDataReplacement(opts.top_level_data, text);
        text = _this.__additionalDataReplacement(data, text);
        return label.setText(text);
      };
    })(this);
    setText();
    if (opts.mode !== "editor" || !((ref = opts.editor) != null ? ref.__mainPane : void 0)) {
      return label;
    }
    CUI.Events.listen({
      type: "editor-changed",
      node: opts.editor.__mainPane,
      call: (function(_this) {
        return function() {
          setText();
        };
      })(this)
    });
    return label;
  };

  DisplayFieldValuesMaskSplitter.prototype.isEnabledForNested = function() {
    return true;
  };

  DisplayFieldValuesMaskSplitter.prototype.__getLabelText = function(dataOptions, values) {
    var _field, _value, bestValue, doReplace, dontEscapeMarkdownInValues, fieldName, i, j, k, key, len, len1, ref, ref1, regexp, replacement, replacements, text, value;
    text = dataOptions.text;
    dontEscapeMarkdownInValues = dataOptions.dont_escape_markdown_in_values;
    replacements = this.__getFieldNames(text, false);
    doReplace = function(field, _value) {
      var regexp;
      regexp = new RegExp("%" + field + ":urlencoded%", "g");
      text = text.replace(regexp, encodeURI(_value));
      if (!dontEscapeMarkdownInValues) {
        _value = MarkdownEscape.escape("" + _value);
      }
      regexp = new RegExp("%" + field + "%", "g");
      return text = text.replace(regexp, _value);
    };
    for (fieldName in values) {
      value = values[fieldName];
      if (CUI.util.isPlainObject(value)) {
        if (value._standard) {
          ref = [1, 2, 3];
          for (j = 0, len = ref.length; j < len; j++) {
            i = ref[j];
            if (!((ref1 = value._standard[i]) != null ? ref1.text : void 0)) {
              continue;
            }
            bestValue = ez5.loca.getBestFrontendValue(value._standard[i].text);
            doReplace(fieldName + ":standard-" + i, bestValue);
          }
        } else {
          bestValue = ez5.loca.getBestFrontendValue(value);
          if (!CUI.util.isEmpty(bestValue) && !CUI.isPlainObject(bestValue)) {
            doReplace(fieldName + ":best", bestValue);
          }
          if (!CUI.util.isEmpty(value.value)) {
            doReplace("" + fieldName, value.value);
          }
          for (key in value) {
            _value = value[key];
            if (CUI.util.isEmpty(_value) || CUI.util.isPlainObject(_value)) {
              continue;
            }
            _field = fieldName + ":" + key;
            doReplace(_field, _value);
          }
        }
      } else {
        doReplace(fieldName, value);
      }
    }
    for (k = 0, len1 = replacements.length; k < len1; k++) {
      replacement = replacements[k];
      regexp = new RegExp("%" + replacement + "%", "g");
      text = text.replace(regexp, "");
    }
    return text;
  };

  DisplayFieldValuesMaskSplitter.prototype.__getValues = function(data, fieldNames) {
    var fieldName, j, len, value, values;
    values = {};
    for (j = 0, len = fieldNames.length; j < len; j++) {
      fieldName = fieldNames[j];
      value = data[fieldName];
      if (CUI.util.isEmpty(value)) {
        continue;
      }
      if (CUI.util.isPlainObject(value)) {
        if (!Object.values(value).some(function(_val) {
          return !CUI.util.isEmpty(_val);
        })) {
          continue;
        }
      }
      values[fieldName] = value;
    }
    return values;
  };

  DisplayFieldValuesMaskSplitter.prototype.__getFieldNames = function(text, removeSuffix) {
    var fieldName, fieldNames, matches, ref, values;
    if (removeSuffix == null) {
      removeSuffix = true;
    }
    fieldNames = new Set();
    matches = text.matchAll(ez5.DisplayFieldValuesMaskSplitter.FIELD_NAMES_REGEXP);
    while (values = (ref = matches.next()) != null ? ref.value : void 0) {
      if (values[1]) {
        fieldName = values[1];
        if (removeSuffix) {
          fieldName = fieldName.replace(/:(.*)/g, "");
        }
        fieldNames.add(fieldName);
      }
    }
    return Array.from(fieldNames);
  };

  DisplayFieldValuesMaskSplitter.prototype.__topLevelDataReplacement = function(topLevelData, text) {
    var j, len, ref, ref1, ref2, ref3, ref4, regexp, topAttr, value;
    if (CUI.util.isEmpty(topLevelData)) {
      return text;
    }
    ref = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
    for (j = 0, len = ref.length; j < len; j++) {
      topAttr = ref[j];
      if (topAttr === "_owner") {
        value = ((ref1 = topLevelData[topAttr]) != null ? (ref2 = ref1.user) != null ? ref2._generated_displayname : void 0 : void 0) || ((ref3 = topLevelData[topAttr]) != null ? (ref4 = ref3.group) != null ? ref4._generated_displayname : void 0 : void 0);
        if (CUI.util.isEmpty(value)) {
          regexp = new RegExp("%object." + topAttr + "%", "g");
          text = text.replace(regexp, "");
          regexp = new RegExp("%object." + topAttr + ":urlencoded%", "g");
          text = text.replace(regexp, "");
          continue;
        }
      } else {
        value = topLevelData[topAttr];
      }
      if (topAttr === "_created" || topAttr === "_last_modified") {
        value = ez5.format_date_and_time(value);
      }
      regexp = new RegExp("%object." + topAttr + "%", "g");
      text = text.replace(regexp, value);
      regexp = new RegExp("%object." + topAttr + ":urlencoded%", "g");
      text = text.replace(regexp, encodeURI(value));
    }
    return text;
  };

  DisplayFieldValuesMaskSplitter.prototype.__additionalDataReplacement = function(data, text) {
    var addAttr, j, len, ref, regexp, value;
    if (CUI.util.isEmpty(data)) {
      return text;
    }
    ref = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
    for (j = 0, len = ref.length; j < len; j++) {
      addAttr = ref[j];
      value = data[addAttr];
      regexp = new RegExp("%object." + addAttr + "%", "g");
      text = text.replace(regexp, value);
      regexp = new RegExp("%object." + addAttr + ":urlencoded%", "g");
      text = text.replace(regexp, encodeURI(value));
    }
    return text;
  };

  DisplayFieldValuesMaskSplitter.prototype.__poolReplacement = function(data, text) {
    var cleanAndReturn, j, len, poolAttr, poolData, poolObj, ref, ref1, ref2, ref3, regexp, value;
    cleanAndReturn = (function(_this) {
      return function() {
        var j, len, poolAttr, ref, regexp;
        ref = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
        for (j = 0, len = ref.length; j < len; j++) {
          poolAttr = ref[j];
          regexp = new RegExp("%pool." + poolAttr + "%", "g");
          text = text.replace(regexp, "");
          regexp = new RegExp("%pool." + poolAttr + ":urlencoded%", "g");
          text = text.replace(regexp, "");
        }
        return text;
      };
    })(this);
    poolObj = ez5.pools.findPoolById((ref = data._pool) != null ? ref.pool._id : void 0);
    if (!poolObj) {
      return cleanAndReturn();
    }
    poolData = poolObj.data.pool;
    ref1 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
    for (j = 0, len = ref1.length; j < len; j++) {
      poolAttr = ref1[j];
      value = poolData[poolAttr];
      if (CUI.util.isEmpty(value)) {
        value = "";
      } else if (poolAttr === "contact") {
        value = ((ref2 = value.user) != null ? ref2._generated_displayname : void 0) || ((ref3 = value.group) != null ? ref3._generated_displayname("") : void 0);
      } else {
        value = ez5.loca.getBestFrontendValue(value);
      }
      regexp = new RegExp("%pool." + poolAttr + "%", "g");
      text = text.replace(regexp, value);
      regexp = new RegExp("%pool." + poolAttr + ":urlencoded%", "g");
      text = text.replace(regexp, encodeURI(value));
    }
    return text;
  };

  DisplayFieldValuesMaskSplitter.prototype.hasContent = function(opts) {
    return this.__hasPoolReplacement(opts);
  };

  DisplayFieldValuesMaskSplitter.prototype.__hasPoolReplacement = function(opts) {
    var dataOptions, j, len, poolAttr, poolData, poolObj, ref, ref1, ref2, ref3, text, value;
    if ((ref = opts[opts.mode]) != null ? ref.object.mask.table.schema.pool_link : void 0) {
      dataOptions = this.getDataOptions();
      text = dataOptions.text;
      poolObj = ez5.pools.findPoolById((ref1 = opts.data._pool) != null ? ref1.pool._id : void 0);
      poolData = poolObj != null ? (ref2 = poolObj.data) != null ? ref2.pool : void 0 : void 0;
      if (!poolData) {
        return false;
      }
      if (!dataOptions.output_empty && (text != null ? text.length : void 0) > 0) {
        return true;
      }
      ref3 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
      for (j = 0, len = ref3.length; j < len; j++) {
        poolAttr = ref3[j];
        value = poolData[poolAttr];
        if ((text != null ? text.includes("%pool." + poolAttr + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
    }
    return false;
  };

  DisplayFieldValuesMaskSplitter.prototype.__hasAnyReplacement = function(data, values, opts) {
    var addData, j, k, len, len1, ref, ref1, topAttr, value;
    if (opts == null) {
      opts = {};
    }
    if (this.__hasPoolReplacement(opts)) {
      return true;
    }
    if (!CUI.util.isEmpty(values)) {
      return true;
    }
    ref = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
    for (j = 0, len = ref.length; j < len; j++) {
      topAttr = ref[j];
      value = data[topAttr];
      if ((typeof text !== "undefined" && text !== null ? text.includes("%object." + topAttr + "%") : void 0) && !CUI.util.isEmpty(value)) {
        return true;
      }
    }
    ref1 = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
    for (k = 0, len1 = ref1.length; k < len1; k++) {
      addData = ref1[k];
      value = data[addData];
      if ((typeof text !== "undefined" && text !== null ? text.includes("%object." + addData + "%") : void 0) && !CUI.util.isEmpty(value)) {
        return true;
      }
    }
    return false;
  };

  return DisplayFieldValuesMaskSplitter;

})(CustomMaskSplitter);

MaskSplitter.plugins.registerPlugin(ez5.DisplayFieldValuesMaskSplitter);
// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

if (ez5.PdfCreator) {
  ez5.PdfCreator.Node.DisplayFieldValue = (function(superClass) {
    extend(DisplayFieldValue, superClass);

    function DisplayFieldValue() {
      return DisplayFieldValue.__super__.constructor.apply(this, arguments);
    }

    DisplayFieldValue.POOL_ATTR = ["name", "description", "contact"];

    DisplayFieldValue.TOP_LEVEL_DATA = ["_system_object_id", "_global_object_id", "_uuid", "_created", "_last_modified", "_owner"];

    DisplayFieldValue.ADDITIONAL_DATA = ["_version"];

    DisplayFieldValue.getName = function() {
      return "displayFieldValue";
    };

    DisplayFieldValue.prototype.__renderPdfContent = function(opts) {
      var content, data, object, replacementText, replacements, text, values;
      object = opts.object;
      if (!object) {
        return;
      }
      data = this.getData();
      text = data.text;
      replacements = this.__getFieldNames(text);
      values = this.__getValues(object[object._objecttype], replacements);
      if (!this.__hasAnyReplacement(data, values, opts)) {
        return;
      }
      replacementText = this.__getLabelText(values);
      replacementText = this.__poolReplacement(object[object._objecttype], replacementText);
      replacementText = this.__topLevelDataReplacement(object, replacementText);
      replacementText = this.__additionalDataReplacement(object[object._objecttype], replacementText);
      content = new CUI.MultilineLabel({
        text: replacementText,
        markdown: true
      });
      return content;
    };

    DisplayFieldValue.prototype.__getSettingsFields = function() {
      var fields, textHintButton;
      textHintButton = new CUI.Button({
        text: $$("display-field-values.custom.splitter.text.hint-text"),
        appearance: "flat",
        onClick: (function(_this) {
          return function() {
            var addData, attr, content, field, fieldName, fieldNames, j, k, l, lang, len, len1, len2, len3, len4, m, n, pop, ref, ref1, ref2, ref3, ref4, ref5, text, topLevelData, type;
            fieldNames = [];
            ref = _this.__getMask().getFields("all");
            for (j = 0, len = ref.length; j < len; j++) {
              field = ref[j];
              fieldName = field.name();
              if (!fieldName || !((ref1 = field.FieldSchema) != null ? ref1._column : void 0)) {
                continue;
              }
              type = field.FieldSchema._column.type;
              if (type === "boolean") {
                continue;
              } else if (type === "eas") {
                continue;
              } else if (type === "daterange") {
                fieldNames.push(fieldName + ":from");
                fieldNames.push(fieldName + ":to");
              } else if (type === "text_l10n" || type === "text_l10n_oneline") {
                fieldNames.push(fieldName + ":best");
                ref2 = ez5.loca.getDatabaseLanguages();
                for (k = 0, len1 = ref2.length; k < len1; k++) {
                  lang = ref2[k];
                  fieldNames.push(fieldName + ":" + lang);
                }
                continue;
              } else if (type === "link") {
                fieldNames.push(fieldName + ":standard-1");
                fieldNames.push(fieldName + ":standard-2");
                fieldNames.push(fieldName + ":standard-3");
              } else {
                fieldNames.push(fieldName);
              }
            }
            if (_this.__getMask().table.schema.pool_link) {
              ref3 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
              for (l = 0, len2 = ref3.length; l < len2; l++) {
                attr = ref3[l];
                fieldNames.push("pool." + attr);
              }
            }
            ref4 = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
            for (m = 0, len3 = ref4.length; m < len3; m++) {
              topLevelData = ref4[m];
              fieldNames.push("object." + topLevelData);
            }
            ref5 = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
            for (n = 0, len4 = ref5.length; n < len4; n++) {
              addData = ref5[n];
              fieldNames.push("object." + addData);
            }
            fieldNames = fieldNames.concat(fieldNames.map(function(fieldName) {
              return fieldName + ":urlencoded";
            })).sort();
            text = $$("display-field-values.custom.splitter.text.hint-content", {
              fields: fieldNames
            });
            content = new CUI.Label({
              text: text,
              markdown: true
            });
            pop = new ez5.HintPopover({
              element: textHintButton,
              content: content,
              padded: true
            });
            return pop.show();
          };
        })(this)
      });
      fields = [
        {
          type: CUI.Input,
          name: "text",
          min_rows: 9,
          textarea: true,
          maximize_horizontal: true,
          "class": "ez5-display-field-values-text-input",
          form: {
            label: $$("display-field-values.custom.splitter.text.label"),
            hint: textHintButton
          },
          onDataChanged: (function(_this) {
            return function(_, field) {
              CUI.Events.trigger({
                node: field,
                type: "content-resize"
              });
            };
          })(this)
        }, {
          type: CUI.Checkbox,
          name: "output_empty",
          form: {
            label: $$("display-field-values.custom.splitter.output_empty.label")
          }
        }, {
          type: CUI.Checkbox,
          name: "dont_escape_markdown_in_values",
          form: {
            label: $$("display-field-values.custom.splitter.dont_escape_markdown_in_values.label")
          }
        }
      ];
      return fields;
    };

    DisplayFieldValue.prototype.__getLabelText = function(values) {
      var _field, _value, bestValue, data, doReplace, dontEscapeMarkdownInValues, fieldName, i, j, k, key, len, len1, ref, ref1, regexp, replacement, replacements, text, value;
      data = this.getData();
      text = data.text;
      dontEscapeMarkdownInValues = data.dont_escape_markdown_in_values;
      replacements = this.__getFieldNames(text, false);
      doReplace = function(field, _value) {
        var regexp;
        regexp = new RegExp("%" + field + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(_value));
        if (!dontEscapeMarkdownInValues) {
          _value = MarkdownEscape.escape("" + _value);
        }
        regexp = new RegExp("%" + field + "%", "g");
        return text = text.replace(regexp, _value);
      };
      for (fieldName in values) {
        value = values[fieldName];
        if (CUI.util.isPlainObject(value)) {
          if (value._standard) {
            ref = [1, 2, 3];
            for (j = 0, len = ref.length; j < len; j++) {
              i = ref[j];
              if (!((ref1 = value._standard[i]) != null ? ref1.text : void 0)) {
                continue;
              }
              bestValue = ez5.loca.getBestFrontendValue(value._standard[i].text);
              doReplace(fieldName + ":standard-" + i, bestValue);
            }
          } else {
            bestValue = ez5.loca.getBestFrontendValue(value);
            if (!CUI.util.isEmpty(bestValue)) {
              doReplace(fieldName + ":best", bestValue);
            }
            if (!CUI.util.isEmpty(value.value)) {
              doReplace("" + fieldName, value.value);
            }
            for (key in value) {
              _value = value[key];
              if (CUI.util.isEmpty(_value) || CUI.util.isPlainObject(_value)) {
                continue;
              }
              _field = fieldName + ":" + key;
              doReplace(_field, _value);
            }
          }
        } else {
          doReplace(fieldName, value);
        }
      }
      for (k = 0, len1 = replacements.length; k < len1; k++) {
        replacement = replacements[k];
        regexp = new RegExp("%" + replacement + "%", "g");
        text = text.replace(regexp, "");
      }
      return text;
    };

    DisplayFieldValue.prototype.__getValues = function(data, fieldNames) {
      var fieldName, j, len, value, values;
      values = {};
      for (j = 0, len = fieldNames.length; j < len; j++) {
        fieldName = fieldNames[j];
        value = data[fieldName];
        if (CUI.util.isEmpty(value)) {
          continue;
        }
        if (CUI.util.isPlainObject(value)) {
          if (!Object.values(value).some(function(_val) {
            return !CUI.util.isEmpty(_val);
          })) {
            continue;
          }
        }
        values[fieldName] = value;
      }
      return values;
    };

    DisplayFieldValue.prototype.__getFieldNames = function(text, removeSuffix) {
      var fieldName, fieldNames, matches, ref, values;
      if (removeSuffix == null) {
        removeSuffix = true;
      }
      fieldNames = new Set();
      matches = text.matchAll(ez5.DisplayFieldValuesMaskSplitter.FIELD_NAMES_REGEXP);
      while (values = (ref = matches.next()) != null ? ref.value : void 0) {
        if (values[1]) {
          fieldName = values[1];
          if (removeSuffix) {
            fieldName = fieldName.replace(/:(.*)/g, "");
          }
          fieldNames.add(fieldName);
        }
      }
      return Array.from(fieldNames);
    };

    DisplayFieldValue.prototype.__topLevelDataReplacement = function(topLevelData, text) {
      var j, len, ref, ref1, regexp, topAttr, value;
      if (CUI.util.isEmpty(topLevelData)) {
        return text;
      }
      ref = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
      for (j = 0, len = ref.length; j < len; j++) {
        topAttr = ref[j];
        if (topAttr === "_owner") {
          value = (ref1 = topLevelData[topAttr]) != null ? ref1.user._generated_displayname : void 0;
          if (CUI.util.isEmpty(value)) {
            regexp = new RegExp("%object." + topAttr + "%", "g");
            text = text.replace(regexp, "");
            regexp = new RegExp("%object." + topAttr + ":urlencoded%", "g");
            text = text.replace(regexp, "");
            continue;
          }
        } else {
          value = topLevelData[topAttr];
          if (topAttr === "_created" || topAttr === "_last_modified") {
            value = ez5.format_date_and_time(value);
          }
        }
        regexp = new RegExp("%object." + topAttr + "%", "g");
        text = text.replace(regexp, value);
        regexp = new RegExp("%object." + topAttr + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(value));
      }
      return text;
    };

    DisplayFieldValue.prototype.__additionalDataReplacement = function(data, text) {
      var addAttr, j, len, ref, regexp, value;
      if (CUI.util.isEmpty(data)) {
        return text;
      }
      ref = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
      for (j = 0, len = ref.length; j < len; j++) {
        addAttr = ref[j];
        value = data[addAttr];
        regexp = new RegExp("%object." + addAttr + "%", "g");
        text = text.replace(regexp, value);
        regexp = new RegExp("%object." + addAttr + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(value));
      }
      return text;
    };

    DisplayFieldValue.prototype.__poolReplacement = function(data, text) {
      var cleanAndReturn, j, len, poolAttr, poolData, poolObj, ref, ref1, ref2, regexp, value;
      cleanAndReturn = (function(_this) {
        return function() {
          var j, len, poolAttr, ref, regexp;
          ref = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
          for (j = 0, len = ref.length; j < len; j++) {
            poolAttr = ref[j];
            regexp = new RegExp("%pool." + poolAttr + "%", "g");
            text = text.replace(regexp, "");
            regexp = new RegExp("%pool." + poolAttr + ":urlencoded%", "g");
            text = text.replace(regexp, "");
          }
          return text;
        };
      })(this);
      poolObj = ez5.pools.findPoolById((ref = data._pool) != null ? ref.pool._id : void 0);
      if (!poolObj) {
        return cleanAndReturn();
      }
      poolData = poolObj.data.pool;
      ref1 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
      for (j = 0, len = ref1.length; j < len; j++) {
        poolAttr = ref1[j];
        value = poolData[poolAttr];
        if (CUI.util.isEmpty(value)) {
          value = "";
        } else if (poolAttr === "contact") {
          value = ((ref2 = value.user) != null ? ref2._generated_displayname : void 0) || "";
        } else {
          value = ez5.loca.getBestFrontendValue(value);
        }
        regexp = new RegExp("%pool." + poolAttr + "%", "g");
        text = text.replace(regexp, value);
        regexp = new RegExp("%pool." + poolAttr + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(value));
      }
      return text;
    };

    DisplayFieldValue.prototype.__hasPoolReplacement = function(opts) {
      var dataOptions, j, len, poolAttr, poolData, poolObj, ref, ref1, text, value;
      if (!this.__getMask().table.schema.pool_link) {
        return false;
      }
      dataOptions = this.getData();
      text = dataOptions.text;
      poolObj = ez5.pools.findPoolById((ref = opts.object[opts.object._objecttype]._pool) != null ? ref.pool._id : void 0);
      poolData = poolObj.data.pool;
      if (!dataOptions.output_empty && (text != null ? text.length : void 0) > 0) {
        return true;
      }
      if (!poolData) {
        return false;
      }
      ref1 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
      for (j = 0, len = ref1.length; j < len; j++) {
        poolAttr = ref1[j];
        value = poolData[poolAttr];
        if ((text != null ? text.includes("%pool." + poolAttr + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
      return false;
    };

    DisplayFieldValue.prototype.__hasAnyReplacement = function(data, values, opts) {
      var addData, j, k, len, len1, ref, ref1, topAttr, value;
      if (opts == null) {
        opts = {};
      }
      if (this.__hasPoolReplacement(opts)) {
        return true;
      }
      if (!CUI.util.isEmpty(values)) {
        return true;
      }
      ref = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
      for (j = 0, len = ref.length; j < len; j++) {
        topAttr = ref[j];
        value = data[topAttr];
        if ((typeof text !== "undefined" && text !== null ? text.includes("%object." + topAttr + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
      ref1 = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
      for (k = 0, len1 = ref1.length; k < len1; k++) {
        addData = ref1[k];
        value = data[addData];
        if ((typeof text !== "undefined" && text !== null ? text.includes("%object." + addData + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
      return false;
    };

    return DisplayFieldValue;

  })(ez5.PdfCreator.Node);
  ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.DisplayFieldValue);
}
