class Easydb4MigrationPlugin.Gewosued extends Easydb4MigrationPlugin
	name: ->
		"gewosued"

	person_verfuegbar:
		"verfuegbar_abgebildete_personen": "abgebildete Personen"
		"verfuegbar_autor_herausgeber": "Autor / Herausgeber"
		"verfuegbar_behandelte_personen": "behandelte Personen"
		"verfuegbar_planverfasser": "Planverfasser"
		"verfuegbar_provenienz": "Provenienz"
		"verfuegbar_urheber": "Urheber"

	person_typ:
		"typ_person": "Person"
		"typ_koerperschaft": "Körperschaft"

	dublette:
		"qualitaet_dublette": "Dublette"

	payload: (filename, json, update, store_file) ->

		if json.import_type == "tags"
			dfr = new CUI.Deferred()

			add_tag = (name, displayname) =>
				_tags.push
					tag:
						shortname: name
						displayname:
							"de-DE": displayname
						is_default: false
						enabled: true
						displaytype: "search"
						type: "individual"

			# Original/Dublette

			_tags = []

			json.tags.push
				taggroup:
					reference: "easydb4:original_dublette"
					type: "checkbox"
					displayname:
						"de-DE": "Original/Dublette"
				_tags: _tags


			for k, v of @dublette
				add_tag(k, v)


			# Person-Verfügbarkeit

			_tags = []

			json.tags.push
				taggroup:
					reference: "easydb4:person_verfuegbar"
					type: "checkbox"
					displayname:
						"de-DE": "Person-Verfügbarkeit"
				_tags: _tags


			for k, v of @person_verfuegbar
				add_tag(k, v)


			# Person-Typ

			_tags = []

			json.tags.push
				taggroup:
					reference: "easydb4:person_typ"
					type: "checkbox"
					displayname:
						"de-DE": "Person-Typ"
				_tags: _tags


			for k, v of @person_typ
				add_tag(k, v)


			_tags = []

			json.tags.push
				taggroup:
					reference: "easydb4:qualitaet"
					type: "checkbox"
					displayname:
						"de-DE": "Qualität"
				_tags: _tags

			@_migration.query('SELECT id, name FROM "source.public.qualitaet" ORDER BY name')
			.fail(dfr.reject)
			.done (result) =>
				for row in result.rows
					add_tag("qualitaet:"+row.id, row.name)

				_tags = []

				json.tags.push
					taggroup:
						reference: "easydb4:bearbeitgungsstufe"
						type: "checkbox"
						displayname:
							"de-DE": "Bearbeitungsstufe"
					_tags: _tags

				@_migration.query('SELECT id, name FROM "source.public.bearbeitungsstufe" ORDER BY name')
				.fail(dfr.reject)
				.done (result) =>
					for row in result.rows
						add_tag("bearbeitungsstufe:"+row.id, row.name)

					dfr.resolve()
					return

				return

			return dfr.promise()


		if json.objecttype == "person"
			for obj in json.objects

				if not obj._tags
					obj._tags = []

				for k, v of @person_verfuegbar
					if obj.person[k]
						obj._tags.push
							"lookup:_id":
								shortname: k

					delete(obj.person[k])

				for k, v of @person_typ
					if obj.person[k]
						obj._tags.push
							"lookup:_id":
								shortname: k

					delete(obj.person[k])

			return

		if json.objecttype == "assets"
			for obj in json.objects
				if not obj._tags
					obj._tags = []

				if obj.assets.lk_original_dublette_id
					obj._tags.push
						"lookup:_id":
							shortname: "qualitaet_dublette"

				if obj.assets.lk_qualitaet_id
					shortname = obj.assets.lk_qualitaet_id.qualitaet["lookup:_id"].easydb4_reference

					obj._tags.push
						"lookup:_id":
							shortname: shortname

					delete(obj.assets.lk_qualitaet_id)
					delete(obj.assets["lk_qualitaet_id:source_name"])

				if obj.assets.lk_bearbeitungsstufe_id
					shortname = obj.assets.lk_bearbeitungsstufe_id.bearbeitungsstufe["lookup:_id"].easydb4_reference

					obj._tags.push
						"lookup:_id":
							shortname: shortname

					delete(obj.assets.lk_bearbeitungsstufe_id)
					delete(obj.assets["lk_bearbeitungsstufe_id:source_name"])


		if json.objecttype == "verweistyp"
			return @splitByType(filename, json, update, store_file, "verweistyp", "for_pool",
				"verweistyp_plaene": ["verweistyp_plaene", "verweistyp_medien", "verweistyp_dokumente"]
				"verweistyp_medien": ["verweistyp_plaene", "verweistyp_medien", "verweistyp_dokumente"]
				"verweistyp_dokumente": ["verweistyp_plaene", "verweistyp_medien", "verweistyp_dokumente"]
				"verweistyp_undefined": ["verweistyp_plaene", "verweistyp_medien", "verweistyp_dokumente"]
			)

ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.Gewosued)
