// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Easydb4MigrationPlugin.UniStuttgart = (function(superClass) {
  extend(UniStuttgart, superClass);

  function UniStuttgart() {
    return UniStuttgart.__super__.constructor.apply(this, arguments);
  }

  UniStuttgart.prototype.name = function() {
    return "uni-stuttgart";
  };

  UniStuttgart.prototype.init = function() {
    var dfr;
    this.pool_map = {};
    dfr = new CUI.Deferred();
    this._migration.query("SELECT id, name\nFROM \"source.public.pool\"").fail(dfr.reject).done((function(_this) {
      return function(result) {
        var i, len, ref, row;
        ref = result.rows;
        for (i = 0, len = ref.length; i < len; i++) {
          row = ref[i];
          _this.pool_map[row[0]] = row[1];
        }
        return dfr.resolve();
      };
    })(this));
    return dfr.promise();
  };

  UniStuttgart.prototype.tagref = function(pool_id) {
    return "tag:" + pool_id;
  };

  UniStuttgart.prototype.payload = function(filename, json, update, store_file) {
    var dfr, i, len, obj, obj_ids, pool_id, pool_name, ref, ref1, sql, tags;
    if (json.import_type === "tags") {
      tags = [];
      ref = this.pool_map;
      for (pool_id in ref) {
        pool_name = ref[pool_id];
        console.debug(this.name(), "tag:", this.tagref(pool_id), "name:", pool_name);
        tags.push({
          tag: {
            reference: this.tagref(pool_id),
            displayname: {
              "de-DE": pool_name
            },
            is_default: false,
            enabled: true,
            displaytype: "search",
            type: "individual"
          }
        });
      }
      json.tags.push({
        taggroup: {
          reference: "easydb4:pools",
          type: "choice",
          displayname: {
            "de-DE": "easydb4 Pools"
          }
        },
        _tags: tags
      });
      return;
    }
    if (json.import_type !== "db") {
      return;
    }
    if (json.objecttype !== "bilder") {
      return;
    }
    obj_ids = [];
    ref1 = json.objects;
    for (i = 0, len = ref1.length; i < len; i++) {
      obj = ref1[i];
      if (obj.bilder.__key) {
        obj_ids.push(obj.bilder.__key);
      }
    }
    sql = "SELECT id, pool_id\nFROM \"source.public.bilder\"\nWHERE id IN ( " + obj_ids.join(", ") + " ) ";
    dfr = new CUI.Deferred();
    this._migration.query(sql).fail(dfr.reject).done((function(_this) {
      return function(result) {
        var j, k, len1, len2, obj_id_map, ref2, ref3, row;
        obj_id_map = {};
        ref2 = result.rows;
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          row = ref2[j];
          obj_id_map[row[0]] = row[1];
        }
        ref3 = json.objects;
        for (k = 0, len2 = ref3.length; k < len2; k++) {
          obj = ref3[k];
          if (!obj.bilder.__key) {
            continue;
          }
          if (!obj_id_map[obj.bilder.__key]) {
            continue;
          }
          pool_id = obj_id_map[obj.bilder.__key];
          if (!_this.pool_map[pool_id]) {
            continue;
          }
          if (!obj._tags) {
            obj._tags = [];
          }
          obj._tags.push({
            "lookup:_id": {
              reference: _this.tagref(pool_id)
            }
          });
        }
        return dfr.resolve();
      };
    })(this));
    return dfr.promise();
  };

  return UniStuttgart;

})(Easydb4MigrationPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.UniStuttgart);
  };
})(this));
