#!/usr/bin/python
# coding=utf8

import sys
import unittest
from hotfolder_modules import file_util


filename_string_simple = 'file1.jpg'
filepath_string_simple = 'directory/'+filename_string_simple

filename_unciode_simple = 'file1.jpg'
filepath_unciode_simple = 'directory/'+filename_unciode_simple

filename_string_special = 'fileäöüß1.jpg'
filepath_string_special = 'directory/ä/ö/ü/'+filename_string_special

filename_unciode_special = 'fileäöüß1.jpg'
filepath_unciode_special = 'directory/ä/ö/ü/'+filename_unciode_special


class string_encoding(unittest.TestCase):

    def test(self):

        for s in [
            filename_string_simple,
            filepath_string_simple,

            filename_unciode_simple,
            filepath_unciode_simple,

            filename_string_special,
            filepath_string_special,

            filename_unciode_special,
            filepath_unciode_special,

            1,
            True,

            ('ä', 'ö'),
            {
                'ä': 'ö'
            },

            ('ä', 'ö'),
            {
                'ä': 'ö'
            }
        ]:
            try:

                utf8_string = file_util.to_utf8_string(s)
                print(('as string:  {}'.format(utf8_string)))

                utf8_unicode = file_util.to_utf8_unicode(s)
                print(('as unicode: {}'.format(utf8_unicode)))

            except Exception as e:
                (etype, evalue, etrace) = sys.exc_info()
                self.fail('Failed with %s' % evalue)


if __name__ == '__main__':
    unittest.main()
