// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.BarcodeMaskSplitter = (function(superClass) {
  extend(BarcodeMaskSplitter, superClass);

  function BarcodeMaskSplitter() {
    return BarcodeMaskSplitter.__super__.constructor.apply(this, arguments);
  }

  BarcodeMaskSplitter.prototype.isSimpleSplit = function() {
    return true;
  };

  BarcodeMaskSplitter.prototype.renderAsField = function() {
    return true;
  };

  BarcodeMaskSplitter.prototype.getOptions = function() {
    var fieldSelectorOpts, fields;
    fieldSelectorOpts = {
      store_value: "name",
      filter: (function(_this) {
        return function(field) {
          if (!_this.father.children.some(function(_field) {
            return _field.getData().field_name === field.name();
          })) {
            return false;
          }
          return true;
        };
      })(this)
    };
    fields = ez5.BarcodeMaskSplitter.getBarcodeOptions(this.maskEditor.getMask().getTable().table_id, fieldSelectorOpts);
    fields.push({
      type: CUI.NumberInput,
      form: {
        label: $$("barcode.custom.splitter.options.expert_search_limit.label")
      },
      name: "expert_search_limit",
      decimals: 0
    });
    return fields;
  };

  BarcodeMaskSplitter.getBarcodeOptions = function(idObjecttype, fieldSelectorOptions) {
    var disableEnableBarcodeType, fieldSelector, fieldSelectorFilter;
    if (fieldSelectorOptions == null) {
      fieldSelectorOptions = {};
    }
    disableEnableBarcodeType = function(field) {
      var barcodeTypeField, data, form;
      form = field.getForm();
      data = form.getData();
      barcodeTypeField = form.getFieldsByName("barcode_type")[0];
      if (data.code_type === ez5.Barcode.TYPE_BAR) {
        barcodeTypeField.enable();
      } else {
        barcodeTypeField.disable();
      }
    };
    fieldSelectorFilter = fieldSelectorOptions.filter;
    fieldSelector = new ez5.FieldSelector({
      form: {
        label: $$("barcode.custom.splitter.options.field-selector.label")
      },
      name: "field_name",
      store_value: fieldSelectorOptions.store_value || "name",
      placeholder: $$("barcode.custom.splitter.options.field-selector.placeholder"),
      objecttype_id: idObjecttype,
      schema: "HEAD",
      filter: (function(_this) {
        return function(field) {
          if (field.isTopLevelField() && (field instanceof SystemObjectIdColumn || field instanceof UuidColumn)) {
            return true;
          }
          if (fieldSelectorFilter && !(typeof fieldSelectorFilter === "function" ? fieldSelectorFilter(field) : void 0)) {
            return false;
          }
          return field instanceof TextColumn && !(field instanceof DecimalColumn) && !(field instanceof LinkColumn) && !(field instanceof PrimaryKeyColumn) && !(field instanceof LocaTextColumn) && !(field instanceof TextMultiColumn) && !field.isTopLevelField();
        };
      })(this)
    });
    return [
      {
        type: CUI.Select,
        name: "code_type",
        form: {
          label: $$("barcode.custom.splitter.options.code-type.label")
        },
        options: [
          {
            text: $$("barcode.custom.splitter.options.code-type.barcode.text"),
            value: ez5.Barcode.TYPE_BAR
          }, {
            text: $$("barcode.custom.splitter.options.code-type.qrcode.text"),
            value: ez5.Barcode.TYPE_QR
          }
        ],
        onDataChanged: function(_, field) {
          return disableEnableBarcodeType(field);
        }
      }, {
        type: CUI.Select,
        name: "barcode_type",
        form: {
          label: $$("barcode.custom.splitter.options.barcode-type.label"),
          hint: $$("barcode.custom.splitter.options.barcode-type.hint")
        },
        onRender: function(field) {
          return disableEnableBarcodeType(field);
        },
        options: function() {
          var i, len, option, options, ref;
          options = [];
          ref = [ez5.Barcode.DEFAULT_BARCODE_TYPE, "CODE39", "ITF14", "MSI", "pharmacode", "codabar", "EAN13", "UPC", "EAN8", "EAN5", "EAN2"];
          for (i = 0, len = ref.length; i < len; i++) {
            option = ref[i];
            options.push({
              value: option
            });
          }
          return options;
        }
      }, {
        type: CUI.Input,
        name: "code_prefix",
        form: {
          label: $$("barcode.custom.splitter.options.code_prefix.label"),
          hint: $$("barcode.custom.splitter.options.code_prefix.hint")
        }
      }, fieldSelector, {
        type: CUI.Input,
        name: "code_suffix",
        form: {
          label: $$("barcode.custom.splitter.options.code_suffix.label"),
          hint: $$("barcode.custom.splitter.options.code_suffix.hint")
        }
      }
    ];
  };

  BarcodeMaskSplitter.prototype.renderField = function(opts) {
    var _data, barcode, data, fieldName, localizedDisplayName, ref, ref1, ref2, ref3, ref4;
    fieldName = this.getDataOptions().field_name;
    if (!fieldName) {
      return;
    }
    if (fieldName === '_uuid' || fieldName === '_system_object_id' || fieldName === '_global_object_id') {
      _data = opts.top_level_data;
    } else {
      _data = opts.data;
    }
    data = _data[fieldName];
    if ((ref = this.opts) != null ? (ref1 = ref.options) != null ? ref1.code_prefix : void 0 : void 0) {
      data = this.opts.options.code_prefix + data;
    }
    if ((ref2 = this.opts) != null ? (ref3 = ref2.options) != null ? ref3.code_suffix : void 0 : void 0) {
      data = data + this.opts.options.code_suffix;
    }
    localizedDisplayName = (ref4 = _data[fieldName + ":rendered"]) != null ? ref4.getField().fullNameLocalized() : void 0;
    barcode = new ez5.Barcode({
      type: this.getDataOptions().code_type,
      barcode_type: this.getDataOptions().barcode_type,
      mode: opts.mode
    });
    return barcode.render(data, {
      displayName: localizedDisplayName,
      fieldName: fieldName,
      objectType: opts.top_level_data._objecttype
    });
  };

  BarcodeMaskSplitter.prototype.hasContent = function(opts) {
    var data, fieldName;
    fieldName = this.getDataOptions().field_name;
    if (!fieldName) {
      return false;
    }
    data = opts.data[fieldName];
    return !!data;
  };

  BarcodeMaskSplitter.prototype.isEnabledForNested = function() {
    return true;
  };

  return BarcodeMaskSplitter;

})(CustomMaskSplitter);

MaskSplitter.plugins.registerPlugin(ez5.BarcodeMaskSplitter);
