// Generated by CoffeeScript 1.12.7
var BaseMigrationNodeGroup,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

BaseMigrationNodeGroup = (function(superClass) {
  extend(BaseMigrationNodeGroup, superClass);

  function BaseMigrationNodeGroup() {
    return BaseMigrationNodeGroup.__super__.constructor.apply(this, arguments);
  }

  BaseMigrationNodeGroup.prototype.getDisplayText = function() {
    return ez5.loca.getBestFrontendValue(this.getData().group.displayname);
  };

  BaseMigrationNodeGroup.prototype.getActionPane = function() {
    var pane;
    pane = this.getActionPaneBase();
    return pane;
  };

  BaseMigrationNodeGroup.prototype.getActionFields = function() {
    var fields, ref;
    fields = [
      {
        type: CUI.Output,
        form: {
          label: this.children ? $$("base.migration.node.groups.text") : $$("base.migration.node.group.text")
        },
        text: this.getDisplayText()
      }, {
        type: CUI.Options,
        name: "migrate",
        form: {
          label: $$("base.migration.common.selection")
        },
        options: [
          {
            text: $$("base.migration.node.group.migrate_acl"),
            value: "acl"
          }, {
            text: $$("base.migration.node.group.migrate_system_rights"),
            value: "system_rights"
          }
        ]
      }, {
        type: CUI.Options,
        name: "mode",
        radio: true,
        form: {
          label: $$("base.migration.common.options")
        },
        options: [
          {
            text: $$("base.migration.common.replace"),
            value: "replace"
          }, {
            text: $$("base.migration.common.add"),
            value: "add"
          }
        ]
      }
    ];
    if (((ref = this.getData().group) != null ? ref.type : void 0) === "system") {
      fields.splice(2, 1);
    }
    return fields;
  };

  BaseMigrationNodeGroup.prototype.checkMigrateButton = function() {
    return this.__migrateBtn.enable();
  };

  BaseMigrationNodeGroup.prototype.migrate = function(ev, action_data) {
    var new_group;
    new_group = this.migrateGroup(action_data);
    if (ev.hasModifierKey()) {
      console.debug("migrate Group:", CUI.util.dump(new_group), new_group);
      return CUI.resolvedPromise();
    }
    return this.saveGroups([new_group]);
  };

  BaseMigrationNodeGroup.prototype.migrateGroup = function(action_data) {
    var _group, compareGroupRef, get_group_name, i, j, k, l, len, len1, len2, migration, new_acl, new_group, ref, ref1, ref2, ref3, source_gn, source_group;
    source_group = CUI.util.copyObject(this.getData(), true);
    migration = this.getMigration();
    get_group_name = (function(_this) {
      return function(group) {
        var name, ref;
        name = (ref = group.group.name) != null ? ref.trim() : void 0;
        if (CUI.util.isEmpty(name)) {
          name = ez5.loca.getBestFrontendValue(group.group.displayname);
        }
        if (CUI.util.isEmpty(name)) {
          return null;
        }
        return name;
      };
    })(this);
    compareGroupRef = function(source_group, target_group) {
      var ref, ref1;
      if (CUI.util.isEmpty(source_group.group.reference) || CUI.util.isEmpty(target_group.group.reference)) {
        return false;
      }
      if (!ez5.version("6")) {
        return false;
      }
      return ((ref = source_group.group.reference) != null ? ref.trim() : void 0) === ((ref1 = target_group.group.reference) != null ? ref1.trim() : void 0);
    };
    source_gn = get_group_name(source_group);
    console.debug("migrate group", source_gn, action_data, source_group);
    new_group = {
      _basetype: "group",
      _acl: void 0,
      _system_rights: void 0,
      group: {
        _id: void 0,
        _version: 1
      }
    };
    if ((source_group.group.type === "system" || action_data.mode === "replace") && !CUI.util.isEmpty(source_gn)) {
      ref = this.getMigration().getBaseData().group;
      for (i = 0, len = ref.length; i < len; i++) {
        _group = ref[i];
        if ((source_gn != null ? source_gn.toLowerCase() : void 0) === ((ref1 = get_group_name(_group)) != null ? ref1.toLowerCase() : void 0) || compareGroupRef(source_group, _group)) {
          console.info("found group:", source_gn, "update...");
          new_group.group._id = _group.group._id;
          new_group.group._version = _group.group._version + 1;
          break;
        }
      }
    }
    ref2 = ["displayname", "frontend_prefs", "name", "type", "authorization_info", "comment", "reference"];
    for (j = 0, len1 = ref2.length; j < len1; j++) {
      k = ref2[j];
      if (!new_group.group[k]) {
        new_group.group[k] = CUI.util.copyObject(source_group.group[k], true);
      }
    }
    if (source_group.group.type === "system") {
      delete new_group.group["reference"];
    }
    if (indexOf.call(action_data.migrate, "system_rights") >= 0) {
      new_group._system_rights = CUI.util.copyObject(source_group._system_rights, true);
    }
    if (indexOf.call(action_data.migrate, "acl") >= 0) {
      new_acl = migration.migrateACL(source_group._acl);
      if (new_acl.length > 0) {
        new_group._acl = new_acl;
      }
    }
    if (ez5.version("6")) {
      ref3 = ["_ip_subnet_filter", "_pseudonymization", "_auth_method_group_maps"];
      for (l = 0, len2 = ref3.length; l < len2; l++) {
        k = ref3[l];
        if (source_group[k]) {
          new_group[k] = CUI.util.copyObject(source_group[k], true);
        }
      }
    }
    return new_group;
  };

  BaseMigrationNodeGroup.prototype.saveGroups = function(groups) {
    var dfr, fail;
    this.log($$("base.migration.console.log.group.saving.md", {
      count: groups.length
    }));
    fail = (function(_this) {
      return function() {
        _this.log($$("base.migration.console.log.group.saving-failed.md", {
          count: groups.length
        }));
        return dfr.reject.apply(dfr.reject, arguments);
      };
    })(this);
    dfr = new CUI.Deferred();
    ez5.api.group({
      type: "POST",
      json_data: groups
    }).done((function(_this) {
      return function(groups) {
        console.debug("groups done...", groups);
        return ez5.api.group({
          type: "GET"
        }).done(function(_groups) {
          _this.log($$("base.migration.console.log.group.migrated.md", {
            count: groups.length
          }));
          console.debug("groups updated...", groups);
          _this.getMigration().getBaseData().group = _groups;
          return dfr.resolve();
        }).fail(dfr.reject);
      };
    })(this)).fail(dfr.reject);
    return dfr.promise();
  };

  BaseMigrationNodeGroup.getSourceNodesFromData = function(migration, data) {
    var group, groups, i, len, type;
    groups = {
      easydb: [],
      system: []
    };
    for (i = 0, len = data.length; i < len; i++) {
      group = data[i];
      type = group.group.type;
      if (type === "easydb" || type === "system") {
        groups[type].push(new BaseMigrationNodeGroup({
          migration: migration,
          data: group
        }));
      }
    }
    return [
      new BaseMigrationNodeGroups({
        migration: migration,
        children: [
          new BaseMigrationNodeGroupType({
            migration: migration,
            type: "system",
            children: groups.system
          }), new BaseMigrationNodeGroupType({
            migration: migration,
            type: "easydb",
            children: groups.easydb
          })
        ]
      })
    ];
  };

  return BaseMigrationNodeGroup;

})(BaseMigrationNodeData);
