class BaseMigrationNodeGroups extends BaseMigrationNodeData

	getDisplayText: ->
		$$("base.migration.node.groups.text")

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getActionFields: ->

		ots = []
		for c in @children
			ots.push(c.getDisplayText())

		fields = BaseMigrationNodeGroup::getActionFields.call(@)

		# overwrite output field
		fields[0] =
			type: CUI.Output
			form:
				label: $$("base.migration.node.groups.text")
			text: ots.join(", ")
		fields


	migrate: (ev, action_data) ->

		new_groups = []
		for c in @children
			new_groups.push.apply(new_groups, c.migrateGroups(action_data))

		if ev.hasModifierKey()
			console.debug "migrate Groups:", CUI.util.dump(new_groups), new_groups
			return CUI.resolvedPromise()

		BaseMigrationNodeGroup::saveGroups.call(@, new_groups)


	checkMigrateButton: ->
		@__migrateBtn.enable()
