class BaseMigrationNodeObjecttype extends BaseMigrationNodeData

	readOpts: ->
		super()
		@__target_objecttype = null
		for ot, idx in @getMigration().getBaseData().objecttype
			if ot.objecttype.name == @getData().objecttype.name
				ot._idx_in_base_data = idx
				@__target_objecttype = ot
				break
		return


	getTargetObjecttype: ->
		@__target_objecttype

	getDisplayText: ->
		@getData().objecttype.name

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getActionFields: ->
		[
			type: CUI.Output
			form:
				label: $$("base.migration.node.objecttype.objecttype.label")
			text: @getDisplayText()
		,
			type: CUI.Options
			name: "migrate"
			form:
				label: $$("base.migration.node.objecttype.migrate.label")
			options: [
				text: $$("base.migration.node.objecttype.migrate.check_acl", acl_count: @getData()._acl?.length)
				disabled: @getData()._acl?.length == 0
				value: "acl"
			,
				text: $$("base.migration.node.objecttype.migrate.columnfilters", acl_count: @getData()._columnfilters.length)
				disabled: @getData()._columnfilters.length == 0
				value: "columnfilters"
			]
		,
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$('base.migration.node.objecttype.mode.label')
			options: [
				text: $$('base.migration.node.objecttype.mode.replace')
				value: "replace"
			,
				text: $$('base.migration.node.objecttype.mode.add')
				value: "add"
			]
		]

	migrate: (ev, action_data) ->
		console.debug "migrate Objecttype:", @getDisplayText()

		source_ot = @getData()
		target_ot = @getTargetObjecttype()
		migration = @getMigration()

		if not target_ot
			@log($$("base.migration.console.log.objecttype.target-not-found.md", name: source_ot.objecttype.name))
			return CUI.resolvedPromise()

		save_ot =
			_basetype: "objecttype"
			objecttype:
				_id: target_ot.objecttype._id
				_version: target_ot.objecttype._version + 1

		do_save = false

		if "acl" in action_data.migrate
			new_acl = migration.migrateACL(source_ot._acl)
			if new_acl.length > 0
				save_ot._acl = []
				if action_data.mode == "add"
					save_ot._acl.push.apply(save_ot._acl, target_ot._acl)

				save_ot._acl.push.apply(save_ot._acl, new_acl)
				do_save = true

		if 'columnfilters' in action_data.migrate
			save_ot._columnfilters = []

			new_columnfilters = []

			for cf in source_ot._columnfilters
				new_cf =
					internal_name: cf.internal_name
					columns: cf.columns

				if cf.tagfilter
					new_cf.tagfilter = migration.migrateTagFilter(cf.tagfilter) or {}

				acl = []
				for who in (cf.who or [])
					acl.push(who: who)

				new_acl = migration.migrateACL(acl)
				if new_acl.length > 0
					new_cf.who = (_acl.who for _acl in new_acl)

				if not cf.who?.length or new_cf.who?.length
					new_columnfilters.push(new_cf)

			if new_columnfilters.length > 0
				save_ot._columnfilters = []
				if action_data.mode == "add"
					save_ot._columnfilters.push.apply(save_ot._columnfilters, target_ot._columnfilters)

				save_ot._columnfilters.push.apply(save_ot._columnfilters, new_columnfilters)
				do_save = true


		if not do_save
			@log($$("base.migration.console.log.objecttype.no-data-found.md"))
			return CUI.resolvedPromise()

		if ev.hasModifierKey()
			console.debug "objecttype save:", CUI.util.dump(save_ot)
			return CUI.resolvedPromise()

		@log($$("base.migration.console.log.objecttype.saving.md", name: @getDisplayText()))

		ez5.api.objecttype
			type: "POST"
			json_data: [save_ot]
		.done (ot_data) =>
			@log($$("base.migration.console.log.objecttype.migrated.md",
				name: @getDisplayText()
				count_acl: ot_data[0]._acl.length
				count_columns: ot_data[0]._columnfilters.length
			))
			@getMigration().getBaseData().objecttype[target_ot._idx_in_base_data] = ot_data[0]
		.fail =>
			@log($$("base.migration.console.log.objecttype.failed.md", name: @getDisplayText()))


	checkMigrateButton: ->
		@__migrateBtn.disable()

		if not @getTargetObjecttype()
			return
		if @__actionData.migrate.length == 0
			return
		@__migrateBtn.enable()
		return

	@getSourceNodesFromData: (migration, data) ->

		objecttypes = []
		for objecttype in data
			objecttypes.push(new BaseMigrationNodeObjecttype(migration: migration, data: objecttype))

		objecttypes.sort (a, b) =>
			CUI.util.compareIndex(a.getDisplayText(), b.getDisplayText())

		[new BaseMigrationNodeObjecttypes(migration: migration, children: objecttypes)]
