// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.CoinViewerDetailPlugin = (function(superClass) {
  extend(CoinViewerDetailPlugin, superClass);

  function CoinViewerDetailPlugin() {
    return CoinViewerDetailPlugin.__super__.constructor.apply(this, arguments);
  }

  CoinViewerDetailPlugin.JSON_EXTENSION = "json";

  CoinViewerDetailPlugin.prototype.getButtonLocaKey = function() {
    return "coin.viewer.main.button";
  };

  CoinViewerDetailPlugin.prototype.prefName = function() {
    return "coin.viewer.pref";
  };

  CoinViewerDetailPlugin.prototype.getPane = function() {
    return "top";
  };

  CoinViewerDetailPlugin.prototype.isAvailable = function() {
    var assets;
    assets = this._detailSidebar.object.getAssetsForBrowser(["detail", "standard"]);
    return assets.some((function(_this) {
      return function(asset) {
        return asset.value.extension === ez5.CoinViewerDetailPlugin.JSON_EXTENSION;
      };
    })(this));
  };

  CoinViewerDetailPlugin.prototype.isDisabled = function() {
    return false;
  };

  CoinViewerDetailPlugin.prototype.showDetail = function() {
    var _, _version, asset, assets, deferred, downloadUrl, fn, headers, i, len, promises, ref, serverToken, validJsonFilesFound, waitBlock;
    CUI.dom.empty(this.__mainDiv);
    waitBlock = new CUI.WaitBlock({
      element: this.__mainDiv
    });
    waitBlock.show();
    this._detailSidebar.mainPane.replace(this.__mainDiv, this.getPane());
    serverToken = ez5.session.token;
    headers = {};
    if (!ez5.version("6")) {
      headers["X-Easydb-Token"] = serverToken;
    }
    validJsonFilesFound = [];
    promises = [];
    assets = this._detailSidebar.object.getAssetsForBrowser(["detail", "standard"]);
    fn = (function(_this) {
      return function(deferred) {
        var downloadXHR, promise;
        downloadXHR = new CUI.XHR({
          url: downloadUrl,
          method: "GET",
          headers: headers
        });
        promise = downloadXHR.start();
        promise.done(function(jsonData) {
          if (_this.__isValidJsonData(jsonData)) {
            validJsonFilesFound.push(jsonData);
          }
          return deferred.resolve();
        }).fail(deferred.reject);
        return promises.push(deferred.promise());
      };
    })(this);
    for (i = 0, len = assets.length; i < len; i++) {
      asset = assets[i];
      if (asset.value.extension !== ez5.CoinViewerDetailPlugin.JSON_EXTENSION) {
        continue;
      }
      ref = asset.value.versions || [];
      for (_ in ref) {
        _version = ref[_];
        downloadUrl = _version.url || _version.download_url;
        if (downloadUrl) {
          break;
        }
      }
      if (!downloadUrl) {
        continue;
      }
      deferred = new CUI.Deferred();
      fn(deferred);
    }
    CUI.whenAll(promises).done((function(_this) {
      return function() {
        var pane, wrongJsonLabel;
        if (validJsonFilesFound.length === 0) {
          wrongJsonLabel = new LocaLabel({
            loca_key: "coin.viewer.main.error.json_wrong_data",
            centered: true,
            multiline: true
          });
          CUI.dom.replace(_this.__mainDiv, wrongJsonLabel);
          return;
        }
        pane = new CUI.SimplePane({
          "class": "ez5-coin-viewer-pane",
          content: [_this.__buttonBar, _this.__mainDiv]
        });
        _this._detailSidebar.mainPane.replace(pane, _this.getPane());
        _this.__openCoinViewer(validJsonFilesFound);
        return waitBlock.hide();
      };
    })(this));
  };

  CoinViewerDetailPlugin.prototype.renderObject = function() {
    var fullscreenButton;
    this.__mainDiv = CUI.dom.div("ez5-coin-viewer-container");
    fullscreenButton = CUI.Pane.getToggleFillScreenButton({
      icon_inactive: new CUI.Icon({
        icon: $$("coin.viewer.buttonbar.fullscreen.button.open|icon")
      }),
      icon_active: new CUI.Icon({
        icon: $$("coin.viewer.buttonbar.fullscreen.button.close|icon")
      }),
      tooltip: {
        text: $$("coin.viewer.buttonbar.fullscreen.button|tooltip")
      }
    });
    this.__buttonBar = new CUI.Buttonbar({
      "class": "ez5-coin-viewer-buttonbar",
      buttons: [fullscreenButton]
    });
  };

  CoinViewerDetailPlugin.prototype.__openCoinViewer = function(jsonFiles) {
    var coinData;
    coinData = jsonFiles[0];
    ez5.CoinLib.init(this.__mainDiv);
    ez5.CoinLib.show(coinData);
  };

  CoinViewerDetailPlugin.prototype.__isValidJsonData = function(jsonData) {
    if (!CUI.util.isPlainObject(jsonData)) {
      return false;
    }
    if (!CUI.util.isPlainObject(jsonData.processData)) {
      return false;
      if (!value.albedo || !value.normal) {
        return false;
      }
    }
    return true;
  };

  return CoinViewerDetailPlugin;

})(DetailSidebarPlugin);

ez5.session_ready(function() {
  DetailSidebar.plugins.registerPlugin(ez5.CoinViewerDetailPlugin);
});
