// Generated by CoffeeScript 1.12.7
ez5.DANTEUtil = (function() {
  function DANTEUtil() {}


  /*
  @name         getFullTextFromJSKOSObject
  @description  This function generates the _fulltext-Object, which is required for search
                   Structure is documented here: https://docs.easydb.de/en/technical/plugins/customdatatype/#general-keys
  @param        {object}                JSKOS                 a jskos-object
  @param        {array}                 databaseLanguages     a list of easydb5-languages
  @return       {object}                returns _standard-Object
   */

  DANTEUtil.getFullTextFromJSKOSObject = function(object, databaseLanguages) {
    var _fulltext, arrayValue, arrayValueOfObject, fullTextString, i, j, k, key, l, l10nObject, l10nObjectKey, l10nObjectValue, l10nObjectWithShortenedLanguages, l10nObjectWithShortenedLanguagesKey, l10nObjectWithShortenedLanguagesValue, language, len, len1, len2, len3, objectKey, objectKeys, objectValue, prefLabelOfArrayKey, prefLabelOfArrayValue, propertyType, ref, ref1, ref2, shortenedDatabaseLanguages, shortenedLanguage, value;
    if (databaseLanguages == null) {
      databaseLanguages = false;
    }
    if (databaseLanguages === false) {
      databaseLanguages = ez5.loca.getLanguageControl().getLanguages().slice();
    }
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    if (Array.isArray(object)) {
      object = object[0];
    }
    _fulltext = {};
    fullTextString = '';
    l10nObject = {};
    l10nObjectWithShortenedLanguages = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    for (j = 0, len1 = shortenedDatabaseLanguages.length; j < len1; j++) {
      language = shortenedDatabaseLanguages[j];
      l10nObjectWithShortenedLanguages[language] = '';
    }
    objectKeys = ['prefLabel', 'altLabel', 'hiddenLabel', 'identifier', 'notation', 'uri', 'scopeNote', 'definition', 'startDate', 'endDate', 'example', 'historyNote', 'note', 'changeNote', 'startPlace', 'endPlace'];
    for (key in object) {
      value = object[key];
      if (objectKeys.includes(key)) {
        propertyType = typeof value;
        if (propertyType === 'string') {
          fullTextString += value + ' ';
          for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
            l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
            l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + value + ' ';
          }
        }
        if (propertyType === 'object') {
          if (Array.isArray(object[key])) {
            ref = object[key];
            for (k = 0, len2 = ref.length; k < len2; k++) {
              arrayValue = ref[k];
              if (typeof arrayValue === 'string') {
                fullTextString += arrayValue + ' ';
                for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
                  l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
                  l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + arrayValue + ' ';
                }
              } else if (typeof arrayValue === 'object') {
                if (arrayValue != null ? arrayValue.prefLabel : void 0) {
                  ref1 = arrayValue.prefLabel;
                  for (prefLabelOfArrayKey in ref1) {
                    prefLabelOfArrayValue = ref1[prefLabelOfArrayKey];
                    fullTextString += prefLabelOfArrayValue + ' ';
                    for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
                      l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
                      l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + prefLabelOfArrayValue + ' ';
                    }
                  }
                }
              }
            }
          } else {
            ref2 = object[key];
            for (objectKey in ref2) {
              objectValue = ref2[objectKey];
              if (Array.isArray(objectValue)) {
                for (l = 0, len3 = objectValue.length; l < len3; l++) {
                  arrayValueOfObject = objectValue[l];
                  fullTextString += arrayValueOfObject + ' ';
                  if (l10nObjectWithShortenedLanguages.hasOwnProperty(objectKey)) {
                    l10nObjectWithShortenedLanguages[objectKey] += arrayValueOfObject + ' ';
                  }
                }
              }
              if (typeof objectValue === 'string') {
                fullTextString += objectValue + ' ';
                if (l10nObjectWithShortenedLanguages[objectKey]) {
                  l10nObjectWithShortenedLanguages[objectKey] += objectValue + ' ';
                }
              }
            }
          }
        }
      }
    }
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      shortenedLanguage = l10nObjectKey.split('-')[0];
      if (l10nObjectWithShortenedLanguages[shortenedLanguage]) {
        l10nObject[l10nObjectKey] = l10nObjectWithShortenedLanguages[shortenedLanguage];
      }
    }
    _fulltext.text = fullTextString;
    _fulltext.l10ntext = l10nObject;
    return _fulltext;
  };


  /*
  @name         getStandardFromJSKOSObject
  @description  This function generates the _standard-Object, which is required for display-purposes
                   Structure is documented here: https://docs.easydb.de/en/technical/plugins/customdatatype/#general-keys
  @param        {object}     JSKOS     a jskos-object
  @return       {object}              returns _standard-Object
   */

  DANTEUtil.getStandardFromJSKOSObject = function(JSKOS, databaseLanguages) {
    var _standard, hasl10n, i, l10nObject, l10nObjectKey, l10nObjectValue, language, len, shortenedDatabaseLanguages, shortenedLanguage;
    if (databaseLanguages == null) {
      databaseLanguages = false;
    }
    if (databaseLanguages === false) {
      databaseLanguages = ez5.loca.getLanguageControl().getLanguages().slice();
    }
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    if (Array.isArray(JSKOS)) {
      JSKOS = JSKOS[0];
    }
    _standard = {};
    l10nObject = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    hasl10n = false;
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      shortenedLanguage = l10nObjectKey.split('-')[0];
      if (JSKOS.prefLabel[shortenedLanguage]) {
        l10nObject[l10nObjectKey] = JSKOS.prefLabel[shortenedLanguage];
        hasl10n = true;
      }
    }
    if (hasl10n) {
      for (l10nObjectKey in l10nObject) {
        l10nObjectValue = l10nObject[l10nObjectKey];
        if (l10nObject[l10nObjectKey] === '') {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel[Object.keys(JSKOS.prefLabel)[0]];
        }
      }
    }
    if (!hasl10n) {
      for (l10nObjectKey in l10nObject) {
        l10nObjectValue = l10nObject[l10nObjectKey];
        if (JSKOS.prefLabel['und']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['und'];
        } else if (JSKOS.prefLabel['zxx']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['zxx'];
        } else if (JSKOS.prefLabel['mis']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['mis'];
        } else if (JSKOS.prefLabel['mul']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['mul'];
        }
      }
    }
    _standard.l10ntext = l10nObject;
    return _standard;
  };


  /*
  @name         getFacetTermFromJSKOSObject
  @description  generates a json-structure, which is only used for facetting (aka filter) in frontend
   */

  DANTEUtil.getFacetTermFromJSKOSObject = function(JSKOS) {
    var _facet_term, databaseLanguages, hasl10n, i, l10nObject, l10nObjectKey, l10nObjectValue, language, len, shortenedDatabaseLanguages, shortenedLanguage;
    console.log("f:getFacetTermFromJSKOSObject");
    databaseLanguages = ez5.loca.getLanguageControl().getLanguages().slice();
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    if (Array.isArray(JSKOS)) {
      JSKOS = JSKOS[0];
    }
    _facet_term = {};
    l10nObject = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    hasl10n = false;
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      shortenedLanguage = l10nObjectKey.split('-')[0];
      if (JSKOS.prefLabel[shortenedLanguage]) {
        l10nObject[l10nObjectKey] = JSKOS.prefLabel[shortenedLanguage];
        l10nObject[l10nObjectKey] = l10nObject[l10nObjectKey] + '@$@' + JSKOS.uri;
        hasl10n = true;
      }
    }
    if (hasl10n) {
      for (l10nObjectKey in l10nObject) {
        l10nObjectValue = l10nObject[l10nObjectKey];
        if (l10nObject[l10nObjectKey] === '') {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel[Object.keys(JSKOS.prefLabel)[0]];
          l10nObject[l10nObjectKey] = l10nObject[l10nObjectKey] + '@$@' + JSKOS.uri;
        }
      }
    }
    if (!hasl10n) {
      for (l10nObjectKey in l10nObject) {
        l10nObjectValue = l10nObject[l10nObjectKey];
        if (JSKOS.prefLabel['und']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['und'];
        } else if (JSKOS.prefLabel['zxx']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['zxx'];
        } else if (JSKOS.prefLabel['mis']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['mis'];
        } else if (JSKOS.prefLabel['mul']) {
          l10nObject[l10nObjectKey] = JSKOS.prefLabel['mul'];
        }
        l10nObject[l10nObjectKey] = l10nObject[l10nObjectKey] + '@$@' + JSKOS.uri;
      }
    }
    _facet_term = l10nObject;
    return _facet_term;
  };

  return DANTEUtil;

})();
