// Generated by CoffeeScript 1.12.7
ez5.GeonamesUtil = (function() {
  function GeonamesUtil() {}

  GeonamesUtil.getConceptNameFromObject = function(object) {
    var conceptName;
    conceptName = '';
    if (object != null ? object.asciiName : void 0) {
      conceptName = object.asciiName;
    }
    return conceptName;
  };

  GeonamesUtil.getConceptURIFromObject = function(object) {
    var conceptURI;
    conceptURI = '';
    if (object != null ? object.geonameId : void 0) {
      conceptURI = 'http://geonames.org/' + object.geonameId;
    }
    return conceptURI;
  };

  GeonamesUtil.getConceptAncestorsFromObject = function(object) {
    var conceptAncestors;
    conceptAncestors = [];
    if (object != null ? object.countryId : void 0) {
      conceptAncestors.push('http://geonames.org/' + object.countryId);
    }
    if (object != null ? object.adminId1 : void 0) {
      conceptAncestors.push('http://geonames.org/' + object.adminId1);
    }
    if (object != null ? object.adminId2 : void 0) {
      conceptAncestors.push('http://geonames.org/' + object.adminId2);
    }
    if (object != null ? object.adminId3 : void 0) {
      conceptAncestors.push('http://geonames.org/' + object.adminId3);
    }
    if (object != null ? object.adminId4 : void 0) {
      conceptAncestors.push('http://geonames.org/' + object.adminId4);
    }
    conceptAncestors.push('http://geonames.org/' + object.geonameId);
    conceptAncestors = conceptAncestors.join(' ');
    return conceptAncestors;
  };

  GeonamesUtil.getStandardTextFromObject = function(context, object, cdata, databaseLanguages) {
    var _standard, activeFrontendLanguage, i, l10nObject, l10nObjectKey, l10nObjectValue, language, len, ref, shortenedDatabaseLanguages, standardTextString;
    if (databaseLanguages == null) {
      databaseLanguages = false;
    }
    if (databaseLanguages === false) {
      databaseLanguages = ez5.loca.getDatabaseLanguages();
    }
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    activeFrontendLanguage = null;
    if (context) {
      activeFrontendLanguage = context.getFrontendLanguage();
    }
    if (cdata != null ? cdata.frontendLanguage : void 0) {
      if ((cdata != null ? (ref = cdata.frontendLanguage) != null ? ref.length : void 0 : void 0) === 2) {
        activeFrontendLanguage = cdata.frontendLanguage;
      }
    }
    if (Array.isArray(object)) {
      object = object[0];
    }
    _standard = {};
    standardTextString = '';
    l10nObject = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      l10nObject[l10nObjectKey] = object.asciiName;
    }
    _standard.l10ntext = l10nObject;
    return _standard;
  };

  GeonamesUtil.getFullTextFromObject = function(object, databaseLanguages) {
    var _fulltext, altnameVal, altnamekey, arrayValue, arrayValueOfObject, fullTextString, i, j, k, key, l, l10nObject, l10nObjectKey, l10nObjectValue, l10nObjectWithShortenedLanguages, l10nObjectWithShortenedLanguagesKey, l10nObjectWithShortenedLanguagesValue, language, len, len1, len2, len3, objectKey, objectKeys, objectValue, propertyType, ref, ref1, ref2, shortenedDatabaseLanguages, shortenedLanguage, value;
    if (databaseLanguages == null) {
      databaseLanguages = false;
    }
    if (databaseLanguages === false) {
      databaseLanguages = ez5.loca.getDatabaseLanguages();
    }
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    if (Array.isArray(object)) {
      object = object[0];
    }
    _fulltext = {};
    fullTextString = '';
    l10nObject = {};
    l10nObjectWithShortenedLanguages = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    for (j = 0, len1 = shortenedDatabaseLanguages.length; j < len1; j++) {
      language = shortenedDatabaseLanguages[j];
      l10nObjectWithShortenedLanguages[language] = '';
    }
    objectKeys = ["asciiName", "alternateNames", "toponymName", "geonameId", "countryName"];
    for (key in object) {
      value = object[key];
      if (objectKeys.includes(key)) {
        propertyType = typeof value;
        if (propertyType === 'string' || propertyType === 'number') {
          fullTextString += value + ' ';
          for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
            l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
            l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + value + ' ';
          }
        }
        if (propertyType === 'object') {
          if (Array.isArray(object[key])) {
            if (Array.isArray(object[key])) {
              ref = object[key];
              for (k = 0, len2 = ref.length; k < len2; k++) {
                arrayValue = ref[k];
                if (typeof arrayValue === 'string') {
                  fullTextString += arrayValue + ' ';
                  for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
                    l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
                    l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + arrayValue + ' ';
                  }
                }
              }
            }
            if (typeof object[key] === 'object') {
              ref1 = object[key];
              for (altnamekey in ref1) {
                altnameVal = ref1[altnamekey];
                if (altnameVal.name) {
                  fullTextString += altnameVal.name + ' ';
                  for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
                    l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
                    l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + altnameVal.name + ' ';
                  }
                }
              }
            }
          } else {
            ref2 = object[key];
            for (objectKey in ref2) {
              objectValue = ref2[objectKey];
              if (Array.isArray(objectValue)) {
                for (l = 0, len3 = objectValue.length; l < len3; l++) {
                  arrayValueOfObject = objectValue[l];
                  fullTextString += arrayValueOfObject + ' ';
                  if (l10nObjectWithShortenedLanguages.hasOwnProperty(objectKey)) {
                    l10nObjectWithShortenedLanguages[objectKey] += arrayValueOfObject + ' ';
                  }
                }
              }
              if (typeof objectValue === 'string') {
                fullTextString += objectValue + ' ';
                if (l10nObjectWithShortenedLanguages.hasOwnProperty(objectKey)) {
                  l10nObjectWithShortenedLanguages[objectKey] += objectValue + ' ';
                }
              }
            }
          }
        }
      }
    }
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      shortenedLanguage = l10nObjectKey.split('-')[0];
      if (l10nObjectWithShortenedLanguages[shortenedLanguage]) {
        l10nObject[l10nObjectKey] = l10nObjectWithShortenedLanguages[shortenedLanguage];
      }
    }
    _fulltext.text = fullTextString;
    _fulltext.l10ntext = l10nObject;
    return _fulltext;
  };

  return GeonamesUtil;

})();
