// Generated by CoffeeScript 1.12.7
var CustomDataTypeGN250,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeGN250 = (function(superClass) {
  extend(CustomDataTypeGN250, superClass);

  function CustomDataTypeGN250() {
    return CustomDataTypeGN250.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeGN250.prototype.getL10NPrefix = function() {
    return "custom.data.type.gn250";
  };

  CustomDataTypeGN250.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-gn250.gn250";
  };

  CustomDataTypeGN250.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.gn250.name");
  };

  CustomDataTypeGN250.prototype.__getAdditionalTooltipInfo = function(encodedURI, tooltip, extendedInfo_xhr) {
    var gn250ID, that, uri;
    that = this;
    uri = decodeURIComponent(encodedURI);
    gn250ID = uri;
    gn250ID = gn250ID.split("/");
    gn250ID = gn250ID.pop();
    if (extendedInfo_xhr.xhr !== void 0) {
      extendedInfo_xhr.xhr.abort();
    }
    extendedInfo_xhr.xhr = new CUI.XHR({
      url: location.protocol + '//uri.gbv.de/terminology/gn250/' + gn250ID + '?format=json'
    });
    extendedInfo_xhr.xhr.start().done(function(data, status, statusText) {
      var coord1, coord2, dataSource, geoPositions, geoStr, htmlContent, mapbox_api_key, positionBR, positionTL, ref, ref1, url;
      htmlContent = '<span style="padding: 10px 10px 0px 10px; font-weight: bold">' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.info') + '</span>';
      if ((ref = that.getCustomSchemaSettings().mapbox_api_key) != null ? ref.value : void 0) {
        mapbox_api_key = (ref1 = that.getCustomSchemaSettings().mapbox_api_key) != null ? ref1.value : void 0;
      }
      if (mapbox_api_key) {
        geoStr = data.BOX_GEO;
        geoStr = geoStr.replace('POLYGON ((', '');
        geoStr = geoStr.replace('))', '');
        geoPositions = geoStr.split(',');
        positionTL = geoPositions[0].split(' ');
        positionTL = positionTL.map(Number);
        positionBR = geoPositions[2].split(' ');
        positionBR = positionBR.map(Number);
        coord1 = positionTL[1] + ((positionBR[1] - positionTL[1]) / 2);
        coord2 = positionTL[0] + ((positionBR[0] - positionTL[0]) / 2);
        if (coord1 !== 0 & coord2 !== 0) {
          url = location.protocol + '//api.mapbox.com/styles/v1/mapbox/streets-v11/static/' + coord2 + ',' + coord1 + ',11/400x200@2x?access_token=' + mapbox_api_key;
          htmlContent += '<div style="width:400px; height: 250px; background-size: contain; background-image: url(' + url + '); background-repeat: no-repeat; background-position: center center;"></div>';
        }
      }
      htmlContent += '<table style="border-spacing: 10px; border-collapse: separate;">';
      if (data.NNID) {
        if (typeof data.NNID !== 'object') {
          htmlContent += '<tr><td>NNID:</td><td>' + data.NNID + '</td></tr>';
        }
      }
      if (data.OBA) {
        if (typeof data.OBA !== 'object') {
          htmlContent += '<tr><td>OBA:</td><td>' + data.OBA + '</td></tr>';
        }
      }
      if (data.OBA_WERT) {
        if (typeof data.OBA_WERT !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.oba_wert') + ':</td><td>' + data.OBA_WERT + '</td></tr>';
        }
      }
      if (data.NAME) {
        if (typeof data.NAME !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.name') + ':</td><td>' + data.NAME + '</td></tr>';
        }
      }
      if (data.E) {
        if (typeof data.NAME2 !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.name2') + ':</td><td>' + data.NAME2 + '</td></tr>';
        }
      }
      if (data.GEMEINDE) {
        if (typeof data.GEMEINDE !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.gemeinde') + ':</td><td>' + data.GEMEINDE + '</td></tr>';
        }
      }
      if (data.VERWGEM) {
        if (typeof data.VERWGEM !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.verwaltungsgemeinde') + ':</td><td>' + data.VERWGEM + '</td></tr>';
        }
      }
      if (data.KREIS) {
        if (typeof data.KREIS !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.kreis') + ':</td><td>' + data.KREIS + '</td></tr>';
        }
      }
      if (data.REGBEZIRK) {
        if (typeof data.REGBEZIRK !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.bezirk') + ':</td><td>' + data.REGBEZIRK + '</td></tr>';
        }
      }
      if (data.BUNDESLAND) {
        if (typeof data.BUNDESLAND !== 'object') {
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.bundesland') + ':</td><td>' + data.BUNDESLAND + '</td></tr>';
        }
      }
      if (data.SOURCE) {
        if (typeof data.SOURCE !== 'object') {
          dataSource = data.SOURCE.replace(' - ', '<br />');
          htmlContent += '<tr><td>' + $$('custom.data.type.gn250.config.parameter.mask.infopopup.popup.quelle') + ':</td><td>' + dataSource + '</td></tr>';
        }
      }
      tooltip.DOM.innerHTML = htmlContent;
      return tooltip.autoSize();
    });
  };

  CustomDataTypeGN250.prototype.__updateSuggestionsMenu = function(cdata, cdata_form, searchstring, input, suggest_Menu, searchsuggest_xhr, layout, opts) {
    var delayMillisseconds, that;
    that = this;
    delayMillisseconds = 200;
    return setTimeout((function() {
      var gn250_countSuggestions, gn250_searchterm;
      gn250_searchterm = searchstring;
      gn250_countSuggestions = 20;
      if (cdata_form) {
        gn250_searchterm = cdata_form.getFieldsByName("searchbarInput")[0].getValue();
        gn250_countSuggestions = cdata_form.getFieldsByName("countOfSuggestions")[0].getValue();
      }
      if (gn250_searchterm.length === 0) {
        return;
      }
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      searchsuggest_xhr.xhr = new CUI.XHR({
        url: location.protocol + '//ws.gbv.de/suggest/gn250/?searchterm=' + gn250_searchterm + '&count=' + gn250_countSuggestions
      });
      return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
        var extendedInfo_xhr, fn, i, itemList, key, len, menu_items, ref, suggestion;
        extendedInfo_xhr = {
          "xhr": void 0
        };
        menu_items = [];
        ref = data[1];
        fn = function(key) {
          var aktType, item, lastType;
          aktType = data[2][key];
          lastType = '';
          if (key > 0) {
            lastType = data[2][key - 1];
          }
          if (aktType !== lastType) {
            item = {
              divider: true
            };
            menu_items.push(item);
            item = {
              label: aktType
            };
            menu_items.push(item);
            item = {
              divider: true
            };
            menu_items.push(item);
          }
          item = {
            text: suggestion,
            value: data[3][key],
            tooltip: {
              markdown: true,
              placement: "e",
              content: function(tooltip) {
                var mapbox_api_key, ref1, ref2;
                mapbox_api_key = '';
                if ((ref1 = that.getCustomSchemaSettings().mapbox_api_key) != null ? ref1.value : void 0) {
                  mapbox_api_key = (ref2 = that.getCustomSchemaSettings().mapbox_api_key) != null ? ref2.value : void 0;
                }
                that.__getAdditionalTooltipInfo(data[3][key], tooltip, extendedInfo_xhr);
                return new CUI.Label({
                  icon: "spinner",
                  text: $$('custom.data.type.gn250.config.parameter.mask.show_infopopup.loading.label')
                });
              }
            }
          };
          return menu_items.push(item);
        };
        for (key = i = 0, len = ref.length; i < len; key = ++i) {
          suggestion = ref[key];
          fn(key);
        }
        itemList = {
          onClick: function(ev2, btn) {
            cdata.conceptURI = btn.getOpt("value");
            cdata.conceptName = btn.getText();
            that.__updateResult(cdata, layout, opts);
            suggest_Menu.hide();
            if (that.popover) {
              return that.popover.hide();
            }
          },
          items: menu_items
        };
        if (itemList.items.length === 0) {
          itemList = {
            items: [
              {
                text: "kein Treffer",
                value: void 0
              }
            ]
          };
        }
        suggest_Menu.setItemList(itemList);
        return suggest_Menu.show();
      });
    }), delayMillisseconds);
  };

  CustomDataTypeGN250.prototype.__getEditorFields = function(cdata) {
    var fields;
    fields = [
      {
        type: CUI.Select,
        "class": "commonPlugin_Select",
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.gn250.modal.form.text.count')
        },
        options: [
          {
            value: 10,
            text: '10 ' + $$('custom.data.type.gn250.modal.form.text.count_short')
          }, {
            value: 20,
            text: '20 ' + $$('custom.data.type.gn250.modal.form.text.count_short')
          }, {
            value: 50,
            text: '50 ' + $$('custom.data.type.gn250.modal.form.text.count_short')
          }, {
            value: 100,
            text: '100 ' + $$('custom.data.type.gn250.modal.form.text.count_short')
          }, {
            value: 500,
            text: '500 ' + $$('custom.data.type.gn250.modal.form.text.count_short')
          }
        ],
        name: 'countOfSuggestions'
      }, {
        type: CUI.Input,
        "class": "commonPlugin_Input",
        undo_and_changed_support: false,
        form: {
          label: $$("custom.data.type.gn250.modal.form.text.searchbar")
        },
        placeholder: $$("custom.data.type.gn250.modal.form.text.searchbar.placeholder"),
        name: "searchbarInput"
      }
    ];
    return fields;
  };

  CustomDataTypeGN250.prototype.__renderButtonByData = function(cdata) {
    var extendedInfo_xhr, that;
    that = this;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.gn250.edit.no_gn250")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.gn250.edit.no_valid_gn250")
        }).DOM;
    }
    cdata.conceptURI = CUI.parseLocation(cdata.conceptURI).url;
    extendedInfo_xhr = {
      "xhr": void 0
    };
    return new CUI.HorizontalLayout({
      maximize: true,
      left: {
        content: new CUI.Label({
          centered: false,
          text: cdata.conceptName
        })
      },
      center: {
        content: new CUI.ButtonHref({
          appearance: "link",
          href: cdata.conceptURI,
          target: "_blank",
          tooltip: {
            markdown: true,
            placement: 'n',
            content: function(tooltip) {
              that.__getAdditionalTooltipInfo(cdata.conceptURI, tooltip, extendedInfo_xhr);
              return new CUI.Label({
                icon: "spinner",
                text: "lade Informationen"
              });
            }
          },
          text: ""
        })
      },
      right: null
    }).DOM;
  };

  CustomDataTypeGN250.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var ref, tags;
    tags = [];
    if ((ref = custom_settings.mapbox_api_key) != null ? ref.value : void 0) {
      tags.push("✓ mapbox-token");
    } else {
      tags.push("✘ mapbox-token");
    }
    return tags;
  };

  return CustomDataTypeGN250;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeGN250);
