// Generated by CoffeeScript 1.12.7
var CustomDataTypeNomisma,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeNomisma = (function(superClass) {
  extend(CustomDataTypeNomisma, superClass);

  function CustomDataTypeNomisma() {
    return CustomDataTypeNomisma.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeNomisma.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-nomisma.nomisma";
  };

  CustomDataTypeNomisma.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.nomisma.name");
  };

  CustomDataTypeNomisma.prototype.getFrontendLanguage = function() {
    var desiredLanguage;
    desiredLanguage = ez5.loca.getLanguage();
    desiredLanguage = desiredLanguage.split('-');
    desiredLanguage = desiredLanguage[0];
    return desiredLanguage;
  };

  CustomDataTypeNomisma.prototype.__getAdditionalTooltipInfo = function(uri, tooltip, extendedInfo_xhr) {
    var nomismaID, nomismaType, path, that;
    that = this;
    uri = decodeURIComponent(uri);
    if (extendedInfo_xhr.xhr !== void 0) {
      extendedInfo_xhr.xhr.abort();
    }
    nomismaID = uri;
    nomismaID = nomismaID.split('/');
    nomismaID = nomismaID.pop();
    nomismaType = uri;
    nomismaType = nomismaType.split('/');
    nomismaType.shift();
    nomismaType.shift();
    nomismaType.shift();
    nomismaType = nomismaType.shift();
    path = location.protocol + '//uri.gbv.de/terminology/' + nomismaType + '/' + nomismaID + '?format=json';
    extendedInfo_xhr.xhr = new CUI.XHR({
      url: path
    });
    extendedInfo_xhr.xhr.start().done(function(data, status, statusText) {
      var entry, htmlContent, i, j, key, key2, keyUpperCased, len, len1, value;
      htmlContent = '<span style="font-weight: bold; padding: 3px 6px;">' + $$('custom.data.type.goobi.config.parameter.mask.infopopup.popup.info') + '</span>';
      htmlContent += '<table style="border-spacing: 10px; border-collapse: separate;">';
      if (data != null ? data.uri : void 0) {
        for (key in data) {
          value = data[key];
          if (key !== '@context' && key !== 'inScheme' && key !== 'depiction' && key !== 'notation' && key !== 'Moodifizierungsdatum' && key !== 'uri') {
            keyUpperCased = key.charAt(0).toUpperCase() + key.slice(1);
            htmlContent += '<tr><td style="min-width:150px;"><b>' + keyUpperCased + ':</b></td><td>';
            for (key2 = i = 0, len = value.length; i < len; key2 = ++i) {
              entry = value[key2];
              htmlContent += entry;
            }
            htmlContent += '</td></tr>';
          }
          if (key === 'depiction') {
            htmlContent += '<tr><td style="min-width:150px;"><br /><b>Examples of this type:</b></td><td></td></tr><tr><td colspan="2">';
            for (key2 = j = 0, len1 = value.length; j < len1; key2 = ++j) {
              entry = value[key2];
              htmlContent += '<img src="' + entry + '" class="nomisma_imageExample" />';
            }
            htmlContent += '</td></tr>';
          }
        }
        htmlContent += '</table>';
      }
      tooltip.DOM.innerHTML = htmlContent;
      return tooltip.autoSize();
    });
  };

  CustomDataTypeNomisma.prototype.__updateSuggestionsMenu = function(cdata, cdata_form, nomisma_searchterm, input, suggest_Menu, searchsuggest_xhr, layout, opts) {
    var delayMillisseconds, that;
    that = this;
    delayMillisseconds = 200;
    return setTimeout((function() {
      var extendedInfo_xhr, nomisma_countSuggestions, nomisma_set, ref, ref1, ref2, ref3, ref4, ref5;
      if (cdata_form) {
        nomisma_searchterm = cdata_form.getFieldsByName("searchbarInput")[0].getValue();
        nomisma_countSuggestions = cdata_form.getFieldsByName("countOfSuggestions")[0].getValue();
        nomisma_set = cdata_form.getFieldsByName("searchSetSelect")[0].getValue();
      } else {
        nomisma_countSuggestions = 20;
        if ((ref = that.getCustomSchemaSettings().crro) != null ? ref.value : void 0) {
          nomisma_set = 'crro';
        } else if ((ref1 = that.getCustomSchemaSettings().ocre) != null ? ref1.value : void 0) {
          nomisma_set = 'ocre';
        } else if ((ref2 = that.getCustomSchemaSettings().aod) != null ? ref2.value : void 0) {
          nomisma_set = 'aod';
        } else if ((ref3 = that.getCustomSchemaSettings().sco) != null ? ref3.value : void 0) {
          nomisma_set = 'sco';
        } else if ((ref4 = that.getCustomSchemaSettings().pella) != null ? ref4.value : void 0) {
          nomisma_set = 'pella';
        } else if ((ref5 = that.getCustomSchemaSettings().pco) != null ? ref5.value : void 0) {
          nomisma_set = 'pco';
        }
      }
      if (nomisma_searchterm.length === 0) {
        return;
      }
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      extendedInfo_xhr = {
        "xhr": void 0
      };
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      searchsuggest_xhr.xhr = new CUI.XHR({
        url: location.protocol + '//ws.gbv.de/suggest/numismatics.org/?searchstring=' + nomisma_searchterm + '&type=' + nomisma_set + '&count=' + nomisma_countSuggestions
      });
      return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
        var fn, i, itemList, key, len, menu_items, ref6, suggestion;
        menu_items = [];
        ref6 = data[1];
        fn = function(key) {
          var item;
          item = {
            text: suggestion,
            value: data[3][key],
            tooltip: {
              markdown: true,
              placement: "w",
              content: function(tooltip) {
                that.__getAdditionalTooltipInfo(data[3][key], tooltip, extendedInfo_xhr);
                return new CUI.Label({
                  icon: "spinner",
                  text: $$('custom.data.type.nomisma.modal.form.popup.loadingstring')
                });
              }
            }
          };
          return menu_items.push(item);
        };
        for (key = i = 0, len = ref6.length; i < len; key = ++i) {
          suggestion = ref6[key];
          fn(key);
        }
        itemList = {
          onClick: function(ev2, btn) {
            var dataEntry_xhr, nomismaID, nomismaType, path;
            cdata.conceptURI = btn.getOpt("value");
            cdata.conceptName = btn.getText();
            cdata.conceptFulltext = cdata.conceptName;
            nomismaID = cdata.conceptURI;
            nomismaID = nomismaID.split('/');
            nomismaID = nomismaID.pop();
            nomismaType = cdata.conceptURI;
            nomismaType = nomismaType.split('/');
            nomismaType.shift();
            nomismaType.shift();
            nomismaType.shift();
            nomismaType = nomismaType.shift();
            path = '//uri.gbv.de/terminology/' + nomismaType + '/' + nomismaID + '?format=json';
            dataEntry_xhr = new CUI.XHR({
              url: location.protocol + path
            });
            return dataEntry_xhr.start().done(function(data, status, statusText) {
              var fulltext;
              fulltext = '';
              if (data != null ? data.Titel : void 0) {
                fulltext += ' ' + data.Titel;
              }
              if (data != null ? data.Nominale : void 0) {
                fulltext += ' ' + data.Nominale;
              }
              if (data != null ? data.notation : void 0) {
                fulltext += ' ' + data.notation.join(' ');
              }
              if (data != null ? data.identifier : void 0) {
                fulltext += ' ' + data.identifier.join(' ');
              }
              cdata.conceptFulltext = fulltext;
              that.__updateResult(cdata, layout, opts);
              suggest_Menu.hide();
              if (that.popover) {
                return that.popover.hide();
              }
            });
          },
          items: menu_items
        };
        if (itemList.items.length === 0) {
          itemList = {
            items: [
              {
                text: $$('custom.data.type.nomisma.no_hit'),
                value: void 0
              }
            ]
          };
        }
        suggest_Menu.setItemList(itemList);
        return suggest_Menu.show();
      });
    }), delayMillisseconds);
  };

  CustomDataTypeNomisma.prototype.__getEditorFields = function(cdata) {
    var fields, option, ref, ref1, ref2, ref3, ref4, ref5, searchOptions;
    searchOptions = [];
    if ((ref = this.getCustomSchemaSettings().crro) != null ? ref.value : void 0) {
      option = {
        value: 'crro',
        text: $$('custom.data.type.nomisma.config.parameter.schema.crro.value.label_long')
      };
      searchOptions.push(option);
    }
    if ((ref1 = this.getCustomSchemaSettings().ocre) != null ? ref1.value : void 0) {
      option = {
        value: 'ocre',
        text: $$('custom.data.type.nomisma.config.parameter.schema.ocre.value.label_long')
      };
      searchOptions.push(option);
    }
    if ((ref2 = this.getCustomSchemaSettings().aod) != null ? ref2.value : void 0) {
      option = {
        value: 'aod',
        text: $$('custom.data.type.nomisma.config.parameter.schema.aod.value.label_long')
      };
      searchOptions.push(option);
    }
    if ((ref3 = this.getCustomSchemaSettings().sco) != null ? ref3.value : void 0) {
      option = {
        value: 'sco',
        text: $$('custom.data.type.nomisma.config.parameter.schema.sco.value.label_long')
      };
      searchOptions.push(option);
    }
    if ((ref4 = this.getCustomSchemaSettings().pella) != null ? ref4.value : void 0) {
      option = {
        value: 'pella',
        text: $$('custom.data.type.nomisma.config.parameter.schema.pella.value.label_long')
      };
      searchOptions.push(option);
    }
    if ((ref5 = this.getCustomSchemaSettings().pco) != null ? ref5.value : void 0) {
      option = {
        value: 'pco',
        text: $$('custom.data.type.nomisma.config.parameter.schema.pco.value.label_long')
      };
      searchOptions.push(option);
    }
    fields = [
      {
        type: CUI.Select,
        "class": "commonPlugin_Select",
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.nomisma.modal.form.text.count')
        },
        options: [
          {
            value: 10,
            text: '10 ' + $$('custom.data.type.nomisma.modal.form.text.count_short')
          }, {
            value: 20,
            text: '20 ' + $$('custom.data.type.nomisma.modal.form.text.count_short')
          }, {
            value: 50,
            text: '50 ' + $$('custom.data.type.nomisma.modal.form.text.count_short')
          }, {
            value: 100,
            text: '100 ' + $$('custom.data.type.nomisma.modal.form.text.count_short')
          }, {
            value: 500,
            text: '500 ' + $$('custom.data.type.nomisma.modal.form.text.count_short')
          }
        ],
        name: 'countOfSuggestions'
      }, {
        type: CUI.Select,
        "class": "commonPlugin_Select",
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.nomisma.modal.form.text.searchfield')
        },
        options: searchOptions,
        name: 'searchSetSelect'
      }, {
        type: CUI.Input,
        "class": "commonPlugin_Input",
        undo_and_changed_support: false,
        form: {
          label: $$("custom.data.type.nomisma.modal.form.text.searchbar")
        },
        placeholder: $$("custom.data.type.nomisma.modal.form.text.searchbar.placeholder"),
        name: "searchbarInput"
      }
    ];
    return fields;
  };

  CustomDataTypeNomisma.prototype.__renderButtonByData = function(cdata) {
    var extendedInfo_xhr, that;
    that = this;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.nomisma.edit.no_nomisma")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.nomisma.edit.no_valid_nomisma")
        }).DOM;
    }
    extendedInfo_xhr = {
      "xhr": void 0
    };
    cdata.conceptURI = CUI.parseLocation(cdata.conceptURI).url;
    return new CUI.HorizontalLayout({
      maximize: true,
      left: {
        content: new CUI.Label({
          centered: false,
          text: cdata.conceptName
        })
      },
      center: {
        content: new CUI.Button({
          appearance: "link",
          icon_left: new CUI.Icon({
            "class": "fa-info-circle"
          }),
          tooltip: {
            markdown: true,
            placement: 'w',
            content: function(tooltip) {
              var uri;
              uri = cdata.conceptURI;
              that.__getAdditionalTooltipInfo(uri, tooltip, extendedInfo_xhr);
              return new CUI.Label({
                icon: "spinner",
                text: $$('custom.data.type.nomisma.modal.form.popup.loadingstring')
              });
            }
          },
          text: ""
        })
      },
      right: null
    }).DOM;
  };

  CustomDataTypeNomisma.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    this;
    var ref, ref1, ref2, ref3, ref4, ref5, tags;
    tags = [];
    if ((ref = custom_settings.crro) != null ? ref.value : void 0) {
      tags.push("✓ CRRO");
    } else {
      tags.push("✘ CRRO");
    }
    if ((ref1 = custom_settings.ocre) != null ? ref1.value : void 0) {
      tags.push("✓ OCRE");
    } else {
      tags.push("✘ OCRE");
    }
    if ((ref2 = custom_settings.aod) != null ? ref2.value : void 0) {
      tags.push("✓ AOD");
    } else {
      tags.push("✘ AOD");
    }
    if ((ref3 = custom_settings.pco) != null ? ref3.value : void 0) {
      tags.push("✓ PCO");
    } else {
      tags.push("✘ PCO");
    }
    if ((ref4 = custom_settings.pella) != null ? ref4.value : void 0) {
      tags.push("✓ PELLA");
    } else {
      tags.push("✘ PELLA");
    }
    if ((ref5 = custom_settings.sco) != null ? ref5.value : void 0) {
      tags.push("✓ SCO");
    } else {
      tags.push("✘ SCO");
    }
    return tags;
  };

  return CustomDataTypeNomisma;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeNomisma);
