class Easydb4MigrationPlugin.MdcBerlin extends Easydb4MigrationPlugin
	name: ->
		"mdc-berlin"

	person_typ:
		"typ_fotograf": ["Fotograf", "Photographer"]

	payload: (filename, json, update, store_file) ->

		if json.import_type == "tags"

			dfr = new CUI.Deferred()
			freigabestufen_tags = json.tags[0]._tags

			update_freigabestufe = (reference, displayname_de, displayname_en, desc_de, desc_en) =>
				console.debug "update ref:", reference
				for tag in freigabestufen_tags
					console.debug "tag:", tag
					if tag.tag.reference == reference
						console.debug "yo:", tag
						tag.tag.displayname =
							"de-DE": displayname_de
							"en-US": displayname_en
						tag.tag.description =
							"de-DE": desc_de
							"en-US": desc_en
				return

			add_tag = (shortname, displayname_de, displayname_en, desc_de, desc_en) =>
				_tags.push
					tag:
						shortname: shortname
						displayname:
							"de-DE": displayname_de
							"en-US": displayname_en
						description:
							"de-DE": desc_de
							"en-US": desc_en
						is_default: false
						enabled: true
						displaytype: "search"
						type: "individual"

			_tags = []

			json.tags.push
				taggroup:
					reference: "easydb4:persontyp"
					type: "checkbox"
					displayname:
						"de-DE": "Personentyp"
				_tags: _tags

			for k, v of @person_typ
				add_tag(k, v[0], v[1], undefined, undefined)

			@_migration.query('SELECT id, name, name_en, remark, remark_en FROM "source.public.freigabestufen" ORDER BY id')
			.fail(dfr.reject)
			.done (result) =>
				console.debug "stufen", result
				for row in result.rows
					update_freigabestufe("freigabestufen:"+row.id, row.name, row.name_en, row.remark, row.remark_en)
				dfr.resolve()

			dfr.always =>
				console.debug "payload:", filename, json, update, store_file

			return dfr.promise()

		if json.objecttype == "person"
			for obj in json.objects
				if not obj._tags
					obj._tags = []

				if obj.person.ist_fotograf
					obj._tags.push
						"lookup:_id":
							shortname: "typ_fotograf"

			return


		return



ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.MdcBerlin)
