// Generated by CoffeeScript 1.12.7
var ExportTransportFTP,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ExportTransportFTP = (function(superClass) {
  extend(ExportTransportFTP, superClass);

  function ExportTransportFTP() {
    return ExportTransportFTP.__super__.constructor.apply(this, arguments);
  }

  ExportTransportFTP.prototype.getType = function() {
    if (ez5.version("6")) {
      return "easydb-export-transport-ftp-plugin:transport_ftp";
    } else {
      return "ftp";
    }
  };

  ExportTransportFTP.prototype.getDisplayType = function() {
    return $$("export.transport.ftp.type|text");
  };

  ExportTransportFTP.prototype.getDisplayIcon = function() {
    return ez5.loca.str_default("export.transport.ftp.type|icon");
  };

  ExportTransportFTP.prototype.isAllowed = function() {
    return true;
  };

  ExportTransportFTP.prototype.getOptionsDisplay = function(data) {
    if (data.options.server) {
      return [data.options.server];
    } else {

    }
  };

  ExportTransportFTP.prototype.getOptions = function() {
    var fields, formOpts, i, len, opt, ref;
    fields = [];
    ref = [
      {
        key: "server",
        hint: true
      }, {
        key: "directory",
        hint: true
      }, {
        key: "login"
      }, {
        key: "password"
      }
    ];
    for (i = 0, len = ref.length; i < len; i++) {
      opt = ref[i];
      formOpts = {
        label: $$("export.transport.ftp.option." + opt.key)
      };
      if (opt.hint) {
        formOpts.hint = $$("export.transport.ftp.option.hint." + opt.key);
      }
      fields.push({
        type: CUI.Input,
        name: opt.key,
        form: formOpts,
        maximize_horizontal: true
      });
    }
    formOpts = {
      label: $$("export.transport.ftp.option.packer")
    };
    fields.push({
      type: CUI.DataFieldProxy,
      name: "packer",
      form: formOpts,
      element: (function(_this) {
        return function(field) {
          var data, select;
          data = field.getData();
          if (CUI.util.isUndef(data.packer)) {
            data.packer = "folder";
          }
          select = new CUI.Select({
            name: "packer",
            data: data,
            options: function() {
              var j, k, len1, options, ref1;
              options = [];
              ref1 = ["folder", "zip", "tar.gz"];
              for (j = 0, len1 = ref1.length; j < len1; j++) {
                k = ref1[j];
                options.push({
                  text: $$("export.transport.packer." + k),
                  value: k
                });
              }
              return options;
            }
          });
          select.start();
          return select;
        };
      })(this)
    });
    return fields;
  };

  ExportTransportFTP.prototype.getSaveData = function(data) {
    var loc, ref, ref1;
    if (!((ref = data.options) != null ? ref.server : void 0)) {
      throw new InvalidSaveDataException();
    }
    loc = CUI.parseLocation(data.options.server);
    if (!loc || !loc.hostname || ((ref1 = !loc.protocol) === "ftp" || ref1 === "ftps" || ref1 === "sftp")) {
      throw new InvalidSaveDataException();
    }
  };

  ExportTransportFTP.prototype.supportsPacker = function() {
    return false;
  };

  return ExportTransportFTP;

})(ExportTransportPlugin);

CUI.ready((function(_this) {
  return function() {
    return TransportsEditor.registerPlugin(new ExportTransportFTP());
  };
})(this));
// Generated by CoffeeScript 1.12.7
var ExportTransportWebDAV,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ExportTransportWebDAV = (function(superClass) {
  extend(ExportTransportWebDAV, superClass);

  function ExportTransportWebDAV() {
    return ExportTransportWebDAV.__super__.constructor.apply(this, arguments);
  }

  ExportTransportWebDAV.prototype.getType = function() {
    return "easydb-export-transport-ftp-plugin:transport_webdav";
  };

  ExportTransportWebDAV.prototype.getDisplayType = function() {
    return $$("export.transport.webdav.type|text");
  };

  ExportTransportWebDAV.prototype.getDisplayIcon = function() {
    return ez5.loca.str_default("export.transport.webdav.type|icon");
  };

  ExportTransportWebDAV.prototype.isAllowed = function() {
    return true;
  };

  ExportTransportWebDAV.prototype.getOptionsDisplay = function(data) {
    if (data.options.server) {
      return [data.options.server];
    } else {

    }
  };

  ExportTransportWebDAV.prototype.getOptions = function() {
    var fields, formOpts, i, len, opt, ref;
    fields = [];
    ref = [
      {
        key: "server",
        hint: true
      }, {
        key: "directory",
        hint: true
      }, {
        key: "login",
        hint: true
      }, {
        key: "password",
        hint: true
      }
    ];
    for (i = 0, len = ref.length; i < len; i++) {
      opt = ref[i];
      formOpts = {
        label: $$("export.transport.webdav.option." + opt.key)
      };
      if (opt.hint) {
        formOpts.hint = $$("export.transport.webdav.option.hint." + opt.key);
      }
      fields.push({
        type: CUI.Input,
        name: opt.key,
        form: formOpts,
        maximize_horizontal: true
      });
    }
    formOpts = {
      label: $$("export.transport.webdav.option.packer")
    };
    fields.push({
      type: CUI.DataFieldProxy,
      name: "packer",
      form: formOpts,
      element: (function(_this) {
        return function(field) {
          var data, select;
          data = field.getData();
          if (CUI.util.isUndef(data.packer)) {
            data.packer = "folder";
          }
          select = new CUI.Select({
            name: "packer",
            data: data,
            options: function() {
              var j, k, len1, options, ref1;
              options = [];
              ref1 = ["folder", "zip", "tar.gz"];
              for (j = 0, len1 = ref1.length; j < len1; j++) {
                k = ref1[j];
                options.push({
                  text: $$("export.transport.packer." + k),
                  value: k
                });
              }
              return options;
            }
          });
          select.start();
          return select;
        };
      })(this)
    });
    return fields;
  };

  ExportTransportWebDAV.prototype.getSaveData = function(data) {
    var loc, ref, ref1;
    if (!((ref = data.options) != null ? ref.server : void 0)) {
      throw new InvalidSaveDataException();
    }
    loc = CUI.parseLocation(data.options.server);
    if (!loc || !loc.hostname || ((ref1 = !loc.protocol) === "http" || ref1 === "https")) {
      throw new InvalidSaveDataException();
    }
  };

  ExportTransportWebDAV.prototype.supportsPacker = function() {
    return false;
  };

  return ExportTransportWebDAV;

})(ExportTransportPlugin);

CUI.ready((function(_this) {
  return function() {
    if (ez5.version("6")) {
      return TransportsEditor.registerPlugin(new ExportTransportWebDAV());
    }
  };
})(this));
