class FalconIOFilepicker extends Filepicker
	type: ->
		'falconio'

	readOpts: ->
		super()
		@setDownloadManagerClass(FalconIODownloadManager)


	getCurrentTools: (col) ->
		baseConfig = ez5.session.getBaseConfig("plugin", "easydb-falconio-plugin")
		baseConfig = baseConfig.system or baseConfig # TODO: Remove this after #64076 is merged.
		base_conf = baseConfig[@type()] or {}
		bool = false

		#check priviledges and viewing rights
		for inst in base_conf.fio_instances or []
			if inst.active and inst.auth != ""
				bool = true
		if not ez5.session.hasSystemRight("root", "plugin.easydb-falconio-plugin.falconio")
			return
		if not bool
			return
		if col not instanceof CollectionSelection
			return tools
		count = col.getCount()
		if count == 0
			return tools

		base_conf.send_files = true
		base_conf.falconio_url = "https://api.falcon.io/publish/publishing/template?apikey="
		tools = []
		tool = []
		count = col.getCount()
		that = @
		for inst in base_conf.fio_instances
			if inst.active and inst.auth != ""
				tool.push new ToolboxTool
					group: col.getToolGroup()
					name: col.getToolNamePrefix()+'.'+@__type+'.download.' + inst.name
					#loca_key: inst.name
					text: inst.name
					run : ->
						for x in base_conf.fio_instances
							if x.name == @opts.text
								col.auth = x.auth

						new that.__downloadManagerCls(collection: col).startExport()
						return

		tools.push new ToolboxTool
			group: col.getToolGroup()
			name: col.getToolNamePrefix()+'.'+@__type+'.download'
			sort: "D:3"
			loca_key: "tool."+col.getToolNamePrefix()+'.'+@__type+'.download'
			tools : tool
			loca_key_attrs:
				count: count
			favorite: true

		tools


ez5.session_ready ->
	Collection.registerPlugin(new FalconIOFilepicker())