class ez5.PdfCreator.Node.Div extends ez5.PdfCreator.Node

	@getName: ->
		"div"

	__renderPdfContent: (opts) ->
		div = CUI.dom.div()

		if not @children
			return div

		for node in @children
			CUI.dom.append(div, node.renderPdfContent(opts))

		return div

	__getStyleSettings: ->
		return [
			"class-name"
			"height"
			"width"
			"display"
			"background"
			"font-size"
			"color"
			"position-absolute"
			"top"
			"bottom"
			"left"
			"right"
			"margin-top"
			"margin-bottom"
			"margin-left"
			"margin-right"
			"padding-top"
			"padding-bottom"
			"padding-left"
			"padding-right"
			"border-top"
			"border-bottom"
			"border-left"
			"border-right"
		]

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.Div)