class ez5.PdfCreator.Node.EAS extends ez5.PdfCreator.Node.Div

	@getName: ->
		"eas"

	__renderPdfContent: ->
		data = @getData()
		div = CUI.dom.div()
		fileData = data["file:eas_file"]
		if fileData?._id
			asset = new AssetPlain(value: fileData)
			CUI.dom.append(div, asset.getImgElement(null, "original", for_print: true))
		else
			span = CUI.dom.span()
			span.textContent = "< #{$$("pdf-creator.settings.node.eas.no-file-selected")} >"
			CUI.dom.append(div, span)
		return div

	__getSettingsFields: ->
		eas_field = new EASField
			name: "file:eas_file"

		fields = [
			type: CUI.DataFieldProxy
			form: label: $$("pdf-creator.settings.node.eas.file")
			name: "file:eas_file"
			element: (df) =>
				eas_field.renderEditorInput(df.getData(), null)
		]
		return fields

	getSaveData: ->
		saveData = super()
		_data = saveData.data
		if _data?["file:eas_file"]?._id
			_data["file:eas_file"] = _id: _data["file:eas_file"]._id
		else
			delete _data["file:eas_file"]
		return saveData

	__getStyleSettings: ->
		return ["class-name", "width"]

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.EAS)