#!/bin/python3

import argparse
import requests
import json
from datetime import datetime


API_URL = 'https://germanywestcentral.api.cognitive.microsoft.com/computervision/imageanalysis:analyze'

argparser = argparse.ArgumentParser(description='Test AI Image Tagging | api.cognitive.microsoft.com/computervision')


argparser.add_argument('-cf', '--client-file', default='', help='File with Client ID and Secret')
argparser.add_argument('-ak', '--api-key', default='', help='API Key (if set, ignore --client-file)')
argparser.add_argument('-i', '--image-url', help='Image URL')
argparser.add_argument('-api', '--api-url', default=API_URL, help='API URL (default: {})'.format(API_URL))
argparser.add_argument('-av', '--api-version', default='2022-10-12-preview', help='API Version (default: 2022-10-12-preview)')
argparser.add_argument('-l', '--language', default='en', help='Language [en, es, ja, pt, zh] (default: en)')
argparser.add_argument('-f', '--features', default='Description,Tags,Objects',
                       help='Features [Read, Description, SmartCrops, Objects, Tags] (default: Description,Tags,Objects)')


if __name__ == '__main__':
    args = argparser.parse_args()

    api_key = args.api_key

    if args.client_file != '':
        with open(args.client_file, 'r') as f:
            content = f.read()
            parts = content.split('\n')
            if len(parts) > 0:
                c_id = parts[0].strip()
                if len(c_id) > 0:
                    api_key = c_id

    image = args.image_url
    print('Image URL:', image)

    lang = args.language
    if lang == '':
        lang = 'en'

    start = datetime.now()
    response = requests.post(
        API_URL,
        json={
            'url': image,
        },
        params={
            'language': lang,
            'features': args.features,
            'api-version': args.api_version,
            'model-version': 'latest',
        },
        headers={
            'Content-Type': 'application/json',
            'Ocp-Apim-Subscription-Key': api_key,
        }
    )
    took = datetime.now() - start
    print('Request took', took)

    print(response.request.headers)
    print(response.request.body)

    if response.status_code != 200:
        print(response.text)
        exit(1)

    response = json.loads(response.text)
    print('Response:', json.dumps(response, indent=4))
