// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node.Barcode = (function(superClass) {
  extend(Barcode, superClass);

  function Barcode() {
    return Barcode.__super__.constructor.apply(this, arguments);
  }

  Barcode.getName = function() {
    return "barcode";
  };

  Barcode.prototype.__renderPdfContent = function(opts) {
    var barcode, barcodeData, barcodeWidth, data, fieldName, object, objectName, ref, ref1;
    object = opts.object;
    if (!object) {
      return;
    }
    data = this.getData();
    if (!data.field_name) {
      return;
    }
    ref = data.field_name.split("."), objectName = ref[0], fieldName = (ref1 = ref[1]) != null ? ref1 : objectName;
    if (fieldName.startsWith("_")) {
      barcodeData = object[fieldName];
    } else {
      barcodeData = object[objectName][fieldName];
    }
    if (data != null ? data.code_prefix : void 0) {
      barcodeData = data.code_prefix + barcodeData;
    }
    if (data != null ? data.code_suffix : void 0) {
      barcodeData = barcodeData + data.code_suffix;
    }
    if (!barcodeData) {
      return;
    }
    barcode = new ez5.Barcode({
      mode: "pdf",
      type: data.code_type,
      barcode_type: data.barcode_type
    });
    barcode.render(barcodeData);
    barcodeWidth = data.barcode_width || "100%";
    CUI.dom.setStyle(barcode.DOM, {
      width: barcodeWidth
    });
    return barcode.DOM;
  };

  Barcode.prototype.__getSettingsFields = function() {
    var fields, idObjecttype;
    idObjecttype = this.__getIdObjecttype();
    fields = ez5.BarcodeMaskSplitter.getBarcodeOptions(idObjecttype, {
      store_value: "fullname",
      filter: function(field) {
        return !field.insideNested();
      }
    });
    fields.push({
      type: CUI.Input,
      name: "barcode_width",
      form: {
        label: $$("pdf-creator.settings.barcode.barcode-width|text")
      },
      placeholder: $$("pdf-creator.settings.barcode.barcode-width|placeholder")
    });
    return fields;
  };

  Barcode.prototype.__getStyleSettings = function() {
    return ["class-name"];
  };

  return Barcode;

})(ez5.PdfCreator.Node);

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.Barcode);
