class BaseMigrationNodeGroupType extends BaseMigrationNodeData

	initOpts: ->
		super()
		@addOpts
			type:
				mandatory: true
				check: ["system", "easydb"]

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getDisplayText: ->
		@_type

	checkMigrateButton: ->
		@__migrateBtn.enable()

	getActionFields: ->
		fields = BaseMigrationNodeGroup::getActionFields.call(@)

		if @_type == "system"
			# remove add / replace config for system
			fields.splice(2, 1)

		fields


	migrate: (ev, action_data) ->

		new_groups = @migrateGroups(action_data)

		if ev.hasModifierKey()
			console.debug "migrate Groups:", CUI.util.dump(new_groups), new_groups
			return CUI.resolvedPromise()

		BaseMigrationNodeGroup::saveGroups.call(@, new_groups)
		.done =>
			@log($$("base.migration.console.log.group.type.migrated.md",
				count: new_groups.length
				type: @_type
			))


	migrateGroups: (action_data) ->

		new_groups = []
		for c in @children
			new_group = c.migrateGroup(action_data)
			new_groups.push(new_group)

		new_groups

