class BaseMigrationNodeObjecttypes extends BaseMigrationNodeData

	getDisplayText: ->
		$$("base.migration.node.objecttype.text")

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getActionFields: ->
		acl = []
		columnFilters = []
		for c in @children
			data = c.getData()
			name = c.getDisplayText()

			if data._acl.length > 0
				acl.push("#{name} (#{data._acl.length})")

			if data._columnfilters.length > 0
				columnFilters.push("#{name} (#{data._columnfilters.length})")

		[
			type: CUI.Options
			name: "migrate"
			form:
				label: $$("base.migration.node.objecttypes.permissions.label")
			options: [
				text: if acl.length != 0 then acl.join(", ") else $$("base.migration.node.objecttype.empty-selection")
				disabled: acl.length == 0
				value: "acl"
			]
		,
			type: CUI.Options
			name: "migrate"
			form:
				label: $$("base.migration.node.objecttypes.columnfilters.label")
			options: [
				text: if columnFilters.length != 0 then columnFilters.join(", ") else $$("base.migration.node.objecttype.empty-selection")
				disabled: columnFilters.length == 0
				value: "columnfilters"
			]
		,
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$("base.migration.node.objecttype.mode.label")
			options: [
				text: $$("base.migration.node.objecttype.mode.replace")
				value: "replace"
			,
				text: $$("base.migration.node.objecttype.mode.add")
				value: "add"
			]
		]


	checkMigrateButton: ->
		@__migrateBtn.disable()
		if @__actionData.migrate.length == 0
			return
		@__migrateBtn.enable()
		return

	migrate: (ev, action_data) ->

		dfr = new CUI.Deferred()

		idx = 0
		next_ot_node = =>
			if idx == @children.length
				dfr.resolve()
				return

			ot_node = @children[idx]
			ret = ot_node.migrate(ev, action_data)
			ret
			.done =>
				idx++
				next_ot_node()
			.fail =>
				dfr.reject()

		next_ot_node()

		dfr.promise()

