// Generated by CoffeeScript 1.12.7
var BaseMigrationNodePool,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

BaseMigrationNodePool = (function(superClass) {
  extend(BaseMigrationNodePool, superClass);

  function BaseMigrationNodePool() {
    return BaseMigrationNodePool.__super__.constructor.apply(this, arguments);
  }

  BaseMigrationNodePool.prototype.getDisplayText = function() {
    return ez5.loca.getBestFrontendValue(this.getData().pool.name);
  };

  BaseMigrationNodePool.prototype.hasRightPane = function() {
    return true;
  };

  BaseMigrationNodePool.prototype.getActionPane = function() {
    var pane;
    pane = this.getActionPaneBase();
    ez5.api.pool().done((function(_this) {
      return function(pools) {
        var target_pools;
        target_pools = BaseMigrationNodePool.buildPoolTree(_this.getMigration(), pools);
        target_pools.sort(function(poolNode, nextPoolNode) {
          return poolNode.getDisplayText().localeCompare(nextPoolNode.getDisplayText());
        });
        _this.__targetTree = new CUI.ListViewTree({
          cols: ["maximize"],
          selectableRows: true,
          header_left: new CUI.Label({
            text: $$("base.migration.node.pool.target.text")
          }),
          children: target_pools,
          onSelect: function() {
            return _this.checkMigrateButton();
          },
          onDeselect: function() {
            return _this.checkMigrateButton();
          }
        });
        _this.getLayout().replace(_this.__targetTree.render(), "right");
        return _this.__targetTree.root.open();
      };
    })(this));
    return pane;
  };

  BaseMigrationNodePool.prototype.getActionFields = function() {
    return [
      {
        type: CUI.Output,
        form: {
          label: $$("base.migration.node.pool.text")
        },
        text: this.getDisplayText()
      }, {
        type: CUI.Options,
        name: "migrate",
        form: {
          label: $$("base.migration.common.selection")
        },
        options: [
          {
            text: $$("base.migration.node.pool.check_acl", {
              acl_count: this.getData()._acl.length
            }),
            disabled: this.getData()._acl.length === 0,
            value: "acl"
          }
        ]
      }, {
        type: CUI.Options,
        name: "mode",
        radio: true,
        form: {
          label: $$("base.migration.common.options")
        },
        options: [
          {
            text: $$("base.migration.common.replace"),
            value: "replace"
          }, {
            text: $$("base.migration.common.add"),
            value: "add"
          }
        ]
      }
    ];
  };

  BaseMigrationNodePool.prototype.migrate = function(ev, action_data) {
    var do_save, migration, new_acl, save_pool, source_pool, target_pool, target_pool_node;
    console.debug("migrate Pool:", this.getDisplayText());
    target_pool_node = this.__targetTree.getSelectedNode();
    target_pool = target_pool_node.getData();
    source_pool = this.getData();
    migration = this.getMigration();
    save_pool = {
      _basetype: "pool",
      pool: {
        _id: target_pool.pool._id,
        _id_parent: target_pool.pool._id_parent,
        _version: target_pool.pool._version + 1
      }
    };
    if (target_pool.pool.is_system_pool) {
      delete save_pool.pool._id_parent;
    }
    do_save = false;
    if (indexOf.call(action_data.migrate, "acl") >= 0) {
      new_acl = migration.migrateACL(source_pool._acl);
      if (new_acl.length > 0) {
        save_pool._acl = [];
        if (action_data.mode === "add") {
          save_pool._acl.push.apply(save_pool._acl, target_pool._acl);
        }
        save_pool._acl.push.apply(save_pool._acl, new_acl);
        save_pool._private_acl = source_pool._private_acl;
        do_save = true;
      }
    }
    if (!do_save) {
      console.debug("no migratable data.");
      return CUI.resolvedPromise();
    }
    if (ev.hasModifierKey()) {
      console.debug("pool save:", CUI.util.dump(save_pool));
      return CUI.resolvedPromise();
    }
    this.log($$("base.migration.console.log.pool.saving.md", {
      name: this.getDisplayText()
    }));
    return ez5.api.pool({
      type: "POST",
      json_data: [save_pool]
    }).done((function(_this) {
      return function(pool_data) {
        _this.log($$("base.migration.console.log.pool.saved.md", {
          name: _this.getDisplayText(),
          count_acl: save_pool._acl.length
        }));
        console.debug("pool_data", pool_data);
        return target_pool_node.setData(pool_data[0]);
      };
    })(this));
  };

  BaseMigrationNodePool.prototype.checkMigrateButton = function() {
    var ref;
    this.__migrateBtn.disable();
    if (!((ref = this.__targetTree) != null ? ref.getSelectedNode() : void 0)) {
      return;
    }
    if (this.__actionData.migrate.length === 0) {
      return;
    }
    this.__migrateBtn.enable();
  };

  BaseMigrationNodePool.buildPoolTree = function(migration, data) {
    console.debug("building pool tree", data);
    return ez5.buildObjectTree({
      objects: data,
      objectKey: "pool",
      doOpen: false,
      newInstanceFunc: function(o) {
        return new BaseMigrationNodePool({
          migration: migration,
          data: o
        });
      }
    });
  };

  BaseMigrationNodePool.getSourceNodesFromData = function(migration, data) {
    var pools;
    pools = BaseMigrationNodePool.buildPoolTree(migration, data);
    pools.sort((function(_this) {
      return function(a, b) {
        return a.getDisplayText().localeCompare(b.getDisplayText());
      };
    })(this));
    return [
      new BaseMigrationNodeStructure({
        migration: migration,
        name: $$("base.migration.node.pool.pools.text"),
        children: pools
      })
    ];
  };

  return BaseMigrationNodePool;

})(BaseMigrationNodeData);
