class BaseMigrationNodeTransitions extends BaseMigrationNodeObjecttypes

	getDisplayText: ->
		"Workflows"

	getActionFields: ->

		[
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$("base.migration.common.options")
			options: [
				text: $$("base.migration.common.replace")
				value: "replace"
			,
				text: $$("base.migration.common.add")
				value: "add"
			]
		]


	migrate: (ev, action_data) ->
		migration = @getMigration()

		if action_data == "replace"
			target = []
		else
			target = CUI.util.copyObject(migration.getBaseData().transitions, true)

		for c in @children
			copied_transition = migration.migrateTransition(c.getData())

			if copied_transition
				target.push(copied_transition)

		if ev.hasModifierKey()
			console.debug "migrate Transitions:", CUI.util.dump(target), target
			return CUI.resolvedPromise()

		BaseMigrationNodeTransition::saveTransitions.call(@, target)


	checkMigrateButton: ->
		@__migrateBtn.enable()
