// Generated by CoffeeScript 1.12.7
var GazetteerUpdate;

GazetteerUpdate = (function() {
  function GazetteerUpdate() {}

  GazetteerUpdate.prototype.__start_update = function(arg) {
    var plugin_config, server_config;
    server_config = arg.server_config, plugin_config = arg.plugin_config;
    return ez5.respondSuccess({
      state: {
        "start_update": new Date().toUTCString()
      }
    });
  };

  GazetteerUpdate.prototype.__updateData = function(arg) {
    var gazId, i, len, object, objects, objectsMap, plugin_config, ref, searchIds, searchQuery, timeout;
    objects = arg.objects, plugin_config = arg.plugin_config;
    objectsMap = {};
    searchIds = [];
    for (i = 0, len = objects.length; i < len; i++) {
      object = objects[i];
      if (!(object.identifier && object.data)) {
        continue;
      }
      gazId = object.data.gazId;
      if (CUI.util.isEmpty(gazId)) {
        continue;
      }
      if (!objectsMap[gazId]) {
        objectsMap[gazId] = [];
      }
      objectsMap[gazId].push(object);
      searchIds.push("_id:" + gazId);
    }
    if (searchIds.length === 0) {
      return ez5.respondSuccess({
        payload: []
      });
    }
    timeout = ((ref = plugin_config.update) != null ? ref.timeout : void 0) || 0;
    timeout *= 1000;
    searchQuery = searchIds.join(" OR ");
    searchQuery = CUI.encodeURIComponentNicely(searchQuery);
    return ez5.GazetteerUtil.searchByQuery(searchQuery, {
      timeout: timeout
    }).done((function(_this) {
      return function(data) {
        var _object, gazObject, gazObjects, j, k, len1, len2, objectsToUpdate, ref1;
        objectsToUpdate = [];
        gazObjects = data.result;
        for (j = 0, len1 = gazObjects.length; j < len1; j++) {
          gazObject = gazObjects[j];
          if (!objectsMap[gazObject.gazId]) {
            continue;
          }
          gazObject = ez5.GazetteerUtil.setObjectData({}, gazObject);
          ref1 = objectsMap[gazObject.gazId];
          for (k = 0, len2 = ref1.length; k < len2; k++) {
            _object = ref1[k];
            if (!_this.__hasChanges(_object.data, gazObject)) {
              continue;
            }
            _object.data = ez5.GazetteerUtil.getSaveDataObject(gazObject);
            objectsToUpdate.push(_object);
          }
        }
        return ez5.respondSuccess({
          payload: objectsToUpdate
        });
      };
    })(this)).fail((function(_this) {
      return function(e) {
        return ez5.respondError("custom.data.type.gazeteer.update.error.generic", {
          searchQuery: searchQuery,
          error: e + ""
        });
      };
    })(this));
  };

  GazetteerUpdate.prototype.__hasChanges = function(objectOne, objectTwo) {
    var i, key, len, ref;
    ref = ["displayName", "gazId", "otherNames", "types", "position", "iconName", "_fulltext"];
    for (i = 0, len = ref.length; i < len; i++) {
      key = ref[i];
      if (!CUI.util.isEqual(objectOne[key], objectTwo[key])) {
        return true;
      }
    }
    return false;
  };

  GazetteerUpdate.prototype.main = function(data) {
    var i, key, len, ref;
    if (!data) {
      ez5.respondError("custom.data.type.gazeteer.update.error.payload-missing");
      return;
    }
    ref = ["action", "server_config", "plugin_config"];
    for (i = 0, len = ref.length; i < len; i++) {
      key = ref[i];
      if (!data[key]) {
        ez5.respondError("custom.data.type.gazeteer.update.error.payload-key-missing", {
          key: key
        });
        return;
      }
    }
    if (data.action === "start_update") {
      this.__start_update(data);
    } else if (data.action === "update") {
      if (!data.objects) {
        ez5.respondError("custom.data.type.gazeteer.update.error.objects-missing");
        return;
      }
      if (!(data.objects instanceof Array)) {
        ez5.respondError("custom.data.type.gazeteer.update.error.objects-not-array");
        return;
      }
      if (!data.state) {
        ez5.respondError("custom.data.type.gazeteer.update.error.state-missing");
        return;
      }
      if (!data.batch_info) {
        ez5.respondError("custom.data.type.gazeteer.update.error.batch_info-missing");
        return;
      }
      this.__updateData(data);
    } else {
      return ez5.respondError("custom.data.type.gazeteer.update.error.invalid-action", {
        action: data.action
      });
    }
  };

  return GazetteerUpdate;

})();

module.exports = new GazetteerUpdate();
