// Generated by CoffeeScript 1.12.7
ez5.GazetteerUtil = (function() {
  function GazetteerUtil() {}

  GazetteerUtil.SEARCH_API_URL = "https://gazetteer.dainst.org/search.json?limit=20&";

  GazetteerUtil.SEARCH_QUERY_API_URL = "https://gazetteer.dainst.org/search.json?q=";

  GazetteerUtil.ID_API_URL = "https://gazetteer.dainst.org/doc/";

  GazetteerUtil.PLACE_URL = "https://gazetteer.dainst.org/place/";

  GazetteerUtil.JSON_EXTENSION = ".json";

  GazetteerUtil.searchById = function(id) {
    var xhr;
    xhr = new CUI.XHR({
      method: "GET",
      url: ez5.GazetteerUtil.ID_API_URL + id + ez5.GazetteerUtil.JSON_EXTENSION
    });
    return xhr.start();
  };

  GazetteerUtil.searchByQuery = function(query, _options) {
    var options, xhr;
    if (_options == null) {
      _options = {};
    }
    options = {
      method: "GET",
      url: ez5.GazetteerUtil.SEARCH_QUERY_API_URL + query
    };
    CUI.util.mergeMap(options, _options);
    xhr = new CUI.XHR(options);
    return xhr.start();
  };

  GazetteerUtil.setObjectData = function(object, data) {
    var position, ref, ref1, ref2, ref3;
    if (CUI.util.isEmpty(data)) {
      return object;
    }
    delete object.notFound;
    object.displayName = (ref = data.prefName) != null ? ref.title : void 0;
    object.gazId = data.gazId;
    object.otherNames = data.names;
    object.types = data.types || [];
    if ((ref1 = data.prefLocation) != null ? ref1.coordinates : void 0) {
      position = {
        lng: (ref2 = data.prefLocation) != null ? ref2.coordinates[0] : void 0,
        lat: (ref3 = data.prefLocation) != null ? ref3.coordinates[1] : void 0
      };
      if (CUI.Map.isValidPosition(position)) {
        object.position = position;
        object.iconName = data.prefLocation ? "fa-map" : "fa-map-marker";
      }
    }
    return object;
  };

  GazetteerUtil.getSaveDataObject = function(data) {
    var fulltext, object, ref;
    fulltext = data.displayName;
    if (((ref = data.otherNames) != null ? ref.length : void 0) > 0) {
      fulltext = data.otherNames.map(function(otherName) {
        return otherName.title;
      }).concat(fulltext).join(' ');
    }
    object = {
      displayName: data.displayName,
      gazId: data.gazId,
      position: data.position,
      iconName: data.iconName,
      otherNames: data.otherNames,
      types: data.types,
      _fulltext: {
        text: fulltext,
        string: data.gazId
      },
      _standard: {
        text: data.displayName
      }
    };
    return object;
  };

  return GazetteerUtil;

})();
