// Generated by CoffeeScript 1.12.7
var CustomDataTypeGetty,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeGetty = (function(superClass) {
  var isUriEncoded;

  extend(CustomDataTypeGetty, superClass);

  function CustomDataTypeGetty() {
    return CustomDataTypeGetty.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeGetty.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-getty.getty";
  };

  CustomDataTypeGetty.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.getty.name");
  };

  CustomDataTypeGetty.prototype.getFrontendLanguage = function() {
    var desiredLanguage, ref;
    desiredLanguage = typeof ez5 !== "undefined" && ez5 !== null ? (ref = ez5.loca) != null ? ref.getLanguage() : void 0 : void 0;
    if (desiredLanguage) {
      desiredLanguage = desiredLanguage.split('-');
      desiredLanguage = desiredLanguage[0];
    } else {
      desiredLanguage = false;
    }
    return desiredLanguage;
  };

  isUriEncoded = function(uri) {
    var decodedUri, reEncodedUri;
    decodedUri = decodeURIComponent(uri);
    reEncodedUri = encodeURIComponent(decodedUri);
    return reEncodedUri === uri.replace(/%20/g, '+');
  };

  CustomDataTypeGetty.prototype.__getAdditionalTooltipInfo = function(uri, tooltip, extendedInfo_xhr) {
    var gettyID, gettyType, that, uriParts, xurl;
    that = this;
    if (extendedInfo_xhr.xhr !== void 0) {
      extendedInfo_xhr.abort();
    }
    if (isUriEncoded(uri)) {
      uri = decodeURIComponent(uri);
    }
    uriParts = uri.split('/');
    gettyID = uriParts.pop();
    gettyType = uriParts.pop();
    uri = 'http://vocab.getty.edu/' + gettyType + '/' + gettyID + '.json';
    xurl = location.protocol + '//jsontojsonp.gbv.de/?url=' + uri;
    extendedInfo_xhr = new CUI.XHR({
      url: xurl
    });
    extendedInfo_xhr.start().done(function(data, status, statusText) {
      var altInfo, broaderString, htmlContent, i, info, j, labels, language, len, len1, notes, ref, ref1, ref2, ref3;
      if (data) {
        htmlContent = '<span style="padding: 10px 10px 0px 10px; font-weight: bold">' + $$('custom.data.type.getty.config.parameter.mask.infopop.info.label') + '</span>';
        htmlContent += '<table style="border-spacing: 10px; border-collapse: separate;">';
        htmlContent += "<tr><td>" + $$('custom.data.type.getty.config.parameter.mask.infopop.labels.uri') + ":</td>";
        htmlContent += "<td>" + data.id + "</td></tr>";
        htmlContent += "<tr><td>" + $$('custom.data.type.getty.config.parameter.mask.infopop.labels.preflabel') + ":</td>";
        htmlContent += "<td>" + data._label + "</td></tr>";
        if (data != null ? data.broader : void 0) {
          htmlContent += "<tr><td>" + $$('custom.data.type.getty.config.parameter.mask.infopop.labels.broader') + ":</td>";
          if ((ref = data.broader[0]) != null ? ref._label['@value'] : void 0) {
            broaderString = data.broader[0]._label['@value'];
          } else if ((ref1 = data.broader[0]) != null ? ref1._label : void 0) {
            broaderString = data.broader[0]._label;
          }
          broaderString = broaderString.replace('<', '');
          broaderString = broaderString.replace('>', '');
          htmlContent += "<td>" + broaderString + "</td></tr>";
        }
        htmlContent += "<tr><td>" + $$('custom.data.type.getty.config.parameter.mask.infopop.labels.label') + ":</td>";
        labels = [];
        if (data.identified_by) {
          ref2 = data.identified_by;
          for (i = 0, len = ref2.length; i < len; i++) {
            altInfo = ref2[i];
            if (altInfo.type === 'Name') {
              labels.push('- ' + altInfo.content);
            }
          }
        }
        htmlContent += "<td>" + labels.join('<br />') + "</td></tr>";
        notes = [];
        if (data.subject_of) {
          ref3 = data.subject_of;
          for (j = 0, len1 = ref3.length; j < len1; j++) {
            info = ref3[j];
            if (info != null ? info.classified_as : void 0) {
              if (info.classified_as[0]._label === 'descriptive note') {
                language = info.language[0]._label;
                if (that.getFrontendLanguage() === language || language === 'en') {
                  notes.push(info.content);
                }
              }
            }
          }
        }
        if (notes.length > 0) {
          htmlContent += "<tr><td>" + $$('custom.data.type.getty.config.parameter.mask.infopop.labels.note') + ":</td>";
          htmlContent += "<td>" + notes.join('<br />') + "</td></tr>";
        }
        htmlContent += "</table>";
        tooltip.DOM.innerHTML = htmlContent;
        return tooltip.autoSize();
      } else {
        tooltip.hide();
        tooltip.destroy();
        return false;
      }
    }).fail(function(data, status, statusText) {
      tooltip.hide();
      tooltip.destroy();
      return false;
    });
  };

  CustomDataTypeGetty.prototype.__updateSuggestionsMenu = function(cdata, cdata_form, searchstring, input, suggest_Menu, searchsuggest_xhr, layout, opts) {
    var delayMillisseconds, that;
    that = this;
    delayMillisseconds = 200;
    return setTimeout((function() {
      var allowedStartParentIDBeginnings, getty_countSuggestions, getty_searchterm, getty_searchtype, i, len, prefix, ref, ref1, ref2, ref3, startParentID, startsWithAllowedPrefix;
      getty_searchterm = searchstring;
      getty_countSuggestions = 20;
      if (cdata_form) {
        getty_searchterm = cdata_form.getFieldsByName("searchbarInput")[0].getValue();
        getty_searchtype = cdata_form.getFieldsByName("gettySelectType")[0].getValue();
        getty_countSuggestions = cdata_form.getFieldsByName("countOfSuggestions")[0].getValue();
      }
      if (getty_searchtype === 'all_supported_types' || !getty_searchtype) {
        getty_searchtype = [];
        if ((ref = that.getCustomSchemaSettings().add_aat) != null ? ref.value : void 0) {
          getty_searchtype.push('aat');
        }
        if ((ref1 = that.getCustomSchemaSettings().add_tgn) != null ? ref1.value : void 0) {
          getty_searchtype.push('tgn');
        }
        if ((ref2 = that.getCustomSchemaSettings().add_ulan) != null ? ref2.value : void 0) {
          getty_searchtype.push('ulan');
        }
        getty_searchtype = getty_searchtype.join(',');
      }
      if (getty_searchtype === '') {
        getty_searchtype = 'aat,tgn,ulan';
      }
      if (getty_searchterm.length === 0) {
        return;
      }
      startParentID = '';
      allowedStartParentIDBeginnings = ['tgn:', 'aat:', 'ulan:'];
      if ((ref3 = that.getCustomSchemaSettings().start_parent_id) != null ? ref3.value : void 0) {
        startsWithAllowedPrefix = false;
        for (i = 0, len = allowedStartParentIDBeginnings.length; i < len; i++) {
          prefix = allowedStartParentIDBeginnings[i];
          if (!(that.getCustomSchemaSettings().start_parent_id.value.startsWith(prefix))) {
            continue;
          }
          startsWithAllowedPrefix = true;
          break;
        }
        if (startsWithAllowedPrefix) {
          startParentID = '&startParentID=' + that.getCustomSchemaSettings().start_parent_id.value;
        }
      }
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      searchsuggest_xhr.xhr = new CUI.XHR({
        url: location.protocol + '//ws.gbv.de/suggest/getty/?searchstring=' + getty_searchterm + '&voc=' + getty_searchtype + '&count=' + getty_countSuggestions + startParentID
      });
      return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
        var extendedInfo_xhr, fn, itemList, j, key, len1, menu_items, ref4, suggestion;
        extendedInfo_xhr = {
          "xhr": void 0
        };
        menu_items = [];
        ref4 = data[1];
        fn = function(key) {
          var aktType, item, lastType;
          aktType = data[2][key];
          lastType = '';
          if (key > 0) {
            lastType = data[2][key - 1];
          }
          if (aktType !== lastType) {
            item = {
              divider: true
            };
            menu_items.push(item);
            item = {
              label: aktType
            };
            menu_items.push(item);
            item = {
              divider: true
            };
            menu_items.push(item);
          }
          item = {
            text: suggestion,
            value: data[3][key],
            tooltip: {
              markdown: true,
              placement: "e",
              content: function(tooltip) {
                that.__getAdditionalTooltipInfo(data[3][key], tooltip, extendedInfo_xhr);
                return new CUI.Label({
                  icon: "spinner",
                  text: "lade Informationen"
                });
              }
            }
          };
          return menu_items.push(item);
        };
        for (key = j = 0, len1 = ref4.length; j < len1; key = ++j) {
          suggestion = ref4[key];
          fn(key);
        }
        itemList = {
          onClick: function(ev2, btn) {
            var dataEntry_xhr, encodedURL;
            cdata.conceptURI = btn.getOpt("value");
            cdata.conceptName = btn.getText();
            encodedURL = encodeURIComponent(cdata.conceptURI + '.json');
            dataEntry_xhr = new CUI.XHR({
              url: location.protocol + '//jsontojsonp.gbv.de/?url=' + encodedURL
            });
            return dataEntry_xhr.start().done(function(data, status, statusText) {
              cdata._fulltext = ez5.GettyUtil.getFullTextFromGettyJSON(data, false);
              cdata._standard = ez5.GettyUtil.getStandardFromGettyJSON(that, data, cdata, false);
              that.__updateResult(cdata, layout, opts);
              suggest_Menu.hide();
              if (that.popover) {
                return that.popover.hide();
              }
            }).fail(function(data, status, statusText) {
              that.__updateResult(cdata, layout, opts);
              suggest_Menu.hide();
              if (that.popover) {
                return that.popover.hide();
              }
            });
          },
          items: menu_items
        };
        if (itemList.items.length === 0) {
          itemList = {
            items: [
              {
                text: "kein Treffer",
                value: void 0
              }
            ]
          };
        }
        suggest_Menu.setItemList(itemList);
        return suggest_Menu.show();
      });
    }), delayMillisseconds);
  };

  CustomDataTypeGetty.prototype.__getEditorFields = function(cdata) {
    var dropDownSearchOptions, option, ref, ref1, ref2;
    dropDownSearchOptions = [];
    if ((ref = this.getCustomSchemaSettings().add_aat) != null ? ref.value : void 0) {
      option = {
        value: 'aat',
        text: 'Art & Architecture Thesaurus'
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref1 = this.getCustomSchemaSettings().add_tgn) != null ? ref1.value : void 0) {
      option = {
        value: 'tgn',
        text: 'Getty Thesaurus of Geographic Names'
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref2 = this.getCustomSchemaSettings().add_ulan) != null ? ref2.value : void 0) {
      option = {
        value: 'ulan',
        text: 'Union List of Artist Names'
      };
      dropDownSearchOptions.push(option);
    }
    if (dropDownSearchOptions.length === 0) {
      dropDownSearchOptions = [
        {
          value: 'aat',
          text: 'Art & Architecture Thesaurus'
        }, {
          value: 'tgn',
          text: 'Getty Thesaurus of Geographic Names'
        }, {
          value: 'ulan',
          text: 'Union List of Artist Names'
        }
      ];
    }
    return [
      {
        type: CUI.Select,
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.getty.modal.form.text.type')
        },
        options: dropDownSearchOptions,
        name: 'gettySelectType',
        "class": 'commonPlugin_Select'
      }, {
        type: CUI.Select,
        undo_and_changed_support: false,
        "class": 'commonPlugin_Select',
        form: {
          label: $$('custom.data.type.getty.modal.form.text.count')
        },
        options: [
          {
            value: 10,
            text: '10 Vorschläge'
          }, {
            value: 20,
            text: '20 Vorschläge'
          }, {
            value: 50,
            text: '50 Vorschläge'
          }, {
            value: 100,
            text: '100 Vorschläge'
          }
        ],
        name: 'countOfSuggestions'
      }, {
        type: CUI.Input,
        undo_and_changed_support: false,
        form: {
          label: $$("custom.data.type.getty.modal.form.text.searchbar")
        },
        placeholder: $$("custom.data.type.getty.modal.form.text.searchbar.placeholder"),
        name: "searchbarInput",
        "class": 'commonPlugin_Input'
      }
    ];
  };

  CustomDataTypeGetty.prototype.__renderButtonByData = function(cdata) {
    var conceptURI, displayUri, extendedInfo_xhr, that, tt_text;
    that = this;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.getty.edit.no_getty")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.getty.edit.no_valid_getty")
        }).DOM;
    }
    conceptURI = CUI.parseLocation(cdata.conceptURI).url;
    tt_text = $$("custom.data.type.getty.url.tooltip", {
      name: cdata.conceptName
    });
    displayUri = cdata.conceptURI.replace('http://vocab.getty.edu', 'http://vocab.getty.edu/page');
    extendedInfo_xhr = {
      "xhr": void 0
    };
    return new CUI.HorizontalLayout({
      maximize: false,
      left: {
        content: new CUI.Label({
          centered: false,
          multiline: true,
          text: cdata.conceptName
        })
      },
      center: {
        content: new CUI.ButtonHref({
          appearance: "link",
          href: cdata.conceptURI,
          target: "_blank",
          tooltip: {
            markdown: true,
            placement: 'n',
            content: function(tooltip) {
              that.__getAdditionalTooltipInfo(cdata.conceptURI, tooltip, extendedInfo_xhr);
              return new CUI.Label({
                icon: "spinner",
                text: "lade Informationen"
              });
            }
          },
          text: ' '
        })
      },
      right: null
    }).DOM;
  };

  CustomDataTypeGetty.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var ref, ref1, ref2, ref3, tags;
    tags = [];
    if ((ref = custom_settings.add_aat) != null ? ref.value : void 0) {
      tags.push("✓ AAT");
    } else {
      tags.push("✘ AAT");
    }
    if ((ref1 = custom_settings.add_tgn) != null ? ref1.value : void 0) {
      tags.push("✓ TGN");
    } else {
      tags.push("✘ TGN");
    }
    if ((ref2 = custom_settings.add_ulan) != null ? ref2.value : void 0) {
      tags.push("✓ ULAN");
    } else {
      tags.push("✘ ULAN");
    }
    if ((ref3 = custom_settings.start_parent_id) != null ? ref3.value : void 0) {
      tags.push("✓ startParentID");
    } else {
      tags.push("✘ startParentID");
    }
    return tags;
  };

  return CustomDataTypeGetty;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeGetty);
