// Generated by CoffeeScript 1.12.7
var Iconclass_ListViewTree, Iconclass_ListViewTreeNode,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Iconclass_ListViewTree = (function() {
  function Iconclass_ListViewTree(popover, editor_layout, cdata1, cdata_form, context, iconclass_opts) {
    var column, options, row, that, treeview;
    this.popover = popover != null ? popover : null;
    this.editor_layout = editor_layout != null ? editor_layout : null;
    this.cdata = cdata1 != null ? cdata1 : null;
    this.cdata_form = cdata_form != null ? cdata_form : null;
    this.context = context != null ? context : null;
    this.iconclass_opts = iconclass_opts != null ? iconclass_opts : {};
    options = {
      "class": "customPlugin_Treeview",
      cols: ["maximize", "auto"],
      fixedRows: 0,
      fixedCols: 0,
      no_hierarchy: false
    };
    that = this;
    treeview = new CUI.ListViewTree(options);
    treeview.render();
    treeview.root.open();
    row = new CUI.ListViewRow();
    column = new CUI.ListViewColumn({
      colspan: 2,
      element: new CUI.Label({
        icon: "spinner",
        appearance: "title",
        text: $$("custom.data.type.iconclass.modal.form.popup.loadingstringtreeview")
      })
    });
    row.addColumn(column);
    treeview.appendRow(row);
    treeview.root.open();
    this.treeview = treeview;
    this.treeview;
  }

  Iconclass_ListViewTree.prototype.getTopTreeView = function(activeFrontendLanguage) {
    var dfr, that, topTree_xhr, url;
    dfr = new CUI.Deferred();
    that = this;
    topTree_xhr = {
      "xhr": void 0
    };
    url = 'https://jsontojsonp.gbv.de/?url=' + encodeURIComponent('https://iconclass.org/json/?notation=1&notation=2&notation=3&notation=4&notation=5&notation=6&notation=7&notation=8&notation=9');
    topTree_xhr.xhr = new CUI.XHR({
      url: url
    });
    topTree_xhr.xhr.start().done(function(data, status, statusText) {
      var hasNarrowers, i, iconclassEntry, key, len, newNode, prefLabel, ref, ref1;
      if (that.treeview.getRow(0)) {
        that.treeview.removeRow(0);
      }
      if (data != null ? data.result : void 0) {
        data = data.result;
      }
      for (key = i = 0, len = data.length; i < len; key = ++i) {
        iconclassEntry = data[key];
        if (iconclassEntry != null ? iconclassEntry.txt[activeFrontendLanguage] : void 0) {
          prefLabel = iconclassEntry != null ? iconclassEntry.txt[activeFrontendLanguage] : void 0;
        } else {
          prefLabel = iconclassEntry != null ? (ref = iconclassEntry.txt) != null ? ref.de : void 0 : void 0;
        }
        prefLabel = iconclassEntry.n + ' - ' + prefLabel;
        if (((ref1 = iconclassEntry.c) != null ? ref1.length : void 0) > 0) {
          hasNarrowers = true;
        } else {
          hasNarrowers = false;
        }
        newNode = new Iconclass_ListViewTreeNode({
          selectable: false
        }, {
          prefLabel: prefLabel,
          uri: 'https://iconclass.org/' + iconclassEntry.n,
          iconclassInfo: iconclassEntry,
          hasNarrowers: hasNarrowers,
          popover: that.popover,
          cdata: that.cdata,
          cdata_form: that.cdata_form,
          context: that.context,
          iconclass_opts: that.iconclass_opts,
          editor_layout: that.editor_layout,
          activeFrontendLanguage: activeFrontendLanguage
        });
        that.treeview.addNode(newNode);
      }
      CUI.Events.trigger({
        node: that.popover,
        type: "content-resize"
      });
      dfr.resolve();
      return dfr.promise();
    });
    return dfr;
  };

  return Iconclass_ListViewTree;

})();

Iconclass_ListViewTreeNode = (function(superClass) {
  var prefLabel, uri;

  extend(Iconclass_ListViewTreeNode, superClass);

  prefLabel = '';

  uri = '';

  function Iconclass_ListViewTreeNode(opts, additionalOpts) {
    this.opts = opts != null ? opts : {};
    this.additionalOpts = additionalOpts != null ? additionalOpts : {};
    this.renderContent = bind(this.renderContent, this);
    this.isLeaf = bind(this.isLeaf, this);
    this.getChildren = bind(this.getChildren, this);
    Iconclass_ListViewTreeNode.__super__.constructor.call(this);
    this.prefLabel = this.additionalOpts.prefLabel;
    this.uri = this.additionalOpts.uri;
    this.iconclassInfo = this.additionalOpts.iconclassEntry;
    this.popover = this.additionalOpts.popover;
    this.cdata = this.additionalOpts.cdata;
    this.cdata_form = this.additionalOpts.cdata_form;
    this.context = this.additionalOpts.context;
    this.iconclass_opts = this.additionalOpts.iconclass_opts;
    this.editor_layout = this.additionalOpts.editor_layout;
    this.activeFrontendLanguage = this.additionalOpts.activeFrontendLanguage;
  }

  Iconclass_ListViewTreeNode.prototype.getChildren = function() {
    var children, dfr, getChildren_xhr, i, len, notation, notationKey, notations, notationsString, that, url;
    that = this;
    dfr = new CUI.Deferred();
    children = [];
    notations = this.additionalOpts.iconclassInfo.c;
    notationsString = '';
    for (notationKey = i = 0, len = notations.length; i < len; notationKey = ++i) {
      notation = notations[notationKey];
      notationsString = notationsString + '&notation=' + encodeURIComponent(notation);
    }
    url = 'https://jsontojsonp.gbv.de/?url=' + encodeURIComponent('https://iconclass.org/json/?' + notationsString);
    getChildren_xhr = {
      "xhr": void 0
    };
    getChildren_xhr.xhr = new CUI.XHR({
      url: url
    });
    getChildren_xhr.xhr.start().done(function(data, status, statusText) {
      var hasNarrowers, iconclassEntry, j, key, len1, newNode, ref, ref1;
      if (data != null ? data.result : void 0) {
        data = data.result;
      }
      for (key = j = 0, len1 = data.length; j < len1; key = ++j) {
        iconclassEntry = data[key];
        if (iconclassEntry != null ? iconclassEntry.txt[this.activeFrontendLanguage] : void 0) {
          prefLabel = iconclassEntry != null ? iconclassEntry.txt[this.activeFrontendLanguage] : void 0;
        } else {
          prefLabel = iconclassEntry != null ? (ref = iconclassEntry.txt) != null ? ref.de : void 0 : void 0;
        }
        prefLabel = iconclassEntry.n + ' - ' + prefLabel;
        if (((ref1 = iconclassEntry.c) != null ? ref1.length : void 0) > 0) {
          hasNarrowers = true;
        } else {
          hasNarrowers = false;
        }
        newNode = new Iconclass_ListViewTreeNode({
          selectable: false
        }, {
          prefLabel: prefLabel,
          uri: 'https://iconclass.org/' + iconclassEntry.n,
          hasNarrowers: hasNarrowers,
          popover: that.popover,
          cdata: that.cdata,
          cdata_form: that.cdata_form,
          context: that.context,
          iconclass_opts: that.iconclass_opts,
          editor_layout: that.editor_layout,
          iconclassInfo: iconclassEntry
        });
        children.push(newNode);
      }
      return dfr.resolve(children);
    });
    return dfr.promise();
  };

  Iconclass_ListViewTreeNode.prototype.isLeaf = function() {
    if (this.additionalOpts.hasNarrowers === true) {
      return false;
    } else {
      return true;
    }
  };

  Iconclass_ListViewTreeNode.prototype.renderContent = function() {
    var activeFrontendLanguage, buttonBar, buttons, d, extendedInfo_xhr, icon, infoButton, plusButton, that, tooltipText;
    that = this;
    extendedInfo_xhr = {
      "xhr": void 0
    };
    d = CUI.dom.div();
    buttons = [];
    icon = 'fa-plus-circle';
    tooltipText = $$('custom.data.type.iconclass.modal.form.popup.add_choose');
    activeFrontendLanguage = CustomDataTypeIconclass.prototype.getFrontendLanguage();
    plusButton = new CUI.Button({
      text: "",
      icon_left: new CUI.Icon({
        "class": icon
      }),
      active: false,
      group: "default",
      tooltip: {
        text: tooltipText
      },
      onClick: (function(_this) {
        return function() {
          var ancestor, chosenTempUri, i, iconclassInfo, len, ref, ref1;
          iconclassInfo = that.additionalOpts.iconclassInfo;
          if (iconclassInfo.n.includes('(...)')) {
            chosenTempUri = 'https://iconclass.org/' + iconclassInfo.n;
            return CUI.prompt({
              text: $$('custom.data.type.iconclass.modal.form.popup.brackets.select') + " " + chosenTempUri + "\n\n" + $$('custom.data.type.iconclass.modal.form.popup.brackets.choose')
            }, "1").done(function(input) {
              var ancestor, i, iconclassLabelKey, iconclassLabelValue, inputLowerCase, inputUpperCase, len, newLabel, ref, ref1, ref2;
              inputUpperCase = input.toUpperCase();
              inputLowerCase = input.toLowerCase();
              that.cdata.conceptName = that.cdata.conceptName.replace('(...)', "(" + inputUpperCase + ")");
              iconclassInfo.n = iconclassInfo.n.replace('(...)', "(" + inputUpperCase + ")");
              ref = iconclassInfo.txt;
              for (iconclassLabelKey in ref) {
                iconclassLabelValue = ref[iconclassLabelKey];
                newLabel = iconclassLabelValue;
                newLabel = newLabel.replace(" (mit NAMEN)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (with NAME)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (avec NOM)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (col NOME)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (NIMEN kanssa)", ': ' + inputLowerCase);
                iconclassInfo.txt[iconclassLabelKey] = newLabel;
              }
              that.cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo.n;
              that.cdata.frontendLanguage = activeFrontendLanguage;
              that.cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, that.cdata);
              that.cdata.conceptAncestors = [];
              if ((iconclassInfo != null ? (ref1 = iconclassInfo.p) != null ? ref1.length : void 0 : void 0) > 0) {
                ref2 = iconclassInfo.p;
                for (i = 0, len = ref2.length; i < len; i++) {
                  ancestor = ref2[i];
                  that.cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
                }
              }
              that.cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
              that.cdata.conceptAncestors = that.cdata.conceptAncestors.join(' ');
              that.cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
              that.cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that.context, iconclassInfo, that.cdata, false);
              CustomDataTypeIconclass.prototype.__updateResult(that.cdata, that.editor_layout, that.iconclass_opts);
              that.popover.hide();
              return _this;
            }).fail(function() {
              var cdata;
              cdata = {};
              CustomDataTypeIconclass.prototype.__updateResult(that.cdata, that.editor_layout, that.iconclass_opts);
              that.popover.hide();
              return _this;
            });
          } else {
            that.cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo.n;
            that.cdata.frontendLanguage = activeFrontendLanguage;
            that.cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, that.cdata);
            that.cdata.conceptAncestors = [];
            if ((iconclassInfo != null ? (ref = iconclassInfo.p) != null ? ref.length : void 0 : void 0) > 0) {
              ref1 = iconclassInfo.p;
              for (i = 0, len = ref1.length; i < len; i++) {
                ancestor = ref1[i];
                that.cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
              }
            }
            that.cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
            that.cdata.conceptAncestors = that.cdata.conceptAncestors.join(' ');
            that.cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
            that.cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that.context, iconclassInfo, that.cdata, false);
            CustomDataTypeIconclass.prototype.__updateResult(that.cdata, that.editor_layout, that.iconclass_opts);
            that.popover.hide();
            return _this;
          }
        };
      })(this)
    });
    plusButton.setEnabled(true);
    buttons.push(plusButton);
    infoButton = new CUI.Button({
      text: "",
      icon_left: new CUI.Icon({
        "class": "fa-info-circle"
      }),
      active: false,
      group: "default",
      tooltip: {
        markdown: true,
        placement: "e",
        content: function(tooltip) {
          CustomDataTypeIconclass.prototype.__getAdditionalTooltipInfo(that.uri, tooltip, extendedInfo_xhr, that.context);
          return new CUI.Label({
            icon: "spinner",
            text: $$('custom.data.type.iconclass.modal.form.popup.loadingstring')
          });
        }
      }
    });
    buttons.push(infoButton);
    buttonBar = new CUI.Buttonbar({
      buttons: buttons
    });
    CUI.dom.append(d, CUI.dom.append(CUI.dom.div(), buttonBar.DOM));
    this.addColumn(new CUI.ListViewColumn({
      element: d,
      colspan: 1
    }));
    CUI.Events.trigger({
      node: that.popover,
      type: "content-resize"
    });
    return new CUI.Label({
      text: this.prefLabel
    });
  };

  return Iconclass_ListViewTreeNode;

})(CUI.ListViewTreeNode);
