// Generated by CoffeeScript 1.12.7
var CustomDataTypeIUCN,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeIUCN = (function(superClass) {
  extend(CustomDataTypeIUCN, superClass);

  function CustomDataTypeIUCN() {
    this.getQueryFieldBadge = bind(this.getQueryFieldBadge, this);
    return CustomDataTypeIUCN.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeIUCN.prototype.getCustomDataTypeName = function() {
    return ez5.IUCNUtil.getFieldType();
  };

  CustomDataTypeIUCN.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.iucn.name");
  };

  CustomDataTypeIUCN.prototype.getCustomDataOptionsInDatamodelInfo = function() {
    return [];
  };

  CustomDataTypeIUCN.prototype.renderSearchInput = function(data, opts) {
    if (opts == null) {
      opts = {};
    }
    return new SearchToken({
      column: this,
      data: data,
      fields: opts.fields
    }).getInput().DOM;
  };

  CustomDataTypeIUCN.prototype.getFieldNamesForSearch = function() {
    return this.__getFieldNames();
  };

  CustomDataTypeIUCN.prototype.getFieldNamesForSuggest = function() {
    return this.__getFieldNames();
  };

  CustomDataTypeIUCN.prototype.getSearchFilter = function(data, key) {
    var filter, phrase, ref, str, val;
    if (key == null) {
      key = this.name();
    }
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".scientificName"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    }
    filter = CustomDataTypeIUCN.__super__.getSearchFilter.call(this, data, key);
    if (filter) {
      return filter;
    }
    if (CUI.util.isEmpty(data[key])) {
      return;
    }
    val = data[key];
    ref = Search.getPhrase(val), str = ref[0], phrase = ref[1];
    switch (data[key + ":type"]) {
      case "token":
      case "fulltext":
      case void 0:
        filter = {
          type: "match",
          mode: data[key + ":mode"],
          fields: this.getFieldNamesForSearch(),
          string: str,
          phrase: phrase
        };
        break;
      case "field":
        filter = {
          type: "in",
          fields: this.getFieldNamesForSearch(),
          "in": [str]
        };
    }
    return filter;
  };

  CustomDataTypeIUCN.prototype.__getFieldNames = function() {
    var fieldNames;
    fieldNames = [this.fullName() + ".idTaxon", this.fullName() + ".scientificName", this.fullName() + ".mainCommonName"];
    return fieldNames;
  };

  CustomDataTypeIUCN.prototype.getQueryFieldBadge = function(data) {
    var value;
    if (data[(this.name()) + ":unset"]) {
      value = $$("text.column.badge.without");
    } else {
      value = data[this.name()];
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeIUCN.prototype.renderEditorInput = function(data) {
    var div, searchField, toggleOutput;
    data = this.__initData(data);
    div = CUI.dom.div();
    toggleOutput = (function(_this) {
      return function() {
        var output;
        CUI.Events.trigger({
          node: div,
          type: "editor-changed"
        });
        if (data.idTaxon || data.scientificName) {
          output = _this.__getOutput(data, true, function() {
            ez5.IUCNUtil.setObjectData(data);
            return toggleOutput();
          });
          return CUI.dom.replace(div, output);
        } else {
          return CUI.dom.replace(div, searchField);
        }
      };
    })(this);
    searchField = this.__getSearchField(data, toggleOutput);
    toggleOutput();
    return div;
  };

  CustomDataTypeIUCN.prototype.__getSearchField = function(data, onSearch) {
    var doSearch, layout, searchButton, searchInput, toggleButton;
    doSearch = (function(_this) {
      return function() {
        var genus, parts, species;
        searchButton.startSpinner();
        if (isNaN(data.searchName)) {
          parts = data.searchName.split(/\s+/).filter(function(part) {
            return part.trim() !== "";
          });
          genus = "";
          species = "";
          if (parts.length > 0) {
            genus = parts[0];
          }
          if (parts.length > 1) {
            species = parts[1];
          }
          return ez5.IUCNUtil.searchByTaxonname(ez5.IUCNUtil.getPluginEndpoint(), genus, species).done(function(response) {
            var _assessment_id;
            if (!response) {
              CUI.alert({
                text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                markdown: true
              });
              return;
            }
            _assessment_id = ez5.IUCNUtil.getLatestAssessmentIdFromSearchResult(response);
            if (_assessment_id === 0 || CUI.util.isEmpty(response)) {
              ez5.IUCNUtil.setObjectData(data, {
                scientific_name: data.searchName
              });
              return onSearch();
            } else {
              return ez5.IUCNUtil.getAssessmentData(ez5.IUCNUtil.getPluginEndpoint(), _assessment_id).done(function(response) {
                if (!response) {
                  CUI.alert({
                    text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                    markdown: true
                  });
                  return;
                }
                ez5.IUCNUtil.setObjectData(data, response);
                return onSearch();
              }).fail(function(e) {
                ez5.IUCNUtil.setObjectData(data, {
                  scientific_name: data.searchName
                });
              });
            }
          }).always(function() {
            return searchButton.stopSpinner();
          });
        } else {
          return ez5.IUCNUtil.searchBySisTaxonId(ez5.IUCNUtil.getPluginEndpoint(), data.searchName).done(function(response) {
            var _assessment_id;
            if (!response) {
              CUI.alert({
                text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                markdown: true
              });
              return;
            }
            _assessment_id = ez5.IUCNUtil.getLatestAssessmentIdFromSearchResult(response);
            if (_assessment_id === 0 || CUI.util.isEmpty(response)) {
              ez5.IUCNUtil.setObjectData(data, {
                scientific_name: data.searchName
              });
              return onSearch();
            } else {
              return ez5.IUCNUtil.getAssessmentData(ez5.IUCNUtil.getPluginEndpoint(), _assessment_id).done(function(response) {
                if (!response) {
                  CUI.alert({
                    text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                    markdown: true
                  });
                  return;
                }
                ez5.IUCNUtil.setObjectData(data, response);
                return onSearch();
              }).fail(function(e) {
                ez5.IUCNUtil.setObjectData(data, {
                  scientific_name: data.searchName
                });
              });
            }
          }).always(function() {
            return searchButton.stopSpinner();
          });
        }
      };
    })(this);
    searchButton = new CUI.Button({
      icon: "search",
      "class": "ez5-custom-data-type-iucn-search-button",
      tooltip: {
        text: $$("custom.data.type.iucn.editor.search-button.tooltip")
      },
      onClick: doSearch
    });
    toggleButton = function() {
      if (CUI.util.isEmpty(data.searchName)) {
        searchButton.disable();
      } else {
        searchButton.enable();
      }
    };
    searchInput = new CUI.Input({
      data: data,
      "class": "ez5-custom-data-type-iucn-search-input",
      name: "searchName",
      placeholder: $$("custom.data.type.iucn.editor.search-input.placeholder"),
      onDataInit: toggleButton,
      onDataChanged: toggleButton
    });
    searchInput.start();
    CUI.Events.listen({
      node: searchInput,
      type: "keyup",
      call: (function(_this) {
        return function(ev) {
          if (ev.keyCode() !== 13) {
            return;
          }
          doSearch();
        };
      })(this)
    });
    layout = new CUI.HorizontalLayout({
      center: {
        content: searchInput
      },
      right: {
        content: searchButton
      }
    });
    return layout;
  };

  CustomDataTypeIUCN.prototype.__getOutput = function(data, isEditor, onDelete) {
    var content, idRedListTag, layout, menuButton, ref, rightContent, statusText, tag;
    if (isEditor == null) {
      isEditor = false;
    }
    if (data.redList) {
      statusText = $$("custom.data.type.iucn.output.status.red-list.text");
    } else {
      statusText = $$("custom.data.type.iucn.output.status.not-on-red-list.text");
    }
    if (isEditor) {
      menuButton = new LocaButton({
        loca_key: "custom.data.type.iucn.editor.menu.button",
        icon: "ellipsis_v",
        icon_right: false,
        appearance: "flat",
        menu: {
          items: [
            new LocaButton({
              loca_key: "custom.data.type.iucn.editor.menu.delete-button",
              onClick: (function(_this) {
                return function() {
                  return typeof onDelete === "function" ? onDelete() : void 0;
                };
              })(this)
            })
          ]
        }
      });
    }
    rightContent = new CUI.HorizontalLayout({
      right: {
        content: ""
      }
    });
    if (data.redList) {
      idRedListTag = (ref = ez5.IUCNUtil.getSettings()) != null ? ref.tag_red : void 0;
      tag = ez5.tagForm.findTagByAnyId(idRedListTag);
      if (tag) {
        rightContent.append(tag.getLabel(), "center");
      }
    }
    if (isEditor) {
      rightContent.append(menuButton, "right");
    }
    if (data.idTaxon) {
      content = new CUI.VerticalList({
        content: [
          new CUI.ButtonHref({
            text: data.mainCommonName,
            "class": "pluginResultButton",
            appearance: "link",
            href: "https://apistaging.iucnredlist.org/species/" + data.idTaxon,
            target: "_blank"
          }), new CUI.Label({
            text: data.idTaxon + " - " + data.scientificName,
            appearance: "secondary"
          }), new CUI.Label({
            text: statusText,
            appearance: "secondary"
          })
        ]
      });
    } else {
      content = new CUI.Label({
        text: data.scientificName
      });
    }
    layout = new CUI.HorizontalLayout({
      "class": "ez5-field-object ez5-custom-data-type-iucn-card",
      left: {
        content: this.__getLogoImage()
      },
      center: {
        content: content
      },
      right: {
        content: rightContent
      }
    });
    return layout;
  };

  CustomDataTypeIUCN.prototype.renderDetailOutput = function(data, _, opts) {
    data = this.__initData(data);
    return this.__getOutput(data);
  };

  CustomDataTypeIUCN.prototype.getSaveData = function(data, save_data) {
    data = data[this.name()];
    if (CUI.util.isEmpty(data)) {
      return save_data[this.name()] = null;
    }
    return save_data[this.name()] = ez5.IUCNUtil.getSaveData(data);
  };

  CustomDataTypeIUCN.prototype.isEmpty = function(data, _, opts) {
    if (opts == null) {
      opts = {};
    }
    data = data[this.name()];
    if (opts.mode === "expert") {
      return CUI.util.isEmpty(data != null ? data.trim() : void 0);
    }
    return CUI.util.isEmpty(data != null ? data.idTaxon : void 0) && CUI.util.isEmpty(data != null ? data.scientificName : void 0);
  };

  CustomDataTypeIUCN.prototype.__initData = function(data) {
    var initData;
    if (!data[this.name()]) {
      initData = {};
      data[this.name()] = initData;
    } else {
      initData = data[this.name()];
    }
    return initData;
  };

  CustomDataTypeIUCN.prototype.__getLogoImage = function() {
    var plugin;
    if (this.__previewImage) {
      return this.__previewImage;
    }
    plugin = ez5.pluginManager.getPlugin("custom-data-type-iucn");
    this.__previewImage = new Image();
    this.__previewImage.src = plugin.getBaseURL() + plugin.getWebfrontend().logo;
    return this.__previewImage;
  };

  CustomDataTypeIUCN.prototype.renderFieldAsGroup = function() {
    return false;
  };

  CustomDataTypeIUCN.prototype.supportsStandard = function() {
    return true;
  };

  return CustomDataTypeIUCN;

})(CustomDataType);

CustomDataType.register(CustomDataTypeIUCN);
