// Generated by CoffeeScript 1.12.7

/*
 * easydb-custom-data-type-link
 * Copyright (c) 2013 - 2016 Programmfabrik GmbH
 * MIT Licence
 * https://github.com/programmfabrik/coffeescript-ui, http://www.coffeescript-ui.org
 */
var CustomDataTypeLink,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeLink = (function(superClass) {
  extend(CustomDataTypeLink, superClass);

  function CustomDataTypeLink() {
    this.getQueryFieldBadge = bind(this.getQueryFieldBadge, this);
    return CustomDataTypeLink.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeLink.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-link.link";
  };

  CustomDataTypeLink.prototype.getQueryFieldBadge = function(data) {
    var value;
    if (data[(this.name()) + ":unset"]) {
      value = $$("text.column.badge.without");
    } else if (data[(this.name()) + ":has_value"]) {
      value = $$("field.search.badge.has_value");
    } else {
      value = data[this.name()];
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeLink.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.link.name");
  };

  CustomDataTypeLink.prototype.isEmpty = function(data, top_level_data, opts) {
    var ref, ref1;
    if (opts == null) {
      opts = {};
    }
    if (opts.mode === "expert") {
      return CUI.util.isEmpty((ref = data[this.name()]) != null ? ref.trim() : void 0);
    }
    if ((ref1 = data[this.name()]) != null ? ref1.url : void 0) {
      return false;
    } else {
      return true;
    }
  };

  CustomDataTypeLink.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var i, len, pre, ref, ref1, results, tag, tags;
    tags = [];
    pre = "custom.data.type.link.setting.schema.rendered_options.";
    if ((ref = custom_settings.title) != null ? ref.type : void 0) {
      tags.push(pre + "title." + custom_settings.title.type);
    }
    if ((ref1 = custom_settings.add_timestamp) != null ? ref1.value : void 0) {
      tags.push(pre + "with_date");
    } else {
      tags.push(pre + "without_date");
    }
    results = [];
    for (i = 0, len = tags.length; i < len; i++) {
      tag = tags[i];
      results.push($$(tag));
    }
    return results;
  };

  CustomDataTypeLink.prototype.initData = function(data) {
    var cdata, ref;
    if (!data[this.name()]) {
      cdata = {};
      data[this.name()] = cdata;
    } else {
      cdata = data[this.name()];
    }
    if (!cdata.url) {
      cdata.url = "";
    }
    if ((ref = data._template) != null ? ref[this.name()] : void 0) {
      cdata._template = data._template[this.name()];
    }
    return cdata;
  };

  CustomDataTypeLink.prototype.renderFieldAsGroup = function(data, top_level_data, opts) {
    if (opts.fieldRenderType === 'editor' && this.supportsInline()) {
      return true;
    } else {
      return false;
    }
  };

  CustomDataTypeLink.prototype.supportsFacet = function() {
    return true;
  };

  CustomDataTypeLink.prototype.getFacet = function(opts) {
    opts.field = this;
    return new CustomDataTypeLinkFacet(opts);
  };

  CustomDataTypeLink.prototype.getSortFunction = function() {
    return (function(_this) {
      return function(a, b) {
        var ref, ref1;
        return CUI.util.compareIndex(((ref = a[_this.name()]) != null ? ref.hostname : void 0) || 'zzz', ((ref1 = b[_this.name()]) != null ? ref1.hostname : void 0) || 'zzz');
      };
    })(this);
  };

  CustomDataTypeLink.prototype.renderSearchInput = function(data, opts) {
    if (opts == null) {
      opts = {};
    }
    return new SearchToken({
      column: this,
      data: data,
      fields: opts.fields
    }).getInput().DOM;
  };

  CustomDataTypeLink.prototype.getFieldNamesForSearch = function() {
    return this.getFieldNames();
  };

  CustomDataTypeLink.prototype.getFieldNamesForSuggest = function() {
    return this.getFieldNames();
  };

  CustomDataTypeLink.prototype.getFieldNames = function() {
    var field_names, i, lang, len, ref;
    field_names = [this.fullName() + ".tld", this.fullName() + ".url", this.fullName() + ".text_plain"];
    if (!ez5.version("6")) {
      ref = ez5.session.getPref("search_languages");
      for (i = 0, len = ref.length; i < len; i++) {
        lang = ref[i];
        field_names.push(this.fullName() + ".text." + lang);
      }
    } else {
      field_names.push(this.fullName() + ".text");
    }
    return field_names;
  };

  CustomDataTypeLink.prototype.renderEditorInput = function(data, top_level_data, opts) {
    var cdata;
    cdata = this.initData(data);
    if (this.supportsInline()) {
      return this.__renderEditorInputInline(cdata);
    } else {
      return this.__renderEditorInputPopover(cdata);
    }
  };

  CustomDataTypeLink.prototype.supportsStandard = function() {
    return true;
  };

  CustomDataTypeLink.prototype.supportsPrinting = function() {
    return true;
  };

  CustomDataTypeLink.prototype.supportsInline = function() {
    var ref;
    return ((ref = this.getCustomMaskSettings().editor_style) != null ? ref.value : void 0) !== "popover";
  };

  CustomDataTypeLink.prototype.supportsTimestamp = function() {
    var ref;
    return (ref = this.getCustomSchemaSettings().add_timestamp) != null ? ref.value : void 0;
  };

  CustomDataTypeLink.prototype.getTitleType = function() {
    var ref;
    return ((ref = this.getCustomSchemaSettings().title) != null ? ref.type : void 0) || "text-l10n";
  };

  CustomDataTypeLink.prototype.__renderEditorInputPopover = function(cdata) {
    var layout;
    layout = new CUI.HorizontalLayout({
      left: {},
      right: {
        content: {
          loca_key: "custom.data.type.link.edit.button",
          onClick: (function(_this) {
            return function(ev, btn) {
              return _this.showEditPopover(cdata, btn, layout);
            };
          })(this)
        }
      }
    });
    this.__updateDisplayLink(cdata, layout);
    return layout;
  };

  CustomDataTypeLink.prototype.__renderEditorInputInline = function(cdata) {
    var btn, fields, form, preview;
    fields = this.__getEditorFields(cdata);
    btn = this.__renderButtonByData(cdata);
    preview = {
      name: "preview",
      type: DataFieldProxy,
      form: {
        label: $$("custom.data.type.link.preview.label")
      },
      element: btn
    };
    fields.push(preview);
    form = new CUI.Form({
      data: cdata,
      maximize_horizontal: true,
      onDataChanged: (function(_this) {
        return function() {
          var previewField;
          previewField = form.getFieldsByName("preview")[0];
          previewField.replace(_this.__renderButtonByData(cdata));
          return _this.__triggerFormChanged(form);
        };
      })(this),
      fields: fields
    }).start();
    return form;
  };

  CustomDataTypeLink.prototype.__updateDisplayLink = function(cdata, layout) {
    var btn;
    btn = this.__renderButtonByData(cdata);
    return layout.replace(btn, "left");
  };

  CustomDataTypeLink.prototype.__triggerFormChanged = function(form) {
    return CUI.Events.trigger({
      node: form,
      type: "editor-changed"
    });
  };

  CustomDataTypeLink.prototype.getSearchFilter = function(data, key) {
    var filter, phrase, ref, str, val;
    if (key == null) {
      key = this.name();
    }
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".url"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    } else if (data[key + ":has_value"]) {
      return this.getHasValueFilter(data, key);
    }
    filter = CustomDataTypeLink.__super__.getSearchFilter.call(this, data, key);
    if (filter) {
      return filter;
    }
    if (CUI.util.isEmpty(data[key])) {
      return;
    }
    val = data[key];
    ref = Search.getPhrase(val), str = ref[0], phrase = ref[1];
    switch (data[key + ":type"]) {
      case "token":
      case "fulltext":
      case void 0:
        filter = {
          type: "match",
          mode: data[key + ":mode"],
          fields: this.getFieldNamesForSearch(),
          string: str,
          phrase: phrase
        };
        break;
      case "field":
        filter = {
          type: "in",
          fields: this.getFieldNamesForSearch(),
          "in": [str]
        };
    }
    return filter;
  };

  CustomDataTypeLink.prototype.getHasValueFilter = function(data, key) {
    var filter;
    if (key == null) {
      key = this.name();
    }
    if (data[key + ":has_value"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".url"],
        "in": [null],
        bool: "must_not"
      };
      filter._unnest = true;
      filter._has_value_filter = true;
      return filter;
    }
  };

  CustomDataTypeLink.prototype.showEditPopover = function(cdata, element, layout) {
    var form;
    form = new CUI.Form({
      data: cdata,
      fields: this.__getEditorFields(cdata),
      onDataChanged: (function(_this) {
        return function() {
          return _this.__triggerFormChanged(form);
        };
      })(this)
    }).start();
    return new CUI.Popover({
      element: element,
      onHide: (function(_this) {
        return function() {
          _this.__updateDisplayLink(cdata, layout);
          return CUI.Events.trigger({
            node: layout,
            type: "editor-changed"
          });
        };
      })(this),
      pane: {
        header_left: new LocaLabel({
          loca_key: "custom.data.type.link.edit.modal.title"
        }),
        content: form
      }
    }).show();
  };

  CustomDataTypeLink.prototype.__getEditorFields = function(cdata) {
    var fallback_url, fields, hideShow, placeholder, ref, ref1, ref2, status, templateSelectField;
    templateSelectField = this.__getTemplateSelectFields(cdata);
    fields = [];
    if (templateSelectField) {
      fields.push(templateSelectField[0]);
      fields.push(templateSelectField[1]);
    }
    hideShow = (function(_this) {
      return function(field) {
        var data;
        data = field.getData();
        if (CUI.util.isNull(data.templateIndex)) {
          return field.show();
        } else {
          return field.hide();
        }
      };
    })(this);
    status = this.getDataStatus(cdata);
    fallback_url = ((ref = cdata._template) != null ? ref.url : void 0) || null;
    fields.push({
      type: CUI.Input,
      undo_and_changed_support: false,
      form: {
        label: $$("custom.data.type.link.modal.form.url.label")
      },
      placeholder: fallback_url || $$("custom.data.type.link.modal.form.url.placeholder"),
      name: "url",
      hidden: !CUI.util.isNull(cdata.templateIndex),
      checkInput: (function(_this) {
        return function(url) {
          return _this.__isValidUrl(url);
        };
      })(this),
      onDataInit: hideShow
    });
    switch (this.getTitleType()) {
      case "text-l10n":
        placeholder = ((ref1 = cdata._template) != null ? ref1.text : void 0) || {};
        fields.push({
          type: CUI.MultiInput,
          name: "text",
          undo_and_changed_support: false,
          placeholder: placeholder,
          hidden: !CUI.util.isNull(cdata.templateIndex),
          form: {
            label: $$("custom.data.type.link.modal.form.text.label")
          },
          control: ez5.loca.getLanguageControl(),
          onDataInit: hideShow
        });
        break;
      case "text":
        placeholder = ((ref2 = cdata._template) != null ? ref2.text_plain : void 0) || "";
        fields.push({
          type: CUI.Input,
          name: "text_plain",
          placeholder: placeholder,
          undo_and_changed_support: false,
          hidden: !CUI.util.isNull(cdata.templateIndex),
          form: {
            label: $$("custom.data.type.link.modal.form.text.label")
          },
          onDataInit: hideShow
        });
    }
    if (this.supportsTimestamp()) {
      fields.push({
        type: CUI.DateTime,
        name: "datetime",
        undo_and_changed_support: false,
        form: {
          label: $$("custom.data.type.link.modal.form.datetime.label")
        }
      });
    }
    return fields;
  };

  CustomDataTypeLink.prototype.__replacePlaceholder = function(string, name, value) {
    return string.replace(RegExp("%" + name + "%", "g"), value);
  };

  CustomDataTypeLink.prototype.__fillDisplayName = function(data, template) {
    var displayname, language, name, newDisplayname, ref, ref1, titleType, value;
    titleType = this.getTitleType();
    if (titleType === "none") {
      return;
    }
    newDisplayname = {};
    ref = data.placeholders;
    for (name in ref) {
      value = ref[name];
      ref1 = template.displayname;
      for (language in ref1) {
        displayname = ref1[language];
        if (value) {
          newDisplayname[language] = this.__replacePlaceholder(newDisplayname[language] || displayname, name, value);
        } else {
          newDisplayname[language] = newDisplayname[language] || displayname;
        }
      }
    }
    switch (titleType) {
      case "text-l10n":
        if (!data.text) {
          data.text = {};
        }
        for (language in newDisplayname) {
          displayname = newDisplayname[language];
          data.text[language] = displayname;
        }
        break;
      case "text":
        data.text_plain = ez5.loca.getBestFrontendValue(newDisplayname);
    }
  };

  CustomDataTypeLink.prototype.__fillUrl = function(data, template) {
    var name, ref, url, value;
    url = template.url;
    ref = data.placeholders;
    for (name in ref) {
      value = ref[name];
      if (value) {
        url = this.__replacePlaceholder(url, name, value);
      }
    }
    data.url = url;
  };

  CustomDataTypeLink.prototype.__getTemplates = function() {
    var baseConfig, ref, templates;
    baseConfig = ez5.session.getBaseConfig("plugin", "custom-data-type-link");
    baseConfig = baseConfig.system || baseConfig;
    templates = (ref = baseConfig.weblink) != null ? ref.templates : void 0;
    if (!templates || templates.length === 0) {
      return;
    }
    return templates;
  };

  CustomDataTypeLink.prototype.__getTemplateAndPlaceholdersForUrl = function(url) {
    var escapedStringRegExp, i, index, j, len, len1, match, nextPlaceholderMatch, placeholdersRegexp, placeholdersValues, template, templates, urlRegExpValues, value;
    if (!url) {
      return;
    }
    templates = this.__getTemplates();
    if (!templates) {
      return;
    }
    for (index = i = 0, len = templates.length; i < len; index = ++i) {
      template = templates[index];
      escapedStringRegExp = CUI.util.escapeRegExp(template.url);
      escapedStringRegExp = escapedStringRegExp.replace(/%[^%]+%/g, "(.*)");
      urlRegExpValues = new RegExp(escapedStringRegExp);
      match = urlRegExpValues.exec(url);
      if ((match != null ? match.length : void 0) > 0) {
        match.shift();
        placeholdersRegexp = /%([^%]+)%/g;
        placeholdersValues = {};
        for (j = 0, len1 = match.length; j < len1; j++) {
          value = match[j];
          if (value.startsWith("%") && value.endsWith("%")) {
            continue;
          }
          nextPlaceholderMatch = placeholdersRegexp.exec(template.url);
          if (nextPlaceholderMatch && nextPlaceholderMatch[1]) {
            placeholdersValues[nextPlaceholderMatch[1]] = value;
          }
        }
        return {
          template: template,
          index: index,
          placeholdersValues: placeholdersValues
        };
      }
    }
  };

  CustomDataTypeLink.prototype.__getTemplateSelectFields = function(cdata) {
    var fields, getPlaceholdersFields, i, len, loadTemplate, placeholdersData, placeholdersFieldForm, placeholdersFields, selectField, template, templateFound, templateIndex, templateSelectOptions, templates;
    templates = this.__getTemplates();
    if (!templates) {
      return;
    }
    getPlaceholdersFields = (function(_this) {
      return function(template) {
        var i, label, len, placeholder, placeholdersFields, ref;
        placeholdersFields = [];
        ref = template.placeholders;
        for (i = 0, len = ref.length; i < len; i++) {
          placeholder = ref[i];
          label = ez5.loca.getBestFrontendValue(placeholder.displayname);
          placeholdersFields.push({
            type: CUI.Input,
            name: placeholder.key,
            form: {
              label: label || placeholder.key
            }
          });
        }
        return placeholdersFields;
      };
    })(this);
    loadTemplate = (function(_this) {
      return function(form, templateIndex) {
        var data, key, placeholdersFields, ref, template, templateFound, value;
        data = form.getData();
        template = templates[templateIndex];
        templateFound = _this.__getTemplateAndPlaceholdersForUrl(data.url);
        if (templateFound != null ? templateFound.template : void 0) {
          ref = templateFound.placeholdersValues;
          for (key in ref) {
            value = ref[key];
            placeholdersData[key] = value;
          }
        }
        _this.__fillUrl(data, template);
        _this.__fillDisplayName(data, template);
        placeholdersFields = getPlaceholdersFields(template);
        placeholdersFieldForm.fields = placeholdersFields;
        placeholdersFieldForm.hidden = placeholdersFields.length === 0;
        placeholdersFieldForm.data = placeholdersData;
        form.reload();
      };
    })(this);
    placeholdersData = {};
    if (cdata) {
      templateFound = this.__getTemplateAndPlaceholdersForUrl(cdata.url);
      if (templateFound != null ? templateFound.template : void 0) {
        placeholdersData = templateFound.placeholdersValues;
        cdata.placeholders = placeholdersData;
        cdata.templateIndex = templateFound.index;
        this.__fillData(cdata, templateFound.template);
        placeholdersFields = getPlaceholdersFields(templateFound.template);
      }
    }
    fields = placeholdersFields || [];
    placeholdersFieldForm = {
      type: CUI.Form,
      name: "placeholders",
      fields: fields,
      hidden: fields.length === 0,
      onDataChanged: (function(_this) {
        return function(data, field) {
          var mainData, mainForm, ref, template, textFieldName;
          mainForm = field.getForm().getForm();
          mainData = mainForm.getData();
          template = templates[mainData.templateIndex];
          _this.__fillUrl(mainData, template);
          textFieldName = (function() {
            switch (this.getTitleType()) {
              case "text-l10n":
                return "text";
              case "text":
                return "text_plain";
            }
          }).call(_this);
          if (textFieldName) {
            _this.__fillDisplayName(mainData, template);
            mainForm.getFieldsByName(textFieldName)[0].reload();
          }
          mainForm.getFieldsByName("url")[0].reload();
          if ((ref = mainForm.getFieldsByName("preview")[0]) != null) {
            ref.reload();
          }
        };
      })(this)
    };
    templateSelectOptions = [
      {
        text: $$("custom.data.type.link.template.select"),
        value: null
      }
    ];
    for (templateIndex = i = 0, len = templates.length; i < len; templateIndex = ++i) {
      template = templates[templateIndex];
      templateSelectOptions.push({
        text: ez5.loca.getBestFrontendValue(template.name),
        value: templateIndex
      });
    }
    selectField = {
      type: CUI.Select,
      name: "templateIndex",
      options: templateSelectOptions,
      form: {
        label: $$("custom.data.type.link.template.select.label")
      },
      onDataChanged: (function(_this) {
        return function(data, field) {
          var form;
          form = field.getForm();
          if (CUI.util.isNull(data.templateIndex)) {
            placeholdersFieldForm.fields = [];
            placeholdersFieldForm.hidden = true;
            form.reload();
          } else {
            loadTemplate(form, data.templateIndex);
          }
        };
      })(this)
    };
    return [selectField, placeholdersFieldForm];
  };

  CustomDataTypeLink.prototype.__fillData = function(cdata, template) {
    var languages;
    this.__fillUrl(cdata, template);
    switch (this.getTitleType()) {
      case "text-l10n":
        if (CUI.util.isEmpty(cdata.text)) {
          this.__fillDisplayName(cdata, template);
          return;
        }
        languages = ez5.session.getConfigFrontendLanguages();
        if (!languages.some((function(_this) {
          return function(language) {
            return !CUI.util.isEmpty(cdata.text[language]);
          };
        })(this))) {
          return this.__fillDisplayName(cdata, template);
        }
        break;
      case "text":
        if (CUI.util.isEmpty(cdata.text_plain)) {
          return this.__fillDisplayName(cdata, template);
        }
    }
  };

  CustomDataTypeLink.prototype.renderDetailOutput = function(data, top_level_data, opts) {
    var cdata, templateFound;
    cdata = this.initData(data);
    if (cdata) {
      templateFound = this.__getTemplateAndPlaceholdersForUrl(cdata.url);
      if (templateFound != null ? templateFound.template : void 0) {
        cdata.placeholders = templateFound.placeholdersValues;
        this.__fillData(cdata, templateFound.template);
      }
    }
    return this.__renderButtonByData(cdata);
  };

  CustomDataTypeLink.prototype.getDataStatus = function(cdata) {
    var status;
    status = (function(_this) {
      return function() {
        var placeholders, ref, template, templates;
        if (!CUI.isPlainObject(cdata)) {
          return "empty";
        }
        if (CUI.util.isEmpty((ref = cdata.url) != null ? ref.trim() : void 0)) {
          return "empty";
        }
        templates = _this.__getTemplates();
        template = templates != null ? templates[cdata.templateIndex] : void 0;
        if (template && cdata.placeholders) {
          placeholders = template.placeholders;
          if (placeholders.some(function(placeholder) {
            return CUI.util.isEmpty(cdata.placeholders[placeholder.key]);
          })) {
            return "invalid";
          }
        }
        if (_this.__isValidUrl(cdata.url)) {
          return "ok";
        }
        return "invalid";
      };
    })(this)();
    return status;
  };

  CustomDataTypeLink.prototype.__isValidUrl = function(url) {
    var location;
    location = CUI.parseLocation(url);
    return !!location && /.+\..{2,}$/.test(location.hostname);
  };

  CustomDataTypeLink.prototype.__renderButtonByData = function(cdata, template) {
    var goto_url, tooltip_attrs, tt_text, urlLocation;
    if (template == null) {
      template = false;
    }
    if (!template) {
      switch (this.getDataStatus(cdata)) {
        case "empty":
          if (cdata._template && !CUI.util.isEmpty(cdata._template.url)) {
            return this.__renderButtonByData(cdata._template, true);
          }
          return new CUI.EmptyLabel({
            text: $$("custom.data.type.link.edit.no_link")
          });
        case "invalid":
          if (CUI.util.isNull(cdata.templateIndex)) {
            return new CUI.EmptyLabel({
              text: $$("custom.data.type.link.edit.no_valid_link"),
              "class": "ez-label-invalid"
            });
          } else {
            return new CUI.EmptyLabel({
              text: $$("custom.data.type.link.edit.template.missing_placeholders"),
              "class": "ez-label-invalid"
            });
          }
      }
    }
    urlLocation = CUI.parseLocation(cdata.url);
    goto_url = urlLocation.href;
    if (cdata.datetime) {
      tt_text = $$("custom.data.type.link.url.tooltip_with_datetime", {
        url: goto_url,
        datetime: ez5.format_date_and_time(cdata.datetime)
      });
    } else {
      tt_text = $$("custom.data.type.link.url.tooltip", {
        url: goto_url
      });
    }
    tooltip_attrs = {
      url: goto_url,
      datetime: ez5.format_date_and_time(cdata.datetime)
    };
    return new CUI.ButtonHref({
      appearance: "link",
      href: goto_url,
      target: "_blank",
      tooltip: {
        markdown: true,
        text: tt_text
      },
      text: this.getLinkText(cdata) || goto_url
    }).DOM;
  };

  CustomDataTypeLink.prototype.getLinkText = function(cdata) {
    var txt;
    switch (this.getTitleType()) {
      case "none":
        txt = "";
        break;
      case "text":
        txt = cdata.text_plain;
        break;
      case "text-l10n":
        txt = ez5.loca.getBestFrontendValue(cdata.text);
    }
    if (!CUI.util.isEmpty(txt)) {
      return txt.trim();
    } else {
      return txt;
    }
  };

  CustomDataTypeLink.prototype.getCheckInfo = function(mode) {
    var info;
    if (mode === "detail" || mode === "text") {
      return [];
    }
    info = [$$("custom.data.type.link.valid_url")];
    return info;
  };

  CustomDataTypeLink.prototype.checkValue = function(data, top_level_data, opts) {
    var cdata;
    cdata = data[this.name()];
    switch (this.getDataStatus(cdata)) {
      case "invalid":
        return $$("custom.data.type.link.invalid_url");
      case "empty":
        if (this.isRequired(data, top_level_data, opts)) {
          return $$("data.column.check.required", {
            field: this.fullNameLocalized()
          });
        }
    }
    return true;
  };

  CustomDataTypeLink.prototype.getSaveData = function(data, save_data, opts) {
    var cdata, ref, template_data;
    if (opts == null) {
      opts = {};
    }
    if (opts.demo_data) {
      return {
        url: "www.example.com",
        text: "Example",
        datetime: {
          value: ""
        }
      };
    }
    template_data = (ref = data._template) != null ? ref[this.name()] : void 0;
    cdata = data[this.name()];
    switch (this.getDataStatus(cdata)) {
      case "invalid":
        return save_data[this.name()] = this.__buildData(cdata);
      case "empty":
        if (template_data && this.getDataStatus(template_data) === "ok") {
          return save_data[this.name()] = template_data;
        } else {
          return save_data[this.name()] = null;
        }
        break;
      case "ok":
        return save_data[this.name()] = this.__buildData(cdata);
    }
  };

  CustomDataTypeLink.prototype.__buildData = function(cdata) {
    var hostnameParts, lang, location, ref, standard, text, text_plain, tld, url, value;
    standard = {
      l10ntext: void 0,
      text: void 0
    };
    switch (this.getTitleType()) {
      case "text-l10n":
        text = cdata.text;
        for (lang in text) {
          value = text[lang];
          if (CUI.util.isEmpty(value.trim())) {
            continue;
          }
          if (!standard.l10ntext) {
            standard.l10ntext = {};
          }
          standard.l10ntext[lang] = value;
        }
        break;
      case "text":
        text_plain = cdata.text_plain;
        if (!CUI.util.isEmpty(text_plain != null ? text_plain.trim() : void 0)) {
          standard.text = text_plain;
        }
    }
    url = cdata.url.trim();
    if (!standard.text && !standard.l10ntext) {
      standard.text = url;
    } else if (standard.l10ntext) {
      delete standard.text;
    } else {
      delete standard.l10ntext;
    }
    location = CUI.parseLocation(url);
    hostnameParts = location != null ? (ref = location.hostname) != null ? ref.split(".") : void 0 : void 0;
    if (hostnameParts) {
      tld = hostnameParts[hostnameParts.length - 1];
    }
    return {
      url: url,
      hostname: location != null ? location.hostname : void 0,
      tld: tld || "",
      text: text,
      text_plain: text_plain,
      datetime: cdata.datetime,
      _fulltext: {
        l10ntext: text,
        text: text_plain,
        string: url
      },
      _standard: standard
    };
  };

  CustomDataTypeLink.prototype.hasRenderForSort = function() {
    return true;
  };

  CustomDataTypeLink.prototype.sortExtraOpts = function() {
    return [
      {
        text: $$("custom.data.type.link.modal.form.url.label"),
        value: "url"
      }
    ];
  };

  CustomDataTypeLink.prototype.getCSVDestinationFields = function(csvImporter) {
    var opts;
    opts = {
      csvImporter: csvImporter,
      field: this
    };
    return [new CustomDataTypeLinkColumnCSVImporterDestinationField(opts)];
  };

  return CustomDataTypeLink;

})(CustomDataType);

CustomDataType.register(CustomDataTypeLink);
