// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

if (ez5.PdfCreator) {
  ez5.PdfCreator.Node.DisplayFieldValue = (function(superClass) {
    extend(DisplayFieldValue, superClass);

    function DisplayFieldValue() {
      return DisplayFieldValue.__super__.constructor.apply(this, arguments);
    }

    DisplayFieldValue.POOL_ATTR = ["name", "description", "contact"];

    DisplayFieldValue.TOP_LEVEL_DATA = ["_system_object_id", "_global_object_id", "_uuid", "_created", "_last_modified", "_owner"];

    DisplayFieldValue.ADDITIONAL_DATA = ["_version"];

    DisplayFieldValue.getName = function() {
      return "displayFieldValue";
    };

    DisplayFieldValue.prototype.__renderPdfContent = function(opts) {
      var content, data, object, replacementText, replacements, text, values;
      object = opts.object;
      if (!object) {
        return;
      }
      data = this.getData();
      text = data.text;
      replacements = this.__getFieldNames(text);
      values = this.__getValues(object[object._objecttype], replacements);
      if (!this.__hasAnyReplacement(data, values, opts)) {
        return;
      }
      replacementText = this.__getLabelText(values);
      replacementText = this.__poolReplacement(object[object._objecttype], replacementText);
      replacementText = this.__topLevelDataReplacement(object, replacementText);
      replacementText = this.__additionalDataReplacement(object[object._objecttype], replacementText);
      content = new CUI.MultilineLabel({
        text: replacementText,
        markdown: true
      });
      return content;
    };

    DisplayFieldValue.prototype.__getSettingsFields = function() {
      var fields, textHintButton;
      textHintButton = new CUI.Button({
        text: $$("display-field-values.custom.splitter.text.hint-text"),
        appearance: "flat",
        onClick: (function(_this) {
          return function() {
            var addData, attr, content, field, fieldName, fieldNames, j, k, l, lang, len, len1, len2, len3, len4, m, n, pop, ref, ref1, ref2, ref3, ref4, ref5, text, topLevelData, type;
            fieldNames = [];
            ref = _this.__getMask().getFields("all");
            for (j = 0, len = ref.length; j < len; j++) {
              field = ref[j];
              fieldName = field.name();
              if (!fieldName || !((ref1 = field.FieldSchema) != null ? ref1._column : void 0)) {
                continue;
              }
              type = field.FieldSchema._column.type;
              if (type === "boolean") {
                continue;
              } else if (type === "eas") {
                continue;
              } else if (type === "daterange") {
                fieldNames.push(fieldName + ":from");
                fieldNames.push(fieldName + ":to");
              } else if (type === "text_l10n" || type === "text_l10n_oneline") {
                fieldNames.push(fieldName + ":best");
                ref2 = ez5.loca.getDatabaseLanguages();
                for (k = 0, len1 = ref2.length; k < len1; k++) {
                  lang = ref2[k];
                  fieldNames.push(fieldName + ":" + lang);
                }
                continue;
              } else if (type === "link") {
                fieldNames.push(fieldName + ":standard-1");
                fieldNames.push(fieldName + ":standard-2");
                fieldNames.push(fieldName + ":standard-3");
              } else {
                fieldNames.push(fieldName);
              }
            }
            if (_this.__getMask().table.schema.pool_link) {
              ref3 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
              for (l = 0, len2 = ref3.length; l < len2; l++) {
                attr = ref3[l];
                fieldNames.push("pool." + attr);
              }
            }
            ref4 = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
            for (m = 0, len3 = ref4.length; m < len3; m++) {
              topLevelData = ref4[m];
              fieldNames.push("object." + topLevelData);
            }
            ref5 = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
            for (n = 0, len4 = ref5.length; n < len4; n++) {
              addData = ref5[n];
              fieldNames.push("object." + addData);
            }
            fieldNames = fieldNames.concat(fieldNames.map(function(fieldName) {
              return fieldName + ":urlencoded";
            })).sort();
            text = $$("display-field-values.custom.splitter.text.hint-content", {
              fields: fieldNames
            });
            content = new CUI.Label({
              text: text,
              markdown: true
            });
            pop = new ez5.HintPopover({
              element: textHintButton,
              content: content,
              padded: true
            });
            return pop.show();
          };
        })(this)
      });
      fields = [
        {
          type: CUI.Input,
          name: "text",
          min_rows: 9,
          textarea: true,
          maximize_horizontal: true,
          "class": "ez5-display-field-values-text-input",
          form: {
            label: $$("display-field-values.custom.splitter.text.label"),
            hint: textHintButton
          },
          onDataChanged: (function(_this) {
            return function(_, field) {
              CUI.Events.trigger({
                node: field,
                type: "content-resize"
              });
            };
          })(this)
        }, {
          type: CUI.Checkbox,
          name: "output_empty",
          form: {
            label: $$("display-field-values.custom.splitter.output_empty.label")
          }
        }, {
          type: CUI.Checkbox,
          name: "dont_escape_markdown_in_values",
          form: {
            label: $$("display-field-values.custom.splitter.dont_escape_markdown_in_values.label")
          }
        }
      ];
      return fields;
    };

    DisplayFieldValue.prototype.__getLabelText = function(values) {
      var _field, _value, bestValue, data, doReplace, dontEscapeMarkdownInValues, fieldName, i, j, k, key, len, len1, ref, ref1, regexp, replacement, replacements, text, value;
      data = this.getData();
      text = data.text;
      dontEscapeMarkdownInValues = data.dont_escape_markdown_in_values;
      replacements = this.__getFieldNames(text, false);
      doReplace = function(field, _value) {
        var regexp;
        regexp = new RegExp("%" + field + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(_value));
        if (!dontEscapeMarkdownInValues) {
          _value = MarkdownEscape.escape("" + _value);
        }
        regexp = new RegExp("%" + field + "%", "g");
        return text = text.replace(regexp, _value);
      };
      for (fieldName in values) {
        value = values[fieldName];
        if (CUI.util.isPlainObject(value)) {
          if (value._standard) {
            ref = [1, 2, 3];
            for (j = 0, len = ref.length; j < len; j++) {
              i = ref[j];
              if (!((ref1 = value._standard[i]) != null ? ref1.text : void 0)) {
                continue;
              }
              bestValue = ez5.loca.getBestFrontendValue(value._standard[i].text);
              doReplace(fieldName + ":standard-" + i, bestValue);
            }
          } else {
            bestValue = ez5.loca.getBestFrontendValue(value);
            if (!CUI.util.isEmpty(bestValue)) {
              doReplace(fieldName + ":best", bestValue);
            }
            if (!CUI.util.isEmpty(value.value)) {
              doReplace("" + fieldName, value.value);
            }
            for (key in value) {
              _value = value[key];
              if (CUI.util.isEmpty(_value) || CUI.util.isPlainObject(_value)) {
                continue;
              }
              _field = fieldName + ":" + key;
              doReplace(_field, _value);
            }
          }
        } else {
          doReplace(fieldName, value);
        }
      }
      for (k = 0, len1 = replacements.length; k < len1; k++) {
        replacement = replacements[k];
        regexp = new RegExp("%" + replacement + "%", "g");
        text = text.replace(regexp, "");
      }
      return text;
    };

    DisplayFieldValue.prototype.__getValues = function(data, fieldNames) {
      var fieldName, j, len, value, values;
      values = {};
      for (j = 0, len = fieldNames.length; j < len; j++) {
        fieldName = fieldNames[j];
        value = data[fieldName];
        if (CUI.util.isEmpty(value)) {
          continue;
        }
        if (CUI.util.isPlainObject(value)) {
          if (!Object.values(value).some(function(_val) {
            return !CUI.util.isEmpty(_val);
          })) {
            continue;
          }
        }
        values[fieldName] = value;
      }
      return values;
    };

    DisplayFieldValue.prototype.__getFieldNames = function(text, removeSuffix) {
      var fieldName, fieldNames, matches, ref, values;
      if (removeSuffix == null) {
        removeSuffix = true;
      }
      fieldNames = new Set();
      matches = text.matchAll(ez5.DisplayFieldValuesMaskSplitter.FIELD_NAMES_REGEXP);
      while (values = (ref = matches.next()) != null ? ref.value : void 0) {
        if (values[1]) {
          fieldName = values[1];
          if (removeSuffix) {
            fieldName = fieldName.replace(/:(.*)/g, "");
          }
          fieldNames.add(fieldName);
        }
      }
      return Array.from(fieldNames);
    };

    DisplayFieldValue.prototype.__topLevelDataReplacement = function(topLevelData, text) {
      var j, len, ref, ref1, regexp, topAttr, value;
      if (CUI.util.isEmpty(topLevelData)) {
        return text;
      }
      ref = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
      for (j = 0, len = ref.length; j < len; j++) {
        topAttr = ref[j];
        if (topAttr === "_owner") {
          value = (ref1 = topLevelData[topAttr]) != null ? ref1.user._generated_displayname : void 0;
          if (CUI.util.isEmpty(value)) {
            regexp = new RegExp("%object." + topAttr + "%", "g");
            text = text.replace(regexp, "");
            regexp = new RegExp("%object." + topAttr + ":urlencoded%", "g");
            text = text.replace(regexp, "");
            continue;
          }
        } else {
          value = topLevelData[topAttr];
          if (topAttr === "_created" || topAttr === "_last_modified") {
            value = ez5.format_date_and_time(value);
          }
        }
        regexp = new RegExp("%object." + topAttr + "%", "g");
        text = text.replace(regexp, value);
        regexp = new RegExp("%object." + topAttr + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(value));
      }
      return text;
    };

    DisplayFieldValue.prototype.__additionalDataReplacement = function(data, text) {
      var addAttr, j, len, ref, regexp, value;
      if (CUI.util.isEmpty(data)) {
        return text;
      }
      ref = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
      for (j = 0, len = ref.length; j < len; j++) {
        addAttr = ref[j];
        value = data[addAttr];
        regexp = new RegExp("%object." + addAttr + "%", "g");
        text = text.replace(regexp, value);
        regexp = new RegExp("%object." + addAttr + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(value));
      }
      return text;
    };

    DisplayFieldValue.prototype.__poolReplacement = function(data, text) {
      var cleanAndReturn, j, len, poolAttr, poolData, poolObj, ref, ref1, ref2, regexp, value;
      cleanAndReturn = (function(_this) {
        return function() {
          var j, len, poolAttr, ref, regexp;
          ref = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
          for (j = 0, len = ref.length; j < len; j++) {
            poolAttr = ref[j];
            regexp = new RegExp("%pool." + poolAttr + "%", "g");
            text = text.replace(regexp, "");
            regexp = new RegExp("%pool." + poolAttr + ":urlencoded%", "g");
            text = text.replace(regexp, "");
          }
          return text;
        };
      })(this);
      poolObj = ez5.pools.findPoolById((ref = data._pool) != null ? ref.pool._id : void 0);
      if (!poolObj) {
        return cleanAndReturn();
      }
      poolData = poolObj.data.pool;
      ref1 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
      for (j = 0, len = ref1.length; j < len; j++) {
        poolAttr = ref1[j];
        value = poolData[poolAttr];
        if (CUI.util.isEmpty(value)) {
          value = "";
        } else if (poolAttr === "contact") {
          value = ((ref2 = value.user) != null ? ref2._generated_displayname : void 0) || "";
        } else {
          value = ez5.loca.getBestFrontendValue(value);
        }
        regexp = new RegExp("%pool." + poolAttr + "%", "g");
        text = text.replace(regexp, value);
        regexp = new RegExp("%pool." + poolAttr + ":urlencoded%", "g");
        text = text.replace(regexp, encodeURI(value));
      }
      return text;
    };

    DisplayFieldValue.prototype.__hasPoolReplacement = function(opts) {
      var dataOptions, j, len, poolAttr, poolData, poolObj, ref, ref1, text, value;
      if (!this.__getMask().table.schema.pool_link) {
        return false;
      }
      dataOptions = this.getData();
      text = dataOptions.text;
      poolObj = ez5.pools.findPoolById((ref = opts.object[opts.object._objecttype]._pool) != null ? ref.pool._id : void 0);
      poolData = poolObj.data.pool;
      if (!dataOptions.output_empty && (text != null ? text.length : void 0) > 0) {
        return true;
      }
      if (!poolData) {
        return false;
      }
      ref1 = ez5.DisplayFieldValuesMaskSplitter.POOL_ATTR;
      for (j = 0, len = ref1.length; j < len; j++) {
        poolAttr = ref1[j];
        value = poolData[poolAttr];
        if ((text != null ? text.includes("%pool." + poolAttr + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
      return false;
    };

    DisplayFieldValue.prototype.__hasAnyReplacement = function(data, values, opts) {
      var addData, j, k, len, len1, ref, ref1, topAttr, value;
      if (opts == null) {
        opts = {};
      }
      if (this.__hasPoolReplacement(opts)) {
        return true;
      }
      if (!CUI.util.isEmpty(values)) {
        return true;
      }
      ref = ez5.DisplayFieldValuesMaskSplitter.TOP_LEVEL_DATA;
      for (j = 0, len = ref.length; j < len; j++) {
        topAttr = ref[j];
        value = data[topAttr];
        if ((typeof text !== "undefined" && text !== null ? text.includes("%object." + topAttr + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
      ref1 = ez5.DisplayFieldValuesMaskSplitter.ADDITIONAL_DATA;
      for (k = 0, len1 = ref1.length; k < len1; k++) {
        addData = ref1[k];
        value = data[addData];
        if ((typeof text !== "undefined" && text !== null ? text.includes("%object." + addData + "%") : void 0) && !CUI.util.isEmpty(value)) {
          return true;
        }
      }
      return false;
    };

    return DisplayFieldValue;

  })(ez5.PdfCreator.Node);
  ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.DisplayFieldValue);
}
