class Easydb4MigrationPlugin.StadtHanau extends Easydb4MigrationPlugin
	name: ->
		"stadt-hanau"

	payload: (filename, json, update, store_file) ->
		switch json.import_type
			when "tags"
				_tags = []

				add_tag = (name, displayname) =>
					_tags.push
						tag:
							shortname: name
							displayname:
								"de-DE": displayname
							is_default: false
							enabled: true
							displaytype: "search"
							type: "individual"

				json.tags.push
					taggroup:
						reference: "easydb4:itemtyp"
						type: "checkbox"
						displayname:
							"de-DE": "Itemtyp"
					_tags: _tags

				dfr = new CUI.Deferred()

				@_migration.query('SELECT id, name FROM "source.stadt_hanau.itemtyp" ORDER BY id')
				.fail(dfr.reject)
				.done (result) =>
					for row in result.rows
						add_tag("itemtyp:"+row.id, row.name)
					dfr.resolve()

				return dfr.promise()

		switch json.objecttype
			when "bilder"
				for obj in json.objects
					if not obj._tags
						obj._tags = []

					if obj.bilder.lk_itemtyp_id
						shortname = obj.bilder.lk_itemtyp_id.itemtyp["lookup:_id"].easydb4_reference
						obj._tags.push
							"lookup:_id":
								shortname: shortname

		return

ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.StadtHanau)
