class Easydb4Migration.UniWuerzburg extends Easydb4MigrationPlugin

	name: ->
		"uni-wuerzburg"

	payload: (filename, json, update) ->
		if json.objecttype != "bilder"
			return

		console.debug "payload:", json, update
		dfr = new CUI.Deferred()
		@_migration.query('SELECT * FROM "source.public.pool"')
		.fail(dfr.reject)
		.done (result) =>

			ptb = @_migration.__info.pool_tables[0]

			# console.debug "pools in wuerzburg2:", ptb, result

			sinologie = []
			hochschule = []
			kunstgeschichte = []
			mvw = []
			museum = []

			for row in result.rows
				if not row.editmask
					continue

				ref = ptb.real_source_name+":"+row.id

				if row.editmask.match(/Sinologie/)
					sinologie.push(ref)

				if row.editmask.match(/Hochschule/)
					hochschule.push(ref)

				if row.editmask.match(/KuG/)
					kunstgeschichte.push(ref)

				if row.editmask.match(/mvw/)
					mvw.push(ref)

				else if row.editmask.match(/Museum/)
					museum.push(ref)


			@_migration.query('SELECT id FROM "source.public.bilder"')
			.fail(dfr.reject)
			.done (result) =>
				bild_ids = []

				for row in result.rows
					bild_ids.push(row.id)

				console.debug "all bild ids:", bild_ids


				move_linked = (obj, key, key2) =>
					if obj.bilder[key] == undefined
						return

					# console.debug "move_linked:", obj, key, key2

					# lk_aufbewahrungsort_lehre_id

					obj.bilder[key2+":source_name"] = obj.bilder[key+":source_name"]

					obj.bilder[key2] = obj.bilder[key]

					delete(obj.bilder[key])
					delete(obj.bilder[key+":source_name"])

				move_reg = (obj, key, key2) =>
					if obj.bilder[key] == undefined
						return

					# console.debug "move_reg:", obj, key, key2

					obj.bilder[key2] = obj.bilder[key]
					delete(obj.bilder[key])

				move_map = (map, key, key2) =>
					if map[key] == undefined
						return

					# console.debug "move_reg:", obj, key, key2

					map[key2] = map[key]
					delete(map[key])

				for obj in json.objects
					ref = obj.bilder._pool.pool["lookup:_id"].reference

					if ref in sinologie
						move_reg(obj, "datum", "datum_sinologie")
						move_reg(obj, "formatmasse_hsk", "formatmassenventa")
						move_linked(obj, "gattung_id", "gattung_id_sinologie")
						move_linked(obj, "fundort_id", "fundort_id_sinologie")

					if ref in hochschule
						move_reg(obj, "beschreibung", "beschreibung_hsk")

					if ref in kunstgeschichte
						move_reg(obj, "name", "name_kug")
						move_reg(obj, "detail", "detail_kug")
						move_linked(obj, "standort_id", "standort_id_kug")

					if ref in museum
						move_reg(obj, "_nested:bilder__inventarnummern", "_nested:bilder__inventarnummern_museum")
						for inv_nested in obj.bilder["_nested:bilder__inventarnummern_museum"] or []
							move_map(inv_nested, "inventarnummer", "inventarnr")
						move_reg(obj, "zustand", "zustand_museum")

					if ref in mvw
						move_reg(obj, "wasserzeichen", "wasserzeichen_mvw")


					# doppelte bild__bild
					ez_ref = obj.bilder.easydb4_reference

					CUI.util.removeFromArray(null, obj.bilder["_nested:bilder__bilder"] or [], (bild__bild) =>
						ref = bild__bild.bild_id?.bilder["lookup:_id"].easydb4_reference
						bild_id = parseInt(ref.split(":")[1])

						if bild_id not in bild_ids
							@_migration.logwarn("Ref '"+ref+"' not found in exported objects, removing nested entry.")
							return true

						if ref == ez_ref
							@_migration.logwarn("Removed self referencing bilder__bilder link from "+ez_ref)
							return true
						else
							return false
					)


				dfr.resolve()
				return

		dfr.promise()


ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4Migration.UniWuerzburg)
