// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.HijriGregorianConverterMaskSplitter = (function(superClass) {
  extend(HijriGregorianConverterMaskSplitter, superClass);

  function HijriGregorianConverterMaskSplitter() {
    return HijriGregorianConverterMaskSplitter.__super__.constructor.apply(this, arguments);
  }

  HijriGregorianConverterMaskSplitter.prototype.isSimpleSplit = function() {
    return false;
  };

  HijriGregorianConverterMaskSplitter.prototype.renderField = function(opts) {
    var areDatesAlreadyConverted, buttonBar, data, dateFields, dateGregorian, dateHijri, fields, fieldsRendererPlain, innerFields, toGregorianButton, toHijriButton;
    innerFields = this.renderInnerFields(opts);
    if (opts.mode === "detail" || opts.mode === "expert") {
      return innerFields;
    }
    fieldsRendererPlain = this.__customFieldsRenderer.fields[0];
    if (!(fieldsRendererPlain instanceof FieldsRendererPlain)) {
      return innerFields;
    }
    fields = fieldsRendererPlain.getFields() || [];
    if (!fields) {
      return innerFields;
    }
    dateFields = fields.filter(function(field) {
      return field instanceof DateColumn;
    });
    dateGregorian = dateFields[0];
    dateHijri = dateFields[1];
    if (!dateGregorian || !dateHijri) {
      return innerFields;
    }
    if (dateGregorian instanceof DateRangeColumn && !(dateHijri instanceof DateRangeColumn)) {
      return innerFields;
    }
    if (dateHijri instanceof DateRangeColumn && !(dateGregorian instanceof DateRangeColumn)) {
      return innerFields;
    }
    data = opts.data;
    toHijriButton = new LocaButton({
      loca_key: "hijri.gregorian.converter.button.to-hijri",
      disabled: this.__isDateInvalidOrEmpty(data, dateGregorian, opts),
      onClick: (function(_this) {
        return function() {
          var gregorianValue, hijriValue;
          gregorianValue = _this.__getDateValue(data, dateGregorian);
          hijriValue = _this.__toHijri(gregorianValue);
          dateHijri.updateValue(data, hijriValue);
          toHijriButton.disable();
          return toGregorianButton.disable();
        };
      })(this)
    });
    toGregorianButton = new LocaButton({
      loca_key: "hijri.gregorian.converter.button.to-gregorian",
      disabled: this.__isDateInvalidOrEmpty(data, dateHijri, opts),
      onClick: (function(_this) {
        return function() {
          var gregorianValue, hijriValue;
          hijriValue = _this.__getDateValue(data, dateHijri);
          gregorianValue = _this.__toGregorian(hijriValue);
          dateGregorian.updateValue(data, gregorianValue);
          toHijriButton.disable();
          return toGregorianButton.disable();
        };
      })(this)
    });
    areDatesAlreadyConverted = (function(_this) {
      return function() {
        var gregorianValue, hijriConvertedValue, hijriValue;
        if (toHijriButton.isDisabled() || toGregorianButton.isDisabled()) {
          return;
        }
        gregorianValue = _this.__getDateValue(data, dateGregorian);
        hijriValue = _this.__getDateValue(data, dateHijri);
        hijriConvertedValue = _this.__toGregorian(hijriValue);
        if (_this.__isSameDateValue(dateGregorian, gregorianValue, hijriConvertedValue)) {
          toHijriButton.disable();
          toGregorianButton.disable();
        }
      };
    })(this);
    areDatesAlreadyConverted();
    CUI.Events.listen({
      node: innerFields[0],
      type: ["editor-changed", "search-input-change"],
      call: (function(_this) {
        return function() {
          if (_this.__isDateInvalidOrEmpty(data, dateGregorian, opts)) {
            toHijriButton.disable();
          } else {
            toHijriButton.enable();
          }
          if (_this.__isDateInvalidOrEmpty(data, dateHijri, opts)) {
            toGregorianButton.disable();
          } else {
            toGregorianButton.enable();
          }
          return areDatesAlreadyConverted();
        };
      })(this)
    });
    buttonBar = new CUI.Buttonbar({
      "class": "ez5-field-block",
      buttons: [toHijriButton, toGregorianButton]
    });
    CUI.dom.append(innerFields[0], buttonBar);
    return innerFields;
  };

  HijriGregorianConverterMaskSplitter.prototype.__isDateInvalidOrEmpty = function(data, field, opts) {
    var checkedValue, gregorianValue;
    gregorianValue = this.__getDateValue(data, field);
    if (CUI.util.isEmpty(gregorianValue)) {
      return true;
    }
    checkedValue = field.checkValue(data, null, opts);
    if (!CUI.util.isTrue(checkedValue)) {
      return true;
    }
    return false;
  };

  HijriGregorianConverterMaskSplitter.prototype.__getDateValue = function(_data, field) {
    var data;
    data = _data[field.name()];
    if (!data) {
      return;
    }
    if (!CUI.util.isUndef(data.value)) {
      return data.value;
    }
    return {
      from: data.from,
      to: data.to
    };
  };

  HijriGregorianConverterMaskSplitter.prototype.__toGregorian = function(value) {
    var returnValue;
    if (CUI.util.isPlainObject(value)) {
      returnValue = {};
      if (value.from) {
        returnValue.from = ez5.HijriGregorianConverter.hijriToGregorian(value.from);
      }
      if (value.to) {
        returnValue.to = ez5.HijriGregorianConverter.hijriToGregorian(value.to);
      }
      return returnValue;
    }
    return ez5.HijriGregorianConverter.hijriToGregorian(value);
  };

  HijriGregorianConverterMaskSplitter.prototype.__toHijri = function(value) {
    var returnValue;
    if (CUI.util.isPlainObject(value)) {
      returnValue = {};
      if (value.from) {
        returnValue.from = ez5.HijriGregorianConverter.gregorianToHijri(value.from);
      }
      if (value.to) {
        returnValue.to = ez5.HijriGregorianConverter.gregorianToHijri(value.to);
      }
      return returnValue;
    }
    return ez5.HijriGregorianConverter.gregorianToHijri(value);
  };

  HijriGregorianConverterMaskSplitter.prototype.__isSameDateValue = function(dateField, value, convertedValue) {
    if (CUI.util.isPlainObject(value) && CUI.util.isPlainObject(convertedValue)) {
      return dateField.renderDateValue("" + value.from) === dateField.renderDateValue("" + convertedValue.to) && dateField.renderDateValue("" + value.from) === dateField.renderDateValue("" + convertedValue.to);
    }
    return dateField.renderDateValue("" + value) === dateField.renderDateValue("" + convertedValue);
  };

  HijriGregorianConverterMaskSplitter.prototype.getOptions = function() {
    return [];
  };

  HijriGregorianConverterMaskSplitter.prototype.trashable = function() {
    return true;
  };

  HijriGregorianConverterMaskSplitter.prototype.isEnabledForNested = function() {
    return true;
  };

  return HijriGregorianConverterMaskSplitter;

})(CustomMaskSplitter);

CUI.ready((function(_this) {
  return function() {
    return MaskSplitter.plugins.registerPlugin(ez5.HijriGregorianConverterMaskSplitter);
  };
})(this));
