// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node = (function(superClass) {
  extend(Node, superClass);

  function Node() {
    return Node.__super__.constructor.apply(this, arguments);
  }

  Node.getName = function() {
    return "pdf-node";
  };

  Node.getAvailableStyleSettings = function() {
    if (this.styleSettings) {
      return this.styleSettings;
    }
    this.styleSettings = {
      "class-name": {
        group: "basic",
        field: {
          type: CUI.Input,
          name: "class_name",
          form: {
            label: $$("pdf-creator.settings.node.class-name|label")
          }
        }
      },
      "height": {
        group: "basic",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.height|label")
          },
          name: "height"
        }
      },
      "width": {
        group: "basic",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.width|label")
          },
          name: "width"
        }
      },
      "position-absolute": {
        group: "extended",
        field: {
          type: CUI.Checkbox,
          form: {
            label: $$("pdf-creator.settings.node.position-absolute|label")
          },
          name: "position_absolute"
        }
      },
      "display": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.display|label")
          },
          name: "display"
        }
      },
      "background": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.background|label")
          },
          name: "background"
        }
      },
      "font-size": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.font-size|label")
          },
          name: "font_size"
        }
      },
      "color": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.color|label")
          },
          name: "color"
        }
      },
      "top": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.top|label")
          },
          name: "top"
        }
      },
      "bottom": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.bottom|label")
          },
          name: "bottom"
        }
      },
      "left": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.left|label")
          },
          name: "left"
        }
      },
      "right": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.right|label")
          },
          name: "right"
        }
      },
      "margin-top": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.margin-top|label")
          },
          name: "margin_top"
        }
      },
      "margin-bottom": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.margin-bottom|label")
          },
          name: "margin_bottom"
        }
      },
      "margin-left": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.margin-left|label")
          },
          name: "margin_left"
        }
      },
      "margin-right": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.margin-right|label")
          },
          name: "margin_right"
        }
      },
      "padding-top": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.padding-top|label")
          },
          name: "padding_top"
        }
      },
      "padding-bottom": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.padding-bottom|label")
          },
          name: "padding_bottom"
        }
      },
      "padding-left": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.padding-left|label")
          },
          name: "padding_left"
        }
      },
      "padding-right": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.padding-right|label")
          },
          name: "padding_right"
        }
      },
      "border-top": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.border-top|label")
          },
          name: "border_top"
        }
      },
      "border-bottom": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.border-bottom|label")
          },
          name: "border_bottom"
        }
      },
      "border-left": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.border-left|label")
          },
          name: "border_left"
        }
      },
      "border-right": {
        group: "extended",
        field: {
          type: CUI.Input,
          form: {
            label: $$("pdf-creator.settings.node.border-right|label")
          },
          name: "border_right"
        }
      }
    };
    return this.styleSettings;
  };

  Node.prototype.initOpts = function() {
    Node.__super__.initOpts.call(this);
    return this.addOpts({
      name: {
        check: String
      },
      data: {
        check: "PlainObject",
        "default": {}
      },
      children: {
        check: (function(_this) {
          return function(value) {
            return CUI.util.isArray(value) && value.every(function(_value) {
              return _value instanceof ez5.PdfCreator.Node;
            });
          };
        })(this)
      }
    });
  };

  Node.prototype.name = function() {
    return this._name;
  };

  Node.prototype.readOpts = function() {
    this._name = this.constructor.getName();
    Node.__super__.readOpts.call(this);
    this.setData(this._data);
    return this;
  };

  Node.prototype.initChildren = function() {
    this.children = this.children.filter((function(_this) {
      return function(node) {
        return node.isParentAllowed(_this);
      };
    })(this));
    return Node.__super__.initChildren.call(this);
  };

  Node.prototype.renderContent = function() {
    var horizontalLayout;
    this.__internalNameLabel = new CUI.Label({
      text: this.__getInternalName(),
      appearance: "secondary"
    });
    horizontalLayout = new CUI.HorizontalLayout({
      center: {
        content: new CUI.Label({
          text: this.getDisplayName()
        })
      },
      right: {
        content: this.__internalNameLabel
      }
    });
    return horizontalLayout.DOM;
  };

  Node.prototype.allowRowMove = function(to_node, newFather) {
    if (newFather === this.getRoot()) {
      return false;
    }
    return true;
  };

  Node.prototype.isParentAllowed = function(pdfNode) {
    var ref;
    return pdfNode && ((ref = pdfNode.name()) === "div" || ref === "document");
  };

  Node.prototype.setData = function(data) {
    if (!data.custom_css) {
      data.custom_css = $$("pdf-creator.settings.node.document.custom-css|placeholder");
    }
    return this.__data = data;
  };

  Node.prototype.getDisplayName = function() {
    return $$("pdf-creator.node." + this._name + ".display-name");
  };

  Node.prototype.__getInternalName = function() {
    return this.getData().internal_name;
  };

  Node.prototype.renderPdfContent = function(opts) {
    var customStylesTag, data, element;
    element = this.__renderPdfContent(opts);
    this.__addStyles(element);
    CUI.dom.addClass(element, "pdf-node");
    CUI.dom.addClass(element, "pdf-node-" + (this.name()));
    data = this.getData();
    if (element && data.custom_css) {
      customStylesTag = this.__createStyleElement(data.custom_css);
      CUI.dom.append(opts.head, customStylesTag);
    }
    if (opts.selectedNode === this) {
      CUI.dom.addClass(element, "pdf-node-selected");
    }
    return element;
  };

  Node.prototype.getSettingsForm = function(opts) {
    var customCSSPanel, extraPanels, fields, generalPanel, group, panelField, panels, ref, ref1, settingsFields, styleFields;
    if (opts == null) {
      opts = {};
    }
    panels = [];
    settingsFields = this.__getSettingsFields();
    if (this.__showInternalNameField()) {
      settingsFields.unshift({
        type: CUI.Input,
        name: "internal_name",
        form: {
          label: $$("pdf-creator.settings.node.document.internal-name|label")
        },
        onDataChanged: (function(_this) {
          return function() {
            _this.__internalNameLabel.setText(_this.__getInternalName());
          };
        })(this)
      });
    }
    if (settingsFields.length > 0) {
      generalPanel = this.__createPanelField(settingsFields, {
        group: "general"
      });
      panels.push(generalPanel);
    }
    ref = this.__getStyleFieldSettings();
    for (group in ref) {
      styleFields = ref[group];
      fields = styleFields.map(function(_field) {
        return _field.field;
      });
      panelField = this.__createPanelField(fields, {
        group: group,
        closed: group !== "basic",
        name_in_form: true
      });
      panels.push(panelField);
    }
    extraPanels = this.getExtraSettingsPanels(opts);
    if (extraPanels.length > 0) {
      panels = panels.concat(extraPanels);
    }
    if (this.__isCustomCSSEnabled()) {
      fields = [
        {
          type: CUI.CodeInput,
          mode: "css",
          name: "custom_css",
          maximize_horizontal: true
        }
      ];
      customCSSPanel = this.__createPanelField(fields, {
        group: "custom_css",
        closed: true
      });
      panels.push(customCSSPanel);
    }
    if (panels.length === 0) {
      return new CUI.Label({
        text: $$("pdf-creator.settings.node.no-settings|label"),
        centered: true,
        appearance: "secondary"
      });
    }
    if ((ref1 = this.__form) != null) {
      ref1.destroy();
    }
    this.__form = new CUI.Form({
      fields: panels,
      data: this.getData(),
      onDataChanged: (function(_this) {
        return function(data, field) {
          _this.__onDataChanged(data, field);
          return typeof opts.onDataChanged === "function" ? opts.onDataChanged(data, field) : void 0;
        };
      })(this)
    });
    this.__form.start();
    return this.__form;
  };

  Node.prototype.__createPanelField = function(fields, opts) {
    var field, group;
    if (opts == null) {
      opts = {};
    }
    if (CUI.util.isUndef(opts.closed)) {
      opts.closed = false;
    }
    if (CUI.util.isUndef(opts.name_in_form)) {
      opts.name_in_form = false;
    }
    group = opts.group;
    field = new CUI.DataFieldProxy({
      maximize_horizontal: true,
      element: (function(_this) {
        return function() {
          var panel;
          panel = new CUI.Panel({
            text: $$("pdf-creator.settings.node.group-" + group + "|label"),
            closed: opts.closed,
            radio: group,
            content: function() {
              var form;
              form = new CUI.Form({
                padded: true,
                data: _this.getData(),
                name: opts.name_in_form ? group : void 0,
                fields: fields
              });
              return form;
            }
          });
          return panel;
        };
      })(this)
    });
    return field;
  };

  Node.prototype.getExtraSettingsPanels = function(opts) {
    return [];
  };

  Node.prototype.getData = function(isForSaving) {
    if (isForSaving == null) {
      isForSaving = false;
    }
    return this.__data;
  };

  Node.prototype.getSaveData = function() {
    var _data, child, data, i, len, ref;
    _data = CUI.util.copyObject(this.getData(true), true);
    data = {
      name: this.name(),
      open: this.isOpen(),
      data: _data
    };
    if (!this.children) {
      return data;
    }
    data.children = [];
    ref = this.children;
    for (i = 0, len = ref.length; i < len; i++) {
      child = ref[i];
      data.children.push(child.getSaveData());
    }
    return data;
  };

  Node.prototype.__isCustomCSSEnabled = function() {
    return true;
  };

  Node.prototype.__showInternalNameField = function() {
    return true;
  };

  Node.prototype.isCopyAllowed = function() {
    return true;
  };

  Node.prototype.copy = function() {
    var child, i, len, opts, ref;
    if (!this.isCopyAllowed()) {
      return;
    }
    opts = {
      data: CUI.util.copyObject(this.getData(), true),
      open: this.isOpen()
    };
    if (this.children) {
      opts.children = [];
      ref = this.children;
      for (i = 0, len = ref.length; i < len; i++) {
        child = ref[i];
        opts.children.push(child.copy());
      }
    }
    return new this.constructor(opts);
  };

  Node.prototype.__addStyles = function(element) {
    var data, fieldStyles, group, i, len, ref, ref1, style, styles, value;
    if (!element) {
      return;
    }
    styles = {};
    data = this.getData();
    ref = this.__getStyleFieldSettings();
    for (group in ref) {
      fieldStyles = ref[group];
      for (i = 0, len = fieldStyles.length; i < len; i++) {
        style = fieldStyles[i];
        value = (ref1 = data[group]) != null ? ref1[style.field.name] : void 0;
        if (CUI.util.isUndef(value)) {
          continue;
        }
        if (style.name === "class-name") {
          CUI.dom.addClass(element, value);
          continue;
        }
        if (style.name === "position-absolute") {
          if (value) {
            styles["position"] = "absolute";
          }
          continue;
        }
        styles[style.name] = value;
      }
    }
    CUI.dom.setStyle(element, styles);
  };

  Node.prototype.__getStyleFieldSettings = function() {
    var availableStyleSettings, group, i, len, style, styleName, styleSettings, styles;
    availableStyleSettings = ez5.PdfCreator.Node.getAvailableStyleSettings();
    styleSettings = this.__getStyleSettings();
    styles = {};
    for (i = 0, len = styleSettings.length; i < len; i++) {
      styleName = styleSettings[i];
      style = availableStyleSettings[styleName];
      if (!style) {
        continue;
      }
      group = style.group;
      if (!styles[group]) {
        styles[group] = [];
      }
      styles[group].push({
        field: style.field,
        name: styleName
      });
    }
    return styles;
  };

  Node.prototype.__getIdObjecttype = function() {
    return this.__getDocumentNode().getIdObjecttype();
  };

  Node.prototype.__getObjecttypeName = function() {
    var idObjecttype;
    idObjecttype = this.__getIdObjecttype();
    return ez5.schema.CURRENT._table_by_id[idObjecttype].name;
  };

  Node.prototype.__getMask = function() {
    return this.__getDocumentNode().getMask();
  };

  Node.prototype.__getLayoutData = function() {
    var documentData, layoutData;
    documentData = this.__getDocumentNode().getData();
    layoutData = {
      mode: documentData.layout_mode,
      rows: documentData.layout_rows,
      columns: documentData.layout_columns,
      rowGap: documentData.row_gap,
      columnGap: documentData.column_gap,
      innerBorder: documentData.inner_border,
      outerBorder: documentData.outer_border
    };
    return layoutData;
  };

  Node.prototype.__getDocumentNode = function() {
    var root;
    root = this.getRoot();
    if (root instanceof ez5.PdfCreator.Node.Document) {
      return root;
    }
    if (root.children[0] instanceof ez5.PdfCreator.Node.Document) {
      return root.children[0];
    }
    throw new Error("PdfNode.__getDocumentNode :: PdfDocumentNode not initialized correctly.");
  };

  Node.prototype.__createStyleElement = function(styles) {
    var styleElement;
    styleElement = CUI.dom.element("style");
    styles = styles.replace(/\r?\n|\r/g, "");
    CUI.dom.append(styleElement, styles);
    return styleElement;
  };


  /* Methods to be implemented */

  Node.prototype.__onDataChanged = function(data, field) {};

  Node.prototype.__getSettingsFields = function() {
    return [];
  };

  Node.prototype.__getStyleSettings = function() {
    return [];
  };

  Node.prototype.__renderPdfContent = function() {
    return console.warn(CUI.util.getObjectClass(this) + ".__renderPdfContent needs to be implemented.");
  };

  return Node;

})(CUI.ListViewTreeNode);

ez5.PdfCreator.plugins = new CUI.PluginRegistry({
  "class": ez5.PdfCreator.Node
});
