class ez5.PdfCreator.Template.Row extends CUI.ListViewRow

	initOpts: ->
		super()
		@addOpts
			template:
				check: ez5.PdfCreator.Template
		return @

	readOpts: ->
		super()

		@__labelName = new CUI.Label(text: "")
		@__labelDateCreated = new CUI.Label(text: "")
		@__labelDateLastModified = new CUI.Label(text: "")
		@__labelUserCreate = new CUI.Label(text: "")
		@__labelUserLastModify = new CUI.Label(text: "")
		@addColumn(new CUI.ListViewColumn(element: @__labelName))
		@addColumn(new CUI.ListViewColumn(element: @__labelDateCreated))
		@addColumn(new CUI.ListViewColumn(element: @__labelDateLastModified))
		@addColumn(new CUI.ListViewColumn(element: @__labelUserCreate))
		@addColumn(new CUI.ListViewColumn(element: @__labelUserLastModify))

		@reload()
		return

	getData: ->
		return @_template.getData()

	reload: ->
		data = @getData()
		@__labelName.setText(@_template.getDisplayName())
		@__labelDateCreated.setText(ez5.format_date_and_time(data.date_created))
		@__labelDateLastModified.setText(ez5.format_date_and_time(data.date_last_modified))
		@__labelUserCreate.setText(data.user_create)
		@__labelUserLastModify.setText(data.user_last_modify)
		return

	@getHeader: ->
		header = new CUI.ListViewRow(selectable: false)
		header.addColumn(
			new CUI.ListViewHeaderColumn
				label:
					text: $$("pdf-creator.list.header.template-name|text")
		)
		header.addColumn(
			new CUI.ListViewHeaderColumn
				label:
					text: $$("pdf-creator.list.header.date-created|text")
		)
		header.addColumn(
			new CUI.ListViewHeaderColumn
				label:
					text: $$("pdf-creator.list.header.date-last-modified|text")
		)
		header.addColumn(
			new CUI.ListViewHeaderColumn
				label:
					text: $$("pdf-creator.list.header.user-create|text")
		)
		header.addColumn(
			new CUI.ListViewHeaderColumn
				label:
					text: $$("pdf-creator.list.header.user-last-modify|text")
		)
		return header