// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node.Document = (function(superClass) {
  extend(Document, superClass);

  function Document() {
    return Document.__super__.constructor.apply(this, arguments);
  }

  Document.FONT_AWESOME_CDN = "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css";

  Document.getName = function() {
    return "document";
  };

  Document.pageSizes = {
    "A3": {
      width: 29.7,
      height: 42
    },
    "A4": {
      width: 21,
      height: 29.7
    },
    "A5": {
      width: 14.8,
      height: 21
    },
    "B4": {
      width: 25,
      height: 35.3
    },
    "B5": {
      width: 17.6,
      height: 25
    },
    "Tabloid": {
      width: 27.9,
      height: 43.2
    },
    "Legal": {
      width: 21.6,
      height: 35.6
    },
    "Statement": {
      width: 14,
      height: 21.6
    },
    "Executive": {
      width: 18.4,
      height: 26.7
    },
    "Folio": {
      width: 21.6,
      height: 33
    },
    "Letter": {
      width: 21.6,
      height: 27.9
    }
  };

  Document.FILE_EXTENSION = ".pdf";

  Document.prototype.initOpts = function() {
    Document.__super__.initOpts.call(this);
    return this.addOpts({
      header: {
        check: "PlainObject",
        "default": {}
      },
      footer: {
        check: "PlainObject",
        "default": {}
      },
      idObjecttype: {
        check: "Integer",
        mandatory: true
      },
      idMask: {
        check: "Integer"
      }
    });
  };

  Document.prototype.readOpts = function() {
    Document.__super__.readOpts.call(this);
    this.setMask();
    this.__header = new ez5.PdfCreator.Header({
      data: this._header
    });
    this.__footer = new ez5.PdfCreator.Footer({
      data: this._footer
    });
    return this;
  };

  Document.prototype.isCopyAllowed = function() {
    return false;
  };

  Document.prototype.setMask = function(maskId) {
    var mask, maskName;
    if (maskId == null) {
      maskId = this._idMask;
    }
    mask = ez5.mask.CURRENT._mask_by_id[maskId];
    maskName = (mask != null ? mask.name : void 0) || "_all_fields";
    this.__mask = Mask.getMaskByMaskName(maskName, this._idObjecttype);
  };

  Document.prototype.isParentAllowed = function() {
    return false;
  };

  Document.prototype.setData = function(data) {
    Document.__super__.setData.call(this, data);
    if (!this.__data.page_size) {
      this.__data.page_size = "A4";
    }
    if (!this.__data.margin_top) {
      this.__data.margin_top = 1.016;
    }
    if (!this.__data.margin_bottom) {
      this.__data.margin_bottom = 1.016;
    }
    if (!this.__data.margin_left) {
      this.__data.margin_left = 1.016;
    }
    if (!this.__data.margin_right) {
      this.__data.margin_right = 1.016;
    }
    if (!this.__data.layout_mode) {
      this.__data.layout_mode = "one_object";
    }
    if (!this.__data.layout_rows) {
      this.__data.layout_rows = 1;
    }
    if (!this.__data.layout_columns) {
      this.__data.layout_columns = 1;
    }
    if (!this.__data.row_gap) {
      this.__data.row_gap = 0;
    }
    if (!this.__data.column_gap) {
      this.__data.column_gap = 0;
    }
    if (!this.__data.header_custom_html) {
      this.__data.header_custom_html = $$("pdf-creator.settings.node.document.header_custom_html|placeholder");
    }
  };

  Document.prototype.renderContent = function() {
    return (new CUI.Label({
      text: this.getDisplayName()
    })).DOM;
  };

  Document.prototype.renderPdf = function(_opts) {
    var body, html, opts;
    if (_opts == null) {
      _opts = {};
    }
    opts = CUI.Element.readOpts.call(this, _opts, "PdfDocumentNode.renderPdf", {
      preview: {
        check: Boolean,
        "default": false
      },
      objects: {
        check: function(obj) {
          return CUI.util.isArray(obj) && obj.every(function(_o) {
            return CUI.util.isPlainObject(_o);
          });
        }
      },
      selectedNode: {
        check: ez5.PdfCreator.Node
      },
      styles: {
        check: String
      },
      custom_css_url: {
        check: String
      }
    });
    html = this.__getHtmlElement(opts);
    opts.head = html.children[0];
    body = this.renderPdfContent(opts);
    CUI.dom.append(html, body);
    return html;
  };

  Document.prototype.__getHtmlElement = function(opts) {
    var customLinkTag, data, fontAwesomeLinkElement, head, headerCustomHTMLNodes, html, stylesTag;
    html = CUI.dom.$element("html", "pdf-print");
    head = CUI.dom.$element("head");
    CUI.dom.append(html, head);
    if (opts.preview) {
      CUI.dom.addClass(html, "pdf-print-preview");
    }
    data = this.getData();
    if (data.custom_css_url) {
      customLinkTag = this.__createLinkElement(data.custom_css_url);
      CUI.dom.append(head, customLinkTag);
    }
    if (opts.styles) {
      stylesTag = this.__createStyleElement(opts.styles);
      CUI.dom.append(head, stylesTag);
    }
    if (opts.custom_css_url) {
      customLinkTag = this.__createLinkElement(opts.custom_css_url);
      CUI.dom.append(head, customLinkTag);
    }
    headerCustomHTMLNodes = CUI.dom.htmlToNodes(data.header_custom_html);
    CUI.dom.append(head, headerCustomHTMLNodes);
    fontAwesomeLinkElement = this.__createLinkElement(ez5.PdfCreator.Node.Document.FONT_AWESOME_CDN);
    CUI.dom.append(head, fontAwesomeLinkElement);
    return html;
  };

  Document.prototype.__renderPdfContent = function(opts) {
    var body, div, footer, header;
    body = Document.__super__.__renderPdfContent.call(this, opts);
    if (opts.preview) {
      div = CUI.dom.div("pdf-print-preview-body");
      div.innerHTML = body.innerHTML;
      if (this.__getLayoutData().outerBorder) {
        CUI.dom.addClass(div, "outer-border");
      }
      CUI.dom.replace(body, div);
      CUI.dom.setStyle(body, {
        "padding-top": this.__data["margin_top"] + "cm",
        "padding-bottom": this.__data["margin_bottom"] + "cm",
        "padding-right": this.__data["margin_right"] + "cm",
        "padding-left": this.__data["margin_left"] + "cm"
      });
      footer = this.renderFooter(opts);
      header = this.renderHeader(opts);
      CUI.dom.prepend(body, header);
      CUI.dom.append(body, footer);
    }
    return body;
  };

  Document.prototype.getMaxCountPerPage = function() {
    var layoutData;
    layoutData = this.__getLayoutData();
    if (layoutData.mode === "one_object") {
      return 1;
    }
    return layoutData.rows * layoutData.columns;
  };

  Document.prototype.getFilename = function(object) {
    var filename;
    filename = this.getData().filename || $$("pdf-creator.settings.node.document.filename-dafault-value");
    filename = ez5.PdfCreatorUtils.replaceTextPlaceholders(filename, object);
    if (!filename.endsWith(ez5.PdfCreator.Node.Document.FILE_EXTENSION)) {
      filename += ez5.PdfCreator.Node.Document.FILE_EXTENSION;
    }
    return filename;
  };

  Document.prototype.getExtraSettingsPanels = function(opts) {
    var customHeadHTMLField, footerFields, headerFields, panels;
    if (opts == null) {
      opts = {};
    }
    headerFields = this.__header.getSettingsFields(opts);
    footerFields = this.__footer.getSettingsFields(opts);
    customHeadHTMLField = {
      type: CUI.CodeInput,
      mode: "html",
      name: "header_custom_html",
      maximize_horizontal: true
    };
    panels = [
      this.__createPanelField([customHeadHTMLField], {
        group: "header_custom_html",
        closed: true
      }), this.__createPanelField(headerFields, {
        group: "header",
        closed: true
      }), this.__createPanelField(footerFields, {
        group: "footer",
        closed: true
      })
    ];
    return panels;
  };

  Document.prototype.getTemplateName = function() {
    return this.getData().template_name;
  };

  Document.prototype.__getSettingsFields = function() {
    var colRowsOptions, data, fields, filenameHintButton, onLayoutChanged;
    data = this.getData();
    onLayoutChanged = (function(_this) {
      return function(field) {
        var _field, fieldName, fieldNames, form, i, len;
        form = field.getForm();
        fieldNames = ["inner_border", "layout_columns", "layout_rows", "row_gap", "column_gap"];
        for (i = 0, len = fieldNames.length; i < len; i++) {
          fieldName = fieldNames[i];
          _field = form.getFieldsByName(fieldName)[0];
          if (data.layout_mode === "one_object") {
            _field.disable();
          } else {
            _field.enable();
          }
        }
      };
    })(this);
    colRowsOptions = [
      {
        value: 1
      }, {
        value: 2
      }, {
        value: 3
      }, {
        value: 4
      }, {
        value: 5
      }, {
        value: 6
      }, {
        value: 7
      }, {
        value: 8
      }, {
        value: 9
      }, {
        value: 10
      }
    ];
    filenameHintButton = new CUI.Button({
      text: $$("pdf-creator.settings.node.document.filename|hint"),
      appearance: "flat",
      onClick: (function(_this) {
        return function() {
          var pop;
          pop = new ez5.HintPopover({
            element: filenameHintButton,
            content: new CUI.Label({
              text: $$("pdf-creator.settings.node.document.filename-popover"),
              markdown: true
            }),
            padded: true
          });
          return pop.show();
        };
      })(this)
    });
    fields = [
      {
        type: CUI.MultiInput,
        form: {
          label: $$("pdf-creator.settings.node.document.template-name|label")
        },
        control: ez5.loca.getLanguageControl(),
        name: "template_name"
      }, {
        type: CUI.Input,
        form: {
          label: $$("pdf-creator.settings.node.document.filename|label"),
          hint: filenameHintButton
        },
        name: "filename"
      }, {
        type: CUI.Select,
        form: {
          label: $$("pdf-creator.settings.node.document.orientation|label")
        },
        name: "orientation",
        options: [
          {
            text: $$("pdf-creator.settings.node.document.orientation.option.portrait"),
            value: false
          }, {
            text: $$("pdf-creator.settings.node.document.orientation.option.landscape"),
            value: true
          }
        ]
      }, {
        type: CUI.Select,
        form: {
          label: $$("pdf-creator.settings.node.document.paper-size|label")
        },
        name: "page_size",
        options: [
          {
            text: "A3 (29.7 cm x 42.0 cm)",
            value: "A3"
          }, {
            text: "A4 (21.0 cm x 29.7 cm)",
            value: "A4"
          }, {
            text: "A5 (14.8 cm x 21.0 cm)",
            value: "A5"
          }, {
            text: "B4 (25.0 cm x 35.3 cm)",
            value: "B4"
          }, {
            text: "B5 (17.6 cm x 25.0 cm)",
            value: "B5"
          }, {
            text: "Tabloid (27.9 cm x 43.2 cm)",
            value: "Tabloid"
          }, {
            text: "Legal (21.6 cm x 35.6 cm)",
            value: "Legal"
          }, {
            text: "Statement (14.0 cm x 21.6 cm)",
            value: "Statement"
          }, {
            text: "Executive (18.4 cm x 26.7 cm)",
            value: "Executive"
          }, {
            text: "Folio (21.6 cm x 33.0 cm)",
            value: "Folio"
          }, {
            text: "Letter (21.6 cm x 27.9 cm)",
            value: "Letter"
          }
        ]
      }, {
        type: CUI.NumberInput,
        form: {
          label: $$("pdf-creator.settings.node.document.margin-top|label")
        },
        name: "margin_top",
        decimals: 3,
        min: 0,
        max: 30
      }, {
        type: CUI.NumberInput,
        form: {
          label: $$("pdf-creator.settings.node.document.margin-bottom|label")
        },
        name: "margin_bottom",
        decimals: 3,
        min: 0,
        max: 30
      }, {
        type: CUI.NumberInput,
        form: {
          label: $$("pdf-creator.settings.node.document.margin-left|label")
        },
        name: "margin_left",
        decimals: 3,
        min: 0,
        max: 30
      }, {
        type: CUI.NumberInput,
        form: {
          label: $$("pdf-creator.settings.node.document.margin-right|label")
        },
        name: "margin_right",
        decimals: 3,
        min: 0,
        max: 30
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.document.outer-border|label")
        },
        name: "outer_border"
      }, {
        type: CUI.Options,
        name: "layout_mode",
        form: {
          label: $$("pdf-creator.settings.node.document.layout-mode|label")
        },
        radio: true,
        horizontal: false,
        options: [
          {
            text: $$("pdf-creator.settings.node.document.layout-mode.option.one-object"),
            value: "one_object"
          }, {
            text: $$("pdf-creator.settings.node.document.layout-mode.option.multiple-objects"),
            value: "multiple_objects"
          }
        ],
        onDataChanged: (function(_this) {
          return function(_data, field) {
            return onLayoutChanged(field);
          };
        })(this),
        onDataInit: onLayoutChanged
      }, {
        type: CUI.Select,
        name: "layout_rows",
        form: {
          label: $$("pdf-creator.settings.node.document.layout-rows|label")
        },
        options: colRowsOptions
      }, {
        type: CUI.Select,
        form: {
          label: $$("pdf-creator.settings.node.document.layout-columns|label")
        },
        name: "layout_columns",
        options: colRowsOptions
      }, {
        type: CUI.NumberInput,
        decimals: 2,
        min: 0,
        max: 100,
        form: {
          label: $$("pdf-creator.settings.node.document.row-gap|label")
        },
        name: "row_gap"
      }, {
        type: CUI.NumberInput,
        decimals: 2,
        min: 0,
        max: 100,
        form: {
          label: $$("pdf-creator.settings.node.document.column-gap|label")
        },
        name: "column_gap"
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.document.inner-border|label")
        },
        name: "inner_border"
      }, {
        type: CUI.Input,
        form: {
          label: $$("pdf-creator.settings.node.document.custom-css-url|label")
        },
        regexp: "^https?://[^/]+?([a-z0-9]|/.*)$",
        name: "custom_css_url"
      }
    ];
    return fields;
  };

  Document.prototype.__createLinkElement = function(url) {
    var linkElement;
    linkElement = CUI.dom.element("link", {
      rel: "stylesheet",
      href: url
    });
    return linkElement;
  };

  Document.prototype.__getPageSizes = function() {
    var pageSize;
    pageSize = this.getData().page_size;
    return ez5.PdfCreator.Node.Document.pageSizes[pageSize];
  };

  Document.prototype.getSaveData = function() {
    var data;
    data = Document.__super__.getSaveData.call(this);
    data.header = this.__header.getSaveData();
    data.footer = this.__footer.getSaveData();
    data.idObjecttype = this._idObjecttype;
    return data;
  };

  Document.prototype.getWidth = function() {
    var sizes;
    sizes = this.__getPageSizes();
    if (this.isLandscape()) {
      return sizes.height;
    } else {
      return sizes.width;
    }
  };

  Document.prototype.getHeight = function() {
    var sizes;
    sizes = this.__getPageSizes();
    if (this.isLandscape()) {
      return sizes.width;
    } else {
      return sizes.height;
    }
  };

  Document.prototype.isLandscape = function() {
    return this.getData().orientation;
  };

  Document.prototype.renderHeader = function(opts) {
    opts.documentNode = this;
    return this.__header.renderPdfContent(opts);
  };

  Document.prototype.renderFooter = function(opts) {
    opts.documentNode = this;
    return this.__footer.renderPdfContent(opts);
  };

  Document.prototype.getPaperWidth = function() {
    var sizes;
    sizes = this.__getPageSizes();
    return this.__cmToInch(sizes.width);
  };

  Document.prototype.getPaperHeight = function() {
    var sizes;
    sizes = this.__getPageSizes();
    return this.__cmToInch(sizes.height);
  };

  Document.prototype.getMargins = function(inchUnit) {
    var i, len, margin, margins, ref, side;
    if (inchUnit == null) {
      inchUnit = true;
    }
    margins = {};
    ref = ["top", "bottom", "left", "right"];
    for (i = 0, len = ref.length; i < len; i++) {
      side = ref[i];
      margin = this.__data["margin_" + side];
      margins[side] = inchUnit ? this.__cmToInch(margin) : margin;
    }
    return margins;
  };

  Document.prototype.__cmToInch = function(cm) {
    var inches;
    inches = cm / 2.54;
    return Math.round(inches * 10) / 10;
  };

  Document.prototype.__showInternalNameField = function() {
    return false;
  };

  Document.prototype.getMask = function() {
    return this.__mask;
  };

  Document.prototype.getIdObjecttype = function() {
    return this._idObjecttype;
  };

  Document.prototype.getHeader = function() {
    return this.__header;
  };

  Document.prototype.getFooter = function() {
    return this.__footer;
  };

  return Document;

})(ez5.PdfCreator.Node.Body);
