class ez5.PdfCreator.Node.FixedText extends ez5.PdfCreator.Node.Div

	@getName: ->
		"fixed_text"

	__renderPdfContent: ->
		data = @getData()
		span = CUI.dom.span()
		text = ez5.loca.getBestFrontendValue(data.loca_fixed_text) or "< #{$$("pdf-creator.settings.node.fixed-text.empty-text")} >"
		CUI.dom.append(span, text)
		return span

	__getSettingsFields: ->
		fields = [
			type: CUI.MultiInput
			form: label: $$("pdf-creator.settings.node.fixed-text.text|label")
			control: ez5.loca.getLanguageControl()
			name: "loca_fixed_text"
		]
		return fields

	__getStyleSettings: ->
		return [
			"class-name"
			"color"
			"font-size"
		]

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.FixedText)