import os
import subprocess
import tempfile

def easydb_server_start(easydb_context):
    logger = easydb_context.get_logger('producer.test')
    logger.debug('Hello, World!')

    easydb_context.register_callback('export_produce', {
        'callback': 'producer_test',
    })

def producer_test(easydb_context, protocol):
    logger = easydb_context.get_logger('producer.test')
    logger.debug('Hello again, World!')

    exp = easydb_context.get_exporter()
    logger.debug("exp: %s" % exp)

    if not exp:
        logger.error("could not get exporter object")
        return

    files = exp.getFiles()
    logger.debug("files: %s" % repr(files))

    f = tempfile.NamedTemporaryFile(delete = False)
    f.write('Xallo, Vorld')
    f.close()

    logger.debug("export definition: %s" % repr(exp.getExport()))

    logger.debug("produce_options: %s" % repr(exp.produce_options))

    exp.addFile(f.name, 'foo/bar.txt')
    exp.addFile(f.name, 'foo/baz.txt')

    exp.removeFile('foo/bar.txt')

    os.unlink(f.name)
