class BaseMigrationNodeTagGroups extends BaseMigrationNodeObjecttypes

	getDisplayText: ->
		$$("base.migration.node.tag.text")

	getActionFields: ->
		fields = BaseMigrationNodeTagGroup::getActionFields.call(@)

		fields[0] =
			type: CUI.Output
			form:
				label: $$("base.migration.node.tag_groups.text")
			text: $$("base.migration.node.tag_groups.all.text")
		fields

	migrate: (ev, action_data) ->
		target = CUI.util.copyObject(@getMigration().getBaseData().tags, true)

		console.debug "migrate all tag groups", ev, action_data

		new_target = []

		for c in @children
			c.migrateTagGroup(target, action_data)

		if ev.hasModifierKey()
			console.debug "migrate TagGroups:", CUI.util.dump(target), target
			return CUI.resolvedPromise()

		BaseMigrationNodeTagGroup::saveTags.call(@, target)

	checkMigrateButton: ->
		@__migrateBtn.enable()
