class BaseMigrationNodeTransition extends BaseMigrationNodeData

	getDisplayText: ->
		@getData().operations.join(", ")

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getActionFields: ->
		[
			type: CUI.Output
			placeholder: $$("base.migration.node.transition.no-settings")
		]

	checkMigrateButton: ->
		@__migrateBtn.enable()

	migrate: (ev, action_data) ->
		migration = @getMigration()

		target = CUI.util.copyObject(migration.getBaseData().transitions, true)

		copied_transition = migration.migrateTransition(@getData())

		if copied_transition
			target.push(copied_transition)

		if ev.hasModifierKey()
			console.debug "migrate Transition:", copied_transition, CUI.util.dump(target), target
			return CUI.resolvedPromise()

		CUI.rejectedPromise()

	saveTransitions: (transitions) ->
		@log($$("base.migration.console.log.transition.saving.md", count: transitions.length))
		ez5.api.transitions
			type: "POST"
			json_data: transitions
		.done (transitions) =>
			@log($$("base.migration.console.log.transition.migrated.md", count: transitions.length))
			console.debug "updating base data:", transitions
			@getMigration().getBaseData().transitions = transitions
		.fail =>
			@log($$("base.migration.console.log.transition.failed"))

	@getSourceNodesFromData: (migration, data) ->
		transitions = []
		for transition in data
			transitions.push(new BaseMigrationNodeTransition(migration: migration, data: transition))

		[new BaseMigrationNodeTransitions(migration: migration, children: transitions)]

