// Generated by CoffeeScript 1.12.7
CustomDataTypeDANTE.prototype.getJSKOSPreview = function(data, mapbox_access_token) {
  var altLabels, ancestors, bounds, colorPreview, definition, depictionPreview, encodedGeoJSON, endPlaces, example, hiddenLabels, html, htmlContent, i, imageSrc, json, jsonStr, key, key2, location, namewithpath, notations, prefLabel, prefLabels, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref18, ref19, ref2, ref20, ref21, ref3, ref4, ref5, ref6, ref7, ref8, ref9, scopeNote, size, spaces, startPlaces, that, tmpPrefLabel, val, val2, value, value2, vp, xuri;
  if (mapbox_access_token == null) {
    mapbox_access_token = false;
  }
  that = this;
  html = '';
  ancestors = '';
  spaces = '';
  namewithpath = '';
  if (data instanceof Array) {
    data = data[0];
  }
  prefLabel = $$('custom.data.type.dante.modal.form.popup.jskospreview.nopreflabel');
  if (data != null ? data.prefLabel : void 0) {
    prefLabel = that.getPrefLabelFromJSKOS(data);
  }
  xuri = data.uri.replace(/terminology/g, '...');
  html += '<div style="font-size: 12px; color: #999;"><span class="cui-label-icon"><i class="fa  fa-external-link"></i></span>&nbsp;' + xuri + '</div>';
  html += '<h3><span class="cui-label-icon"><i class="fa  fa-info-circle"></i></span>&nbsp;' + prefLabel + '</h3>';
  if (data.ancestors) {
    data.ancestors = data.ancestors.reverse();
    ref = data.ancestors;
    for (key in ref) {
      val = ref[key];
      if (val !== null) {
        tmpPrefLabel = that.getPrefLabelFromJSKOS(val);
        spaces = '';
        i = 0;
        while (i < key) {
          spaces += '&nbsp;&nbsp;';
          i++;
        }
        namewithpath += tmpPrefLabel + ' > ';
        ancestors += spaces + '<span class="danteTooltipAncestors"><span class="cui-label-icon"><i class="fa fa-sitemap" aria-hidden="true"></i></span> ' + tmpPrefLabel + '</span><br />';
      }
    }
  }
  if (ancestors !== '') {
    html += ancestors + spaces + '<span class="danteTooltipAncestors">&nbsp;&nbsp;<span class="cui-label-icon"><i class="fa fa-arrow-circle-o-right" aria-hidden="true"></i></span> ' + prefLabel + '</span><br />';
    namewithpath += prefLabel;
  }
  if (namewithpath === '') {
    namewithpath = prefLabel;
  }
  prefLabels = '';
  if (data != null ? data.prefLabel : void 0) {
    ref1 = data.prefLabel;
    for (key in ref1) {
      val = ref1[key];
      if (val !== prefLabel) {
        prefLabels = ' - ' + val + ' (' + key + ')<br />' + prefLabels;
      }
    }
  }
  if (prefLabels) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.terms') + '</h4>' + prefLabels;
  }
  altLabels = '';
  if (data.altLabel) {
    ref2 = data.altLabel;
    for (key in ref2) {
      val = ref2[key];
      for (key2 in val) {
        val2 = val[key2];
        altLabels = ' - ' + val2 + '<br />' + altLabels;
      }
    }
  }
  if (altLabels) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.altterms') + '</h4>' + altLabels;
  }
  hiddenLabels = [];
  if (data.hiddenLabel) {
    ref3 = data.hiddenLabel;
    for (key in ref3) {
      val = ref3[key];
      for (key2 in val) {
        val2 = val[key2];
        hiddenLabels.push(val2);
      }
    }
  }
  if (hiddenLabels.length > 0) {
    hiddenLabels = hiddenLabels.join(', ');
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.keywords') + '</h4>' + hiddenLabels;
  }
  notations = '';
  if (data.notation) {
    ref4 = data.notation;
    for (key in ref4) {
      val = ref4[key];
      notations = ' &#8226; ' + val + '<br />' + notations;
    }
  }
  if (notations) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.notations') + '</h4>' + notations;
  }
  startPlaces = [];
  if (data.startDate || data.startPlace) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.startDate') + '</h4>';
    if (data.startDate) {
      html += data.startDate + '<br />';
    }
    if (data.startPlace) {
      ref5 = data.startPlace;
      for (key in ref5) {
        val = ref5[key];
        startPlaces.push(' &#8226; ' + val.prefLabel.und);
      }
      startPlaces = startPlaces.filter(function(item, i, ar) {
        return ar.indexOf(item) === i;
      });
      html += startPlaces.join('<br />');
    }
  }
  endPlaces = [];
  if (data.endDate || data.endPlace) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.endDate') + '</h4>';
    if (data.endDate) {
      html += data.endDate + '<br />';
    }
    if (data.endPlace) {
      ref6 = data.endPlace;
      for (key in ref6) {
        val = ref6[key];
        endPlaces.push(' &#8226; ' + val.prefLabel.und);
      }
      endPlaces = endPlaces.filter(function(item, i, ar) {
        return ar.indexOf(item) === i;
      });
      html += endPlaces.join('<br />');
    }
  }
  if (data.depiction) {
    depictionPreview = '';
    ref7 = data.depiction;
    for (key in ref7) {
      value = ref7[key];
      depictionPreview += '<div class="depictionPreview" style="background-image: url(' + value + ')"></div>';
    }
    if (depictionPreview !== '') {
      html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.depiction') + '</h4>' + depictionPreview;
    }
  }
  if (notations !== '') {
    colorPreview = '';
    ref8 = data.notation;
    for (key in ref8) {
      value = ref8[key];
      if (/^#[0-9a-f]{6}/i.test(value)) {
        colorPreview += '<div class="colorPreview" style="background-color: ' + value + '"></div>';
      }
    }
    if (colorPreview !== '') {
      html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.colors') + '</h4>' + colorPreview;
    }
  }
  location = '';
  if (data.location) {
    if (data.location.length > 0) {
      if (mapbox_access_token) {
        ref9 = data.location;
        for (key in ref9) {
          value = ref9[key];
          value = JSON.parse('{"geometry": ' + JSON.stringify(value) + '}');
          htmlContent = '{"type": "FeatureCollection","features": []}';
          jsonStr = '{"type": "FeatureCollection","features": []}';
          json = JSON.parse(jsonStr);
          json.features.push(value);
          bounds = geojsonExtent(json);
          if (bounds) {
            size = [500, 300];
            vp = geoViewport.viewport(bounds, size);
            encodedGeoJSON = value;
            encodedGeoJSON.properties = {};
            encodedGeoJSON.type = "Feature";
            encodedGeoJSON.properties['stroke-width'] = 4;
            encodedGeoJSON.properties['stroke'] = '#C20000';
            encodedGeoJSON = JSON.stringify(encodedGeoJSON);
            encodedGeoJSON = encodeURIComponent(encodedGeoJSON);
            if (vp.zoom > 16) {
              vp.zoom = 15;
            }
            imageSrc = window.location.protocol + '//api.mapbox.com/v4/mapbox.streets-satellite/geojson(' + encodedGeoJSON + ')/' + vp.center.join(',') + ',' + vp.zoom + '/' + size.join('x') + '@2x.png?access_token=' + mapbox_access_token;
            htmlContent = "<div class=\"mapImage\" style=\"background-image: url('" + imageSrc + "');\"></div>";
            location += htmlContent;
          }
        }
        if (location !== '') {
          html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.georef') + '</h4>' + location;
        }
      }
    }
  }
  definition = '';
  if (data.definition) {
    if (data.definition.de) {
      ref10 = data.definition.de;
      for (key in ref10) {
        value = ref10[key];
        definition += value + '<br />';
      }
    }
    if (definition === '') {
      if (data.definition.en) {
        ref11 = data.definition.en;
        for (key in ref11) {
          value = ref11[key];
          definition += value + '<br />';
        }
      }
    }
    if (definition === '') {
      ref12 = data.definition;
      for (key in ref12) {
        value = ref12[key];
        ref13 = data.definition.key;
        for (key2 in ref13) {
          value2 = ref13[key2];
          definition += value2 + '<br />';
        }
      }
    }
  }
  if (definition) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.definition') + '</h4>' + definition;
  }
  scopeNote = '';
  if (data.scopeNote) {
    if (data.scopeNote.de) {
      ref14 = data.scopeNote.de;
      for (key in ref14) {
        value = ref14[key];
        scopeNote += value + '<br />';
      }
    }
    if (scopeNote === '') {
      if (data.scopeNote.en) {
        ref15 = data.scopeNote.en;
        for (key in ref15) {
          value = ref15[key];
          scopeNote += value + '<br />';
        }
      }
    }
    if (scopeNote === '') {
      ref16 = data.scopeNote;
      for (key in ref16) {
        value = ref16[key];
        ref17 = data.scopeNote.key;
        for (key2 in ref17) {
          value2 = ref17[key2];
          scopeNote += value2 + '<br />';
        }
      }
    }
  }
  if (scopeNote) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.scopenote') + '</h4>' + scopeNote;
  }
  example = '';
  if (data.example) {
    if (data.example.de) {
      ref18 = data.example.de;
      for (key in ref18) {
        value = ref18[key];
        example += value + '<br />';
      }
    }
    if (example === '') {
      if (data.example.en) {
        ref19 = data.example.en;
        for (key in ref19) {
          value = ref19[key];
          example += value + '<br />';
        }
      }
    }
    if (example === '') {
      ref20 = data.example;
      for (key in ref20) {
        value = ref20[key];
        ref21 = data.example.key;
        for (key2 in ref21) {
          value2 = ref21[key2];
          example += value2 + '<br />';
        }
      }
    }
  }
  if (example) {
    html += '<h4>' + $$('custom.data.type.dante.modal.form.popup.jskospreview.example') + '</h4>' + example;
  }
  html = '<style>.danteTooltip { padding: 10px; min-width:200px; } .danteTooltip h4 { margin-bottom: 0px; } .danteTooltip .danteTooltipAncestors { font-size: 13px; font-weight: bold; margin-top: 0px;} .danteTooltip .mapImage {background-color: #EFEFEF; position: relative; width: 100%; height: 150px; background-size: cover; background-repeat: no-repeat; margin-bottom: 6px; border-radius: 2px;} .danteTooltip .colorPreview{ width:100%; height: 100px; } .depictionPreview {background-size: contain; background-repeat: no-repeat; background-position: center center; width: 100%; height:150px; background-color: #EFEFEF;}</style><div class="danteTooltip">' + html + '</div>';
  return html;
};

CustomDataTypeDANTE.prototype.getPrefLabelFromJSKOS = function(jskos) {
  var desiredLanguage, frontendLanguages, key, prefLabel, prefLabelFallback, prefLabels, tmp, value;
  prefLabelFallback = $$("custom.data.type.dante.modal.form.popup.treeview.nopreflabel");
  if (!jskos.prefLabel) {
    return prefLabelFallback;
  }
  prefLabels = jskos.prefLabel;
  prefLabel = prefLabelFallback;
  desiredLanguage = ez5.loca.getLanguage();
  desiredLanguage = desiredLanguage.split('-');
  desiredLanguage = desiredLanguage[0];
  frontendLanguages = ez5.session.getConfigFrontendLanguages().slice();
  for (key in frontendLanguages) {
    value = frontendLanguages[key];
    tmp = value.split('-');
    tmp = tmp[0];
    frontendLanguages[key] = tmp;
  }
  if (prefLabels instanceof Array || prefLabels instanceof Object) {
    if (prefLabels.count === 0) {
      prefLabels = void 0;
    }
    if (prefLabels.hasOwnProperty(desiredLanguage)) {
      prefLabel = prefLabels[desiredLanguage];
    }
    if (!prefLabel || prefLabel === void 0 || prefLabel === 'undefined' || prefLabel === prefLabelFallback) {
      for (key in frontendLanguages) {
        value = frontendLanguages[key];
        if (prefLabels.hasOwnProperty(value)) {
          prefLabel = prefLabels[value];
        }
      }
      if (!prefLabel || prefLabel === void 0 || prefLabel === 'undefined' || prefLabel === prefLabelFallback) {
        for (key in prefLabels) {
          value = prefLabels[key];
          prefLabel = prefLabels[key];
          break;
        }
      }
    }
    return prefLabel;
  }
};
