// Generated by CoffeeScript 1.12.7
var geonamesUpdate;

geonamesUpdate = (function() {
  function geonamesUpdate() {}

  geonamesUpdate.prototype.__start_update = function(arg) {
    var availabilityCheck_xhr, geonames_username, plugin_config, server_config, testURL;
    server_config = arg.server_config, plugin_config = arg.plugin_config;
    geonames_username = false;
    if (server_config.base.system.update_interval_geonames.geonames_username !== '') {
      geonames_username = server_config.base.system.update_interval_geonames.geonames_username;
    }
    if (geonames_username) {
      testURL = 'https://ws.gbv.de/suggest/geonames2/?searchterm=G%C3%B6ttingen&featureclass=P&country=DE&count=50&ancestors=true&language=de&expand=false';
      availabilityCheck_xhr = new CUI.XHR({
        url: testURL
      });
      return availabilityCheck_xhr.start().done(function(data, status, statusText) {
        var dataStr;
        dataStr = JSON.stringify(data);
        if (dataStr.includes('Göttingen')) {
          return ez5.respondSuccess({
            state: {
              "start_update": new Date().toUTCString(),
              "databaseLanguages": server_config.base.system.languages.database,
              "geonames_username": geonames_username,
              "default_language": server_config.base.system.update_interval_geonames.default_language
            }
          });
        } else {
          return ez5.respondError("custom.data.type.geonames.update.error.generic", {
            error: "Test on geonames-API was not successfull!"
          });
        }
      });
    } else {
      return ez5.respondError("custom.data.type.geonames.update.error.generic", {
        error: "No geonames-username for API given!"
      });
    }
  };

  geonamesUpdate.prototype.__updateData = function(arg) {
    var chunkWorkPromise, databaseLanguages, defaultLanguage, default_language, geonamesURI, geonamesURIs, geonames_username, j, len, object, objects, objectsMap, objectsToUpdate, plugin_config, ref, state, that, timeout;
    objects = arg.objects, plugin_config = arg.plugin_config, state = arg.state;
    that = this;
    objectsMap = {};
    geonamesURIs = [];
    databaseLanguages = state.databaseLanguages;
    default_language = state.default_language;
    geonames_username = state.geonames_username;
    defaultLanguage = false;
    if (default_language) {
      if (typeof default_language === 'string' || default_language instanceof String) {
        if (default_language.length === 2) {
          defaultLanguage = default_language;
        }
      }
    }
    for (j = 0, len = objects.length; j < len; j++) {
      object = objects[j];
      if (!(object.identifier && object.data)) {
        continue;
      }
      geonamesURI = object.data.conceptURI;
      if (CUI.util.isEmpty(geonamesURI)) {
        continue;
      }
      if (!objectsMap[geonamesURI]) {
        objectsMap[geonamesURI] = [];
      }
      objectsMap[geonamesURI].push(object);
      geonamesURIs.push(geonamesURI);
    }
    if (geonamesURIs.length === 0) {
      return ez5.respondSuccess({
        payload: []
      });
    }
    timeout = ((ref = plugin_config.update) != null ? ref.timeout : void 0) || 0;
    timeout *= 1000;
    geonamesURIs = geonamesURIs.filter((function(_this) {
      return function(x, i, a) {
        return a.indexOf(x) === i;
      };
    })(this));
    objectsToUpdate = [];
    chunkWorkPromise = CUI.chunkWork.call(this, {
      items: geonamesURIs,
      chunk_size: 1,
      call: (function(_this) {
        return function(items) {
          var callUrl, deferred, encodedURL, extendedInfo_xhr, geonamesID, originalUri, uri;
          uri = items[0];
          originalUri = items[0];
          geonamesID = uri.replace('http://www.geonames.org/', '');
          geonamesID = geonamesID.replace('https://www.geonames.org/', '');
          geonamesID = geonamesID.replace('http://geonames.org/', '');
          geonamesID = geonamesID.replace('https://geonames.org/', '');
          encodedURL = encodeURIComponent('http://api.geonames.org/getJSON?formatted=true&geonameId=' + geonamesID + '&username=' + geonames_username + '&style=full');
          callUrl = 'https://jsontojsonp.gbv.de/?url=' + encodedURL;
          deferred = new CUI.Deferred();
          extendedInfo_xhr = new CUI.XHR({
            url: callUrl
          });
          extendedInfo_xhr.start().done(function(data, status, statusText) {
            var cdataFromObjectsMap, k, len1, objectsMapKey, ref1, resultsUri, updatedcdata;
            if (data != null ? data.geonameId : void 0) {
              if (data != null ? data.asciiName : void 0) {
                resultsUri = 'http://geonames.org/' + data.geonameId;
                ref1 = objectsMap[originalUri];
                for (objectsMapKey = k = 0, len1 = ref1.length; k < len1; objectsMapKey = ++k) {
                  cdataFromObjectsMap = ref1[objectsMapKey];
                  cdataFromObjectsMap = cdataFromObjectsMap.data;
                  updatedcdata = {};
                  updatedcdata.conceptName = ez5.GeonamesUtil.getConceptNameFromObject(data);
                  updatedcdata.conceptURI = ez5.GeonamesUtil.getConceptURIFromObject(data);
                  updatedcdata._fulltext = ez5.GeonamesUtil.getFullTextFromObject(data, databaseLanguages);
                  updatedcdata._standard = ez5.GeonamesUtil.getStandardTextFromObject(null, data, cdataFromObjectsMap, databaseLanguages);
                  updatedcdata.conceptAncestors = ez5.GeonamesUtil.getConceptAncestorsFromObject(data);
                  if (that.__hasChanges(objectsMap[originalUri][objectsMapKey].data, updatedcdata)) {
                    objectsMap[originalUri][objectsMapKey].data = updatedcdata;
                    objectsToUpdate.push(objectsMap[originalUri][objectsMapKey]);
                  }
                }
              }
            }
            return deferred.resolve();
          }).fail(function() {
            return deferred.reject();
          });
          return deferred.promise();
        };
      })(this)
    });
    return chunkWorkPromise.done((function(_this) {
      return function() {
        return ez5.respondSuccess({
          payload: objectsToUpdate
        });
      };
    })(this)).fail((function(_this) {
      return function() {
        return ez5.respondError("custom.data.type.geonames.update.error.generic", {
          error: "Error connecting to geonames"
        });
      };
    })(this));
  };

  geonamesUpdate.prototype.__hasChanges = function(objectOne, objectTwo) {
    var j, key, len, ref;
    ref = ["conceptName", "conceptURI", "_standard", "_fulltext", "conceptAncestors", "frontendLanguage"];
    for (j = 0, len = ref.length; j < len; j++) {
      key = ref[j];
      if (!CUI.util.isEqual(objectOne[key], objectTwo[key])) {
        return true;
      }
    }
    return false;
  };

  geonamesUpdate.prototype.main = function(data) {
    var j, key, len, ref;
    if (!data) {
      ez5.respondError("custom.data.type.geonames.update.error.payload-missing");
      return;
    }
    ref = ["action", "server_config", "plugin_config"];
    for (j = 0, len = ref.length; j < len; j++) {
      key = ref[j];
      if (!data[key]) {
        ez5.respondError("custom.data.type.geonames.update.error.payload-key-missing", {
          key: key
        });
        return;
      }
    }
    if (data.action === "start_update") {
      this.__start_update(data);
    } else if (data.action === "update") {
      if (!data.objects) {
        ez5.respondError("custom.data.type.geonames.update.error.objects-missing");
        return;
      }
      if (!(data.objects instanceof Array)) {
        ez5.respondError("custom.data.type.geonames.update.error.objects-not-array");
        return;
      }
      if (!data.state) {
        ez5.respondError("custom.data.type.geonames.update.error.state-missing");
        return;
      }
      if (!data.batch_info) {
        ez5.respondError("custom.data.type.geonames.update.error.batch_info-missing");
        return;
      }
      this.__updateData(data);
    } else {
      return ez5.respondError("custom.data.type.geonames.update.error.invalid-action", {
        action: data.action
      });
    }
  };

  return geonamesUpdate;

})();

module.exports = new geonamesUpdate();
