// Generated by CoffeeScript 1.12.7
var CustomDataTypeGeoref,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeGeoref = (function(superClass) {
  extend(CustomDataTypeGeoref, superClass);

  function CustomDataTypeGeoref() {
    return CustomDataTypeGeoref.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeGeoref.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-georef.georef";
  };

  CustomDataTypeGeoref.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.georef.name");
  };

  CustomDataTypeGeoref.prototype.showEditPopover = function(btn, data, cdata, layout, opts) {
    var that, xmapboxpane;
    that = this;
    xmapboxpane = new CUI.SimplePane({
      "class": "georef_mapbox_container",
      header_left: new CUI.Label({
        text: "Satellit und Straßen"
      }),
      content: new CUI.Label({
        text: ""
      })
    });
    this.popover = new CUI.Popover({
      element: btn,
      fill_space: "both",
      placement: "c",
      pane: {
        header_left: new CUI.Label({
          text: $$('custom.data.type.georef.name')
        }),
        footer_right: [],
        content: xmapboxpane
      },
      onHide: (function(_this) {
        return function() {
          return _this.__updateResult(cdata, layout, opts);
        };
      })(this)
    }).show();
    return this.__initMap(cdata, layout, opts);
  };

  CustomDataTypeGeoref.prototype.getMapboxAccessToken = function() {
    var mapbox_access_token, ref, ref1;
    mapbox_access_token = '';
    if ((ref = this.getCustomSchemaSettings().mapbox_access_token) != null ? ref.value : void 0) {
      mapbox_access_token = (ref1 = this.getCustomSchemaSettings().mapbox_access_token) != null ? ref1.value : void 0;
    } else {
      mapbox_access_token = false;
    }
    return mapbox_access_token;
  };

  CustomDataTypeGeoref.prototype.__initMap = function(cdata, layout, opts) {
    var container, data, draw, frontendLanguage, frontendLanguages, geoJSON, geocoder, i, map, ref, removeExistingFeatures, that, typebuttons;
    that = this;
    mapboxgl.accessToken = that.getMapboxAccessToken();
    container = document.getElementsByClassName('georef_mapbox_container')[0];
    container.removeAttribute('class');
    container.removeAttribute('style');
    container.removeAttribute('id');
    container.className = 'georef_mapbox_container';
    container.innerHTML = '';
    map = new mapboxgl.Map({
      container: container,
      style: 'mapbox://styles/mapbox/satellite-streets-v10',
      center: [9.935, 51.5338],
      zoom: 5,
      maxZoom: 20
    });
    map.dragRotate.disable();
    map.touchZoomRotate.disableRotation();
    if (((ref = this.getCustomSchemaSettings().use_geocoder) != null ? ref.value : void 0) === true) {
      frontendLanguage = frontendLanguages = ez5.loca.getLanguage();
      geocoder = new MapboxGeocoder({
        accessToken: mapboxgl.accessToken,
        language: frontendLanguage,
        marker: false,
        mapboxgl: mapboxgl
      });
      map.addControl(geocoder, 'top-left');
    }
    draw = new MapboxDraw({
      displayControlsDefault: false,
      controls: {
        polygon: true,
        point: true,
        line_string: true,
        trash: false
      }
    });
    map.addControl(draw);
    map.dragPan.enable();
    data = draw.getAll();
    if (cdata.conceptURI !== '' && cdata.conceptName !== '' && cdata.conceptURI !== void 0 && cdata.conceptName !== void 0) {
      geoJSON = JSON.parse(cdata.conceptURI);
      map.on('load', function() {
        map.addSource('Georeferenzierung', {
          'type': 'geojson',
          'data': geoJSON
        });
        that.addMapLayers(map, 'Georeferenzierung', 'Georeferenzierung', true);
        map.fitBounds(geojsonExtent(geoJSON), {
          padding: 20
        });
      });
    }
    map.on('click', function(e) {
      var coords, j, len, line, linePoints, polygonCoords, rewind, turfPolygon, type, value;
      data = draw.getAll();
      if (data.features.length === 1) {
        geoJSON = data.features[0];
        delete geoJSON.id;
        type = data.features[0].geometry.type;
        if (type === 'Point') {
          if (data.features[0].geometry.coordinates.length === 2) {
            geoJSON = JSON.stringify(geoJSON);
            coords = data.features[0].geometry.coordinates;
            coords = coords.join(' ');
            cdata.conceptURI = geoJSON;
            cdata.conceptName = 'Point';
            cdata._standard = {};
            cdata._standard.text = cdata.conceptName;
          }
        }
        if (type === 'LineString') {
          if (data.features[0].geometry.coordinates.length >= 2) {
            geoJSON = JSON.stringify(geoJSON);
            line = data.features[0].geometry.coordinates;
            linePoints = new Array;
            for (j = 0, len = line.length; j < len; j++) {
              value = line[j];
              linePoints.push(value.join(' '));
            }
            linePoints = linePoints.join(',');
            cdata.conceptURI = geoJSON;
            cdata.conceptName = 'LineString';
            cdata._standard = {};
            cdata._standard.text = cdata.conceptName;
          }
        }
        if (type === 'Polygon') {
          if (data.features[0].geometry.coordinates[0].length >= 5) {
            polygonCoords = data.features[0].geometry.coordinates;
            turfPolygon = turf.polygon.polygon(polygonCoords);
            rewind = turf.rewind(turfPolygon);
            geoJSON.geometry.coordinates = rewind.geometry.coordinates;
            geoJSON = JSON.stringify(geoJSON);
            cdata.conceptURI = geoJSON;
            cdata.conceptName = 'Polygon';
            cdata._standard = {};
            return cdata._standard.text = cdata.conceptName;
          }
        }
      }
    });
    typebuttons = document.getElementsByClassName('mapbox-gl-draw_ctrl-draw-btn');
    removeExistingFeatures = function() {
      cdata.conceptName = '';
      cdata.conceptURI = '';
      data = draw.getAll();
      return draw.deleteAll();
    };
    i = 0;
    while (i < typebuttons.length) {
      typebuttons[i].addEventListener('mousedown', removeExistingFeatures, false);
      i++;
    }
    return that.__updateResult(cdata, layout, opts);
  };

  CustomDataTypeGeoref.prototype.__getEditorFields = function(cdata) {
    var fields;
    fields = [];
    return fields;
  };

  CustomDataTypeGeoref.prototype.getDataStatus = function(cdata) {
    var exception, geoJSONCheck, json, typeCheck;
    if (cdata) {
      if (cdata.conceptURI && cdata.conceptName) {
        geoJSONCheck = 0;
        try {
          json = JSON.parse(cdata.conceptURI);
        } catch (error1) {
          exception = error1;
          json = null;
        }
        if (json) {
          geoJSONCheck = 1;
        }
        typeCheck = cdata.conceptName ? cdata.conceptName.trim() : void 0;
        if (geoJSONCheck && typeCheck) {
          return "ok";
        }
        if (cdata.conceptURI.trim() === '' && cdata.conceptName.trim() === '') {
          return "empty";
        }
        return "invalid";
      } else {
        return "empty";
      }
    } else {
      return "empty";
    }
  };

  CustomDataTypeGeoref.prototype.addMapLayers = function(map, source, id, interactive) {
    map.addLayer({
      'id': 'layerPolygon',
      'type': 'fill',
      'source': source,
      'interactive': interactive,
      'layout': {},
      'paint': {
        'fill-color': '#C20000',
        'fill-opacity': 0.5
      },
      'filter': ['==', '$type', 'Polygon']
    });
    map.addLayer({
      'id': 'layerLineString',
      'type': 'line',
      'source': source,
      'interactive': interactive,
      'layout': {
        'line-join': 'round',
        'line-cap': 'round'
      },
      'paint': {
        'line-color': '#C20000',
        'line-width': 4
      },
      'filter': ['==', '$type', 'LineString']
    });
    return map.addLayer({
      'id': 'layerPoint',
      'type': 'symbol',
      'source': source,
      'interactive': interactive,
      'layout': {
        'icon-image': 'embassy-15',
        'text-field': '',
        'text-font': ['Open Sans Semibold', 'Arial Unicode MS Bold'],
        'text-offset': [0, 0.6],
        'text-anchor': 'top'
      },
      'filter': ['==', '$type', 'Point']
    });
  };

  CustomDataTypeGeoref.prototype.initStaticMap = function(containerID, cdata, parentNode) {
    var container, that, timeout;
    that = this;
    timeout = 200;
    container = CUI.dom.findElement(parentNode.DOM, "#" + containerID);
    if (container) {
      timeout = 0;
    }
    return setTimeout(function() {
      var geoJSON, geojsonFromCdata, jsonStr, map, mapContent, mapbox_access_token;
      container = CUI.dom.findElement(parentNode.DOM, "#" + containerID);
      mapbox_access_token = that.getMapboxAccessToken();
      if (mapbox_access_token) {
        mapboxgl.accessToken = mapbox_access_token;
        mapContent = new CUI.Label({
          text: $$('custom.data.type.georef.edit.kartenansicht')
        });
        geojsonFromCdata = JSON.parse(cdata.conceptURI);
        if ((geojsonFromCdata != null ? geojsonFromCdata.type : void 0) !== "FeatureCollection") {
          jsonStr = '{"type": "FeatureCollection","features": []}';
          geoJSON = JSON.parse(jsonStr);
          geoJSON.features.push(geojsonFromCdata);
        } else {
          geoJSON = geojsonFromCdata;
        }
        map = new mapboxgl.Map({
          container: container,
          style: 'mapbox://styles/mapbox/satellite-streets-v10',
          center: [9.935, 51.5338],
          zoom: 5,
          maxZoom: 17,
          attributionControl: false,
          interactive: false
        });
        return map.on('load', function() {
          if (geojsonFromCdata) {
            map.addSource('Georeferenzierung', {
              'type': 'geojson',
              'data': geoJSON
            });
            that.addMapLayers(map, 'Georeferenzierung', 'Georeferenzierung', false);
            map.fitBounds(geojsonExtent(geoJSON), {
              padding: 20
            });
          }
          map.on('idle', function() {
            return map.resize();
          });
          return map.addControl(new mapboxgl.NavigationControl());
        });
      } else {
        return console.error("no mapbox-access-token for georef");
      }
    }, timeout);
  };

  CustomDataTypeGeoref.prototype.__updateResult = function(cdata, layout, opts) {
    var copyrightLabel, info, inputX, mapPane, options, searchsuggest_xhr, suggest_Menu_directInput, that;
    that = this;
    if (opts.data) {
      opts.data[that.name(opts)] = cdata;
    }
    if (cdata != null ? cdata.conceptURI : void 0) {
      copyrightLabel = new CUI.Label({
        text: "Copyright",
        size: "mini"
      });
      copyrightLabel.DOM.innerHTML = "©&nbsp;<a href='https://www.mapbox.com/about/maps/'>Mapbox</a>&nbsp;&nbsp;©&nbsp;<a href='http://www.openstreetmap.org/copyright'>OpenStreetMap</a>&nbsp;&nbsp;<strong><a href='https://www.mapbox.com/map-feedback/' target='_blank'>Improve this map</a></strong>";
      info = new CUI.VerticalLayout({
        "class": 'ez5-info_commonPlugin',
        top: {
          content: mapPane = new CUI.Pane({
            "class": "cui-mapbox-georef-pane",
            top: {
              content: [
                new CUI.PaneHeader({
                  left: {
                    content: new CUI.Label({
                      text: cdata.conceptName + ' (' + $$('custom.data.type.georef.edit.kartenansicht') + ')'
                    })
                  }
                })
              ]
            },
            center: {
              content: new CUI.SimplePane({
                id: "georef_mapbox_container_static",
                "class": "georef_mapbox_container_static",
                content: new CUI.Label({
                  text: ""
                })
              })
            },
            bottom: {
              content: [
                new CUI.PaneFooter({
                  left: {
                    content: copyrightLabel
                  },
                  right: {
                    content: ""
                  }
                })
              ]
            }
          })
        }
      });
      that.initStaticMap('georef_mapbox_container_static', cdata, info);
      layout.replace(info, 'center');
      layout.addClass('ez5-linked-object-edit');
      options = {
        "class": 'ez5-linked-object-container'
      };
      layout.__initPane(options, 'center');
    }
    if (!(cdata != null ? cdata.conceptURI : void 0)) {
      suggest_Menu_directInput;
      inputX = new CUI.Input({
        "class": "pluginDirectSelectEditInput",
        undo_and_changed_support: false,
        name: "directSelectInput",
        content_size: false,
        onKeyup: (function(_this) {
          return function(input) {
            return input.setValue('');
          };
        })(this)
      });
      inputX.render();
      suggest_Menu_directInput = new CUI.Menu({
        element: inputX,
        use_element_width_as_min_width: true
      });
      searchsuggest_xhr = {
        "xhr": void 0
      };
      layout.replace(inputX, 'center');
      layout.removeClass('ez5-linked-object-edit');
      options = {
        "class": ''
      };
      layout.__initPane(options, 'center');
    }
    if (!(opts != null ? opts.deleteDataFromPlugin : void 0) === true) {
      return that.__setEditorFieldStatus(cdata, layout);
    }
  };

  CustomDataTypeGeoref.prototype.getCustomButtonBarEntryForTextInput = function(that, data, cdata, opts) {
    var addNewLineString, addNewPoint, addNewPolygon, newCustomBarEntrys, ref, ref1, ref2, ref3, ref4, ref5;
    if (opts == null) {
      opts = {};
    }
    newCustomBarEntrys = [];
    if (((ref = that.getCustomSchemaSettings()) != null ? (ref1 = ref.allow_textinput_point) != null ? ref1.value : void 0 : void 0) === true) {
      addNewPoint = {
        text: $$('custom.data.type.georef.controls.addnew.point.label'),
        value: 'new',
        name: 'addnewPointFromGEOREFPlugin',
        icon_left: new CUI.Icon({
          "class": "fa-plus"
        }),
        onClick: (function(_this) {
          return function() {
            var pointForm;
            pointForm = new CUI.Form({
              name: "pointForm",
              "class": "georefTextInputForm",
              fields: [
                {
                  form: {
                    label: $$("custom.data.type.georef.add_new.modal.form.latitude"),
                    hint: $$("custom.data.type.georef.add_new.modal.form.latitude.hint")
                  },
                  type: CUI.Input,
                  name: "georef_add_new_point.latitude"
                }, {
                  form: {
                    label: $$("custom.data.type.georef.add_new.modal.form.longitude"),
                    hint: $$("custom.data.type.georef.add_new.modal.form.longitude.hint")
                  },
                  type: CUI.Input,
                  name: "georef_add_new_point.longitude"
                }
              ]
            });
            pointForm.start();
            that.dotsButtonMenu.hide();
            that.modalManualinput = new CUI.Modal({
              placement: "c",
              pane: {
                "class": "cui-pane",
                header_left: new CUI.Label({
                  text: $$("custom.data.type.georef.add_new.point.header_left")
                }),
                content: pointForm,
                footer_right: function() {
                  return [
                    new CUI.Button({
                      text: $$("custom.data.type.georef.add_new.modal.cancel_button"),
                      "class": "cui-dialog",
                      onClick: function() {
                        return that.modalManualinput.destroy();
                      }
                    }), new CUI.Button({
                      text: $$("custom.data.type.georef.add_new.modal.ok"),
                      "class": "cui-dialog",
                      onClick: function() {
                        var floatLatitude, floatLongitude, latitude, longitude, pointGeoJSON;
                        latitude = pointForm.getFieldsByName('georef_add_new_point.latitude')[0].getValue();
                        longitude = pointForm.getFieldsByName('georef_add_new_point.longitude')[0].getValue();
                        floatLatitude = parseFloat(latitude);
                        floatLongitude = parseFloat(longitude);
                        if (!isNaN(floatLatitude) && !isNaN(floatLongitude)) {
                          pointGeoJSON = '{ "type": "Feature", "properties": {}, "geometry": { "coordinates": [ ' + floatLatitude + ', ' + floatLongitude + ' ], "type": "Point" } }';
                          cdata.conceptURI = pointGeoJSON;
                          cdata.conceptName = 'Point';
                          cdata._standard = {};
                          cdata._standard.text = cdata.conceptName;
                          that.__updateResult(cdata, that.layout, opts);
                          return that.modalManualinput.destroy();
                        } else {
                          return CUI.alert({
                            text: $$("custom.data.type.georef.add_new.modal.error")
                          });
                        }
                      }
                    })
                  ];
                }
              }
            });
            that.modalManualinput.show();
            return that.modalManualinput.autoSize();
          };
        })(this)
      };
      newCustomBarEntrys.push(addNewPoint);
    }
    if (((ref2 = that.getCustomSchemaSettings()) != null ? (ref3 = ref2.allow_textinput_linestring) != null ? ref3.value : void 0 : void 0) === true) {
      addNewLineString = {
        text: $$('custom.data.type.georef.controls.addnew.linestring.label'),
        value: 'new',
        name: 'addnewLineStringFromGEOREFPlugin',
        icon_left: new CUI.Icon({
          "class": "fa-plus"
        }),
        onClick: (function(_this) {
          return function() {
            var lineStringForm;
            lineStringForm = new CUI.Form({
              name: "lineStringForm",
              "class": "georefTextInputForm",
              fields: [
                {
                  form: {
                    label: $$("custom.data.type.georef.add_new.modal.form.linestring")
                  },
                  type: CUI.Input,
                  name: "georef_add_new_point.linestring",
                  textarea: true
                }, {
                  form: {
                    label: $$("custom.data.type.georef.add_new.modal.form.hintlabel"),
                    hint: $$("custom.data.type.georef.add_new.modal.form.linestring.examples")
                  },
                  type: CUI.Output,
                  text: $$("custom.data.type.georef.add_new.modal.form.linestring.hints")
                }
              ]
            });
            lineStringForm.start();
            that.dotsButtonMenu.hide();
            that.modalManualinput = new CUI.Modal({
              placement: "c",
              pane: {
                "class": "cui-pane",
                header_left: new CUI.Label({
                  text: $$("custom.data.type.georef.add_new.linestring.header_left")
                }),
                content: lineStringForm,
                footer_right: function() {
                  return [
                    new CUI.Button({
                      text: $$("custom.data.type.georef.add_new.modal.cancel_button"),
                      "class": "cui-dialog",
                      onClick: function() {
                        return that.modalManualinput.destroy();
                      }
                    }), new CUI.Button({
                      text: $$("custom.data.type.georef.add_new.modal.ok"),
                      "class": "cui-dialog",
                      onClick: function() {
                        var error, geoJSONLineString, geoJSONLineStringStr, isValidLineString, lineStringGeoJSON;
                        geoJSONLineStringStr = lineStringForm.getFieldsByName('georef_add_new_point.linestring')[0].getValue();
                        try {
                          geoJSONLineString = JSON.parse(geoJSONLineStringStr);
                          isValidLineString = Array.isArray(geoJSONLineString) && geoJSONLineString.every(function(coord) {
                            return Array.isArray(coord) && coord.length === 2 && coord.every(function(val) {
                              return typeof val === 'number' && !isNaN(val);
                            });
                          });
                          if (isValidLineString) {
                            lineStringGeoJSON = '{ "type": "Feature", "properties": {}, "geometry": { "coordinates": ' + geoJSONLineStringStr + ', "type": "LineString" } }';
                            cdata.conceptURI = lineStringGeoJSON;
                            cdata.conceptName = 'LineString';
                            cdata._standard = {};
                            cdata._standard.text = cdata.conceptName;
                            that.__updateResult(cdata, that.layout, opts);
                            return that.modalManualinput.destroy();
                          } else {
                            return CUI.alert({
                              text: $$("custom.data.type.georef.add_new.modal.error")
                            });
                          }
                        } catch (error1) {
                          error = error1;
                          return CUI.alert({
                            text: $$("custom.data.type.georef.add_new.modal.error")
                          });
                        }
                      }
                    })
                  ];
                }
              }
            });
            that.modalManualinput.show();
            return that.modalManualinput.autoSize();
          };
        })(this)
      };
      newCustomBarEntrys.push(addNewLineString);
    }
    if (((ref4 = that.getCustomSchemaSettings()) != null ? (ref5 = ref4.allow_textinput_polygon) != null ? ref5.value : void 0 : void 0) === true) {
      addNewPolygon = {
        text: $$('custom.data.type.georef.controls.addnew.polygon.label'),
        value: 'new',
        name: 'addnewPolygpnFromGEOREFPlugin',
        icon_left: new CUI.Icon({
          "class": "fa-plus"
        }),
        onClick: (function(_this) {
          return function() {
            var polygonForm;
            polygonForm = new CUI.Form({
              name: "polygonForm",
              "class": "georefTextInputForm",
              fields: [
                {
                  form: {
                    label: $$("custom.data.type.georef.add_new.modal.form.polygon")
                  },
                  type: CUI.Input,
                  name: "georef_add_new_point.polygon",
                  textarea: true
                }, {
                  form: {
                    label: $$("custom.data.type.georef.add_new.modal.form.hintlabel"),
                    hint: $$("custom.data.type.georef.add_new.modal.form.polygon.examples")
                  },
                  type: CUI.Output,
                  text: $$("custom.data.type.georef.add_new.modal.form.polygon.hints")
                }
              ]
            });
            polygonForm.start();
            that.dotsButtonMenu.hide();
            that.modalManualinput = new CUI.Modal({
              placement: "c",
              pane: {
                "class": "cui-pane",
                header_left: new CUI.Label({
                  text: $$("custom.data.type.georef.add_new.polygon.header_left")
                }),
                content: polygonForm,
                footer_right: function() {
                  return [
                    new CUI.Button({
                      text: $$("custom.data.type.georef.add_new.modal.cancel_button"),
                      "class": "cui-dialog",
                      onClick: function() {
                        return that.modalManualinput.destroy();
                      }
                    }), new CUI.Button({
                      text: $$("custom.data.type.georef.add_new.modal.ok"),
                      "class": "cui-dialog",
                      onClick: function() {
                        var error, geoJSONPolygon, geoJSONPolygonStr, isValidPolygon, polygonGeoJSON;
                        geoJSONPolygonStr = polygonForm.getFieldsByName('georef_add_new_point.polygon')[0].getValue();
                        try {
                          geoJSONPolygon = JSON.parse(geoJSONPolygonStr);
                          isValidPolygon = Array.isArray(geoJSONPolygon) && geoJSONPolygon.length === 1 && geoJSONPolygon[0].length >= 4 && geoJSONPolygon[0].every(function(coord) {
                            return Array.isArray(coord) && coord.length === 2 && coord.every(function(val) {
                              return typeof val === 'number' && !isNaN(val);
                            });
                          });
                          if (isValidPolygon) {
                            polygonGeoJSON = '{ "type": "Feature", "properties": {}, "geometry": { "coordinates": ' + geoJSONPolygonStr + ', "type": "Polygon" } }';
                            cdata.conceptURI = polygonGeoJSON;
                            cdata.conceptName = 'Polygon';
                            cdata._standard = {};
                            cdata._standard.text = cdata.conceptName;
                            that.__updateResult(cdata, that.layout, opts);
                            return that.modalManualinput.destroy();
                          } else {
                            return CUI.alert({
                              text: $$("custom.data.type.georef.add_new.modal.error")
                            });
                          }
                        } catch (error1) {
                          error = error1;
                          return CUI.alert({
                            text: $$("custom.data.type.georef.add_new.modal.error")
                          });
                        }
                      }
                    })
                  ];
                }
              }
            });
            that.modalManualinput.show();
            return that.modalManualinput.autoSize();
          };
        })(this)
      };
      newCustomBarEntrys.push(addNewPolygon);
    }
    return newCustomBarEntrys;
  };

  CustomDataTypeGeoref.prototype.renderEditorInput = function(data, top_level_data, opts) {
    var cdata, customButtonBarEntrys, ref, ref1, ref2, ref3, ref4, ref5, that;
    that = this;
    if (!data[this.name()] && !(typeof cdata !== "undefined" && cdata !== null ? cdata.conceptURI : void 0) && !(typeof cdata !== "undefined" && cdata !== null ? cdata.conceptName : void 0)) {
      cdata = {
        conceptName: '',
        conceptURI: ''
      };
      data[this.name()] = cdata;
    } else {
      cdata = data[this.name()];
    }
    if (((ref = this.getCustomSchemaSettings()) != null ? (ref1 = ref.allow_textinput_point) != null ? ref1.value : void 0 : void 0) === true || ((ref2 = this.getCustomSchemaSettings()) != null ? (ref3 = ref2.allow_textinput_linestring) != null ? ref3.value : void 0 : void 0) === true || ((ref4 = this.getCustomSchemaSettings()) != null ? (ref5 = ref4.allow_textinput_polygon) != null ? ref5.value : void 0 : void 0) === true) {
      customButtonBarEntrys = that.getCustomButtonBarEntryForTextInput(that, data, cdata, opts);
    }
    return this.__renderEditorInputPopover(data, cdata, opts, customButtonBarEntrys);
  };

  CustomDataTypeGeoref.prototype.__renderButtonByData = function(cdata) {
    var copyrightLabel, mapPane, that;
    that = this;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.georef.edit.no_georef")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.georef.edit.no_valid_georef")
        }).DOM;
    }
    copyrightLabel = new CUI.Label({
      text: "Copyright",
      size: "mini"
    });
    copyrightLabel.DOM.innerHTML = "©&nbsp;<a href='https://www.mapbox.com/about/maps/'>Mapbox</a>&nbsp;&nbsp;©&nbsp;<a href='http://www.openstreetmap.org/copyright'>OpenStreetMap</a>&nbsp;&nbsp;<strong><a href='https://www.mapbox.com/map-feedback/' target='_blank'>Improve this map</a></strong>";
    mapPane = new CUI.Pane({
      "class": "cui-mapbox-georef-pane",
      top: {
        content: [
          new CUI.PaneHeader({
            left: {
              content: new CUI.Label({
                text: cdata.conceptName + ' (' + $$('custom.data.type.georef.edit.kartenansicht') + ')'
              })
            },
            right: {
              content: [CUI.Pane.getToggleFillScreenButton()]
            }
          })
        ]
      },
      center: {
        content: new CUI.SimplePane({
          id: "georef_mapbox_container_static",
          "class": "georef_mapbox_container_static",
          content: new CUI.Label({
            text: ""
          })
        })
      },
      bottom: {
        content: [
          new CUI.PaneFooter({
            left: {
              content: copyrightLabel
            },
            right: {
              content: ""
            }
          })
        ]
      }
    });
    that.initStaticMap('georef_mapbox_container_static', cdata, mapPane);
    return mapPane.DOM;
  };

  CustomDataTypeGeoref.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var ref, ref1, ref2, ref3, ref4, ref5, tags;
    tags = [];
    if ((ref = custom_settings.mapbox_access_token) != null ? ref.value : void 0) {
      tags.push("✓ Mapbox-Access-Token");
    } else {
      tags.push("✘ Mapbox-Access-Token");
    }
    if ((ref1 = custom_settings.use_geocoder) != null ? ref1.value : void 0) {
      tags.push("✓ Geocoder");
    } else {
      tags.push("✘ Geocoder");
    }
    if ((ref2 = custom_settings.mapbox_access_token) != null ? ref2.value : void 0) {
      tags.push("✓ Mapbox-Access-Token");
    } else {
      tags.push("✘ Mapbox-Access-Token");
    }
    if ((ref3 = custom_settings.allow_textinput_point) != null ? ref3.value : void 0) {
      tags.push("✓ Textinput POINT");
    } else {
      tags.push("✘ Textinput POINT");
    }
    if ((ref4 = custom_settings.allow_textinput_linestring) != null ? ref4.value : void 0) {
      tags.push("✓ Textinput LINESTRING");
    } else {
      tags.push("✘ Textinput LINESTRING");
    }
    if ((ref5 = custom_settings.allow_textinput_polygon) != null ? ref5.value : void 0) {
      tags.push("✓ Textinput POLYGON");
    } else {
      tags.push("✘ Textinput POLYGON");
    }
    return tags;
  };

  return CustomDataTypeGeoref;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeGeoref);
